package physx.physics;

import physx.NativeObject;

public class PxFilterData extends NativeObject {

    public static PxFilterData wrapPointer(long address) {
        return new PxFilterData(address);
    }
    
    protected PxFilterData(long address) {
        super(address);
    }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;

    // Placed Constructors

    /**
     * @param address where the object is allocated
     * @return Stack allocated object of PxFilterData
     */
    public static PxFilterData malloc(long address) {
        __placement_new_PxFilterData(address);
        PxFilterData mallocedObj = wrapPointer(address);
        mallocedObj.isStackAllocated = true;
        return mallocedObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @return Stack allocated object of PxFilterData
     */
    public static <T> PxFilterData malloc(T allocator, Allocator<T> allocate) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxFilterData(address);
        PxFilterData mallocedObj = wrapPointer(address);
        mallocedObj.isStackAllocated = true;
        return mallocedObj;
    }

    private static native void __placement_new_PxFilterData(long address);

    /**
     * @param address where the object is allocated
     * @param w0      unsigned long
     * @param w1      unsigned long
     * @param w2      unsigned long
     * @param w3      unsigned long
     * @return Stack allocated object of PxFilterData
     */
    public static PxFilterData malloc(long address, int w0, int w1, int w2, int w3) {
        __placement_new_PxFilterData(address, w0, w1, w2, w3);
        PxFilterData mallocedObj = wrapPointer(address);
        mallocedObj.isStackAllocated = true;
        return mallocedObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @param w0        unsigned long
     * @param w1        unsigned long
     * @param w2        unsigned long
     * @param w3        unsigned long
     * @return Stack allocated object of PxFilterData
     */
    public static <T> PxFilterData malloc(T allocator, Allocator<T> allocate, int w0, int w1, int w2, int w3) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxFilterData(address, w0, w1, w2, w3);
        PxFilterData mallocedObj = wrapPointer(address);
        mallocedObj.isStackAllocated = true;
        return mallocedObj;
    }

    private static native void __placement_new_PxFilterData(long address, int w0, int w1, int w2, int w3);

    // Constructors

    public PxFilterData() {
        address = _PxFilterData();
    }
    private static native long _PxFilterData();

    /**
     * @param w0 unsigned long
     * @param w1 unsigned long
     * @param w2 unsigned long
     * @param w3 unsigned long
     */
    public PxFilterData(int w0, int w1, int w2, int w3) {
        address = _PxFilterData(w0, w1, w2, w3);
    }
    private static native long _PxFilterData(int w0, int w1, int w2, int w3);

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isStackAllocated) {
            throw new IllegalStateException(this + " is stack allocated and cannot be deleted");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return unsigned long
     */
    public int getWord0() {
        return _getWord0(address);
    }
    private static native int _getWord0(long address);

    /**
     * @param value unsigned long
     */
    public void setWord0(int value) {
        _setWord0(address, value);
    }
    private static native void _setWord0(long address, int value);

    /**
     * @return unsigned long
     */
    public int getWord1() {
        return _getWord1(address);
    }
    private static native int _getWord1(long address);

    /**
     * @param value unsigned long
     */
    public void setWord1(int value) {
        _setWord1(address, value);
    }
    private static native void _setWord1(long address, int value);

    /**
     * @return unsigned long
     */
    public int getWord2() {
        return _getWord2(address);
    }
    private static native int _getWord2(long address);

    /**
     * @param value unsigned long
     */
    public void setWord2(int value) {
        _setWord2(address, value);
    }
    private static native void _setWord2(long address, int value);

    /**
     * @return unsigned long
     */
    public int getWord3() {
        return _getWord3(address);
    }
    private static native int _getWord3(long address);

    /**
     * @param value unsigned long
     */
    public void setWord3(int value) {
        _setWord3(address, value);
    }
    private static native void _setWord3(long address, int value);

}
