package physx.physics;

import physx.NativeObject;

public class PxBatchQuery extends NativeObject {

    protected PxBatchQuery() { }

    public static PxBatchQuery wrapPointer(long address) {
        return new PxBatchQuery(address);
    }
    
    protected PxBatchQuery(long address) {
        super(address);
    }

    // Functions

    public void execute() {
        _execute(address);
    }
    private static native void _execute(long address);

    /**
     * @return {@link PxBatchQueryPreFilterShader} [Value]
     */
    public PxBatchQueryPreFilterShader getPreFilterShader() {
        return PxBatchQueryPreFilterShader.wrapPointer(_getPreFilterShader(address));
    }
    private static native long _getPreFilterShader(long address);

    /**
     * @return {@link PxBatchQueryPostFilterShader} [Value]
     */
    public PxBatchQueryPostFilterShader getPostFilterShader() {
        return PxBatchQueryPostFilterShader.wrapPointer(_getPostFilterShader(address));
    }
    private static native long _getPostFilterShader(long address);

    /**
     * @return any [Const]
     */
    public NativeObject getFilterShaderData() {
        return NativeObject.wrapPointer(_getFilterShaderData(address));
    }
    private static native long _getFilterShaderData(long address);

    /**
     * @return unsigned long
     */
    public int getFilterShaderDataSize() {
        return _getFilterShaderDataSize(address);
    }
    private static native int _getFilterShaderDataSize(long address);

    /**
     * @param userMemory {@link PxBatchQueryMemory} [Const, Ref]
     */
    public void setUserMemory(PxBatchQueryMemory userMemory) {
        _setUserMemory(address, userMemory.getAddress());
    }
    private static native void _setUserMemory(long address, long userMemory);

    /**
     * @return {@link PxBatchQueryMemory} [Const, Ref]
     */
    public PxBatchQueryMemory getUserMemory() {
        return PxBatchQueryMemory.wrapPointer(_getUserMemory(address));
    }
    private static native long _getUserMemory(long address);

    public void release() {
        _release(address);
    }
    private static native void _release(long address);

}
