package physx.geomutils;


public class PxSphereGeometry extends PxGeometry {

    protected PxSphereGeometry() { }

    public static PxSphereGeometry wrapPointer(long address) {
        return new PxSphereGeometry(address);
    }
    
    protected PxSphereGeometry(long address) {
        super(address);
    }

    // Constructors

    /**
     * @param ir float
     */
    public PxSphereGeometry(float ir) {
        address = _PxSphereGeometry(ir);
    }
    private static native long _PxSphereGeometry(float ir);

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isStackAllocated) {
            throw new IllegalStateException(this + " is stack allocated and cannot be deleted");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

}
