package physx.geomutils;


public class PxPlaneGeometry extends PxGeometry {

    public static PxPlaneGeometry wrapPointer(long address) {
        return new PxPlaneGeometry(address);
    }
    
    protected PxPlaneGeometry(long address) {
        super(address);
    }

    // Constructors

    public PxPlaneGeometry() {
        address = _PxPlaneGeometry();
    }
    private static native long _PxPlaneGeometry();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isStackAllocated) {
            throw new IllegalStateException(this + " is stack allocated and cannot be deleted");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

}
