package physx.geomutils;

import physx.NativeObject;

public class PxHullPolygon extends NativeObject {

    public static PxHullPolygon wrapPointer(long address) {
        return new PxHullPolygon(address);
    }
    
    protected PxHullPolygon(long address) {
        super(address);
    }

    // Constructors

    public PxHullPolygon() {
        address = _PxHullPolygon();
    }
    private static native long _PxHullPolygon();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isStackAllocated) {
            throw new IllegalStateException(this + " is stack allocated and cannot be deleted");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @param index Array index
     * @return float
     */
    public float getMPlane(int index) {
        return _getMPlane(address, index);
    }
    private static native float _getMPlane(long address, int index);

    /**
     * @param index Array index
     * @param value float
     */
    public void setMPlane(int index, float value) {
        _setMPlane(address, index, value);
    }
    private static native void _setMPlane(long address, int index, float value);

    /**
     * @return short
     */
    public short getMNbVerts() {
        return _getMNbVerts(address);
    }
    private static native short _getMNbVerts(long address);

    /**
     * @param value short
     */
    public void setMNbVerts(short value) {
        _setMNbVerts(address, value);
    }
    private static native void _setMNbVerts(long address, short value);

    /**
     * @return short
     */
    public short getMIndexBase() {
        return _getMIndexBase(address);
    }
    private static native short _getMIndexBase(long address);

    /**
     * @param value short
     */
    public void setMIndexBase(short value) {
        _setMIndexBase(address, value);
    }
    private static native void _setMIndexBase(long address, short value);

}
