package physx.geomutils;


public class PxBoxGeometry extends PxGeometry {

    protected PxBoxGeometry() { }

    public static PxBoxGeometry wrapPointer(long address) {
        return new PxBoxGeometry(address);
    }
    
    protected PxBoxGeometry(long address) {
        super(address);
    }

    // Constructors

    /**
     * @param hx float
     * @param hy float
     * @param hz float
     */
    public PxBoxGeometry(float hx, float hy, float hz) {
        address = _PxBoxGeometry(hx, hy, hz);
    }
    private static native long _PxBoxGeometry(float hx, float hy, float hz);

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isStackAllocated) {
            throw new IllegalStateException(this + " is stack allocated and cannot be deleted");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

}
