package physx.extensions;

import physx.NativeObject;

public class PxRevoluteJointFlags extends NativeObject {

    protected PxRevoluteJointFlags() { }

    public static PxRevoluteJointFlags wrapPointer(long address) {
        return new PxRevoluteJointFlags(address);
    }
    
    protected PxRevoluteJointFlags(long address) {
        super(address);
    }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;

    // Placed Constructors

    /**
     * @param address where the object is allocated
     * @param flags   unsigned short
     * @return Stack allocated object of PxRevoluteJointFlags
     */
    public static PxRevoluteJointFlags malloc(long address, short flags) {
        __placement_new_PxRevoluteJointFlags(address, flags);
        PxRevoluteJointFlags mallocedObj = wrapPointer(address);
        mallocedObj.isStackAllocated = true;
        return mallocedObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @param flags     unsigned short
     * @return Stack allocated object of PxRevoluteJointFlags
     */
    public static <T> PxRevoluteJointFlags malloc(T allocator, Allocator<T> allocate, short flags) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxRevoluteJointFlags(address, flags);
        PxRevoluteJointFlags mallocedObj = wrapPointer(address);
        mallocedObj.isStackAllocated = true;
        return mallocedObj;
    }

    private static native void __placement_new_PxRevoluteJointFlags(long address, short flags);

    // Constructors

    /**
     * @param flags unsigned short
     */
    public PxRevoluteJointFlags(short flags) {
        address = _PxRevoluteJointFlags(flags);
    }
    private static native long _PxRevoluteJointFlags(short flags);

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isStackAllocated) {
            throw new IllegalStateException(this + " is stack allocated and cannot be deleted");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /**
     * @param flag {@link PxRevoluteJointFlagEnum} [enum]
     * @return boolean
     */
    public boolean isSet(int flag) {
        return _isSet(address, flag);
    }
    private static native boolean _isSet(long address, int flag);

    /**
     * @param flag {@link PxRevoluteJointFlagEnum} [enum]
     */
    public void set(int flag) {
        _set(address, flag);
    }
    private static native void _set(long address, int flag);

    /**
     * @param flag {@link PxRevoluteJointFlagEnum} [enum]
     */
    public void clear(int flag) {
        _clear(address, flag);
    }
    private static native void _clear(long address, int flag);

}
