package physx.extensions;


public class PxRevoluteJoint extends PxJoint {

    protected PxRevoluteJoint() { }

    public static PxRevoluteJoint wrapPointer(long address) {
        return new PxRevoluteJoint(address);
    }
    
    protected PxRevoluteJoint(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isStackAllocated) {
            throw new IllegalStateException(this + " is stack allocated and cannot be deleted");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /**
     * @param velocity float
     */
    public void setDriveVelocity(float velocity) {
        _setDriveVelocity(address, velocity);
    }
    private static native void _setDriveVelocity(long address, float velocity);

    /**
     * @param velocity float
     * @param autowake boolean
     */
    public void setDriveVelocity(float velocity, boolean autowake) {
        _setDriveVelocity(address, velocity, autowake);
    }
    private static native void _setDriveVelocity(long address, float velocity, boolean autowake);

    /**
     * @return float
     */
    public float getDriveVelocity() {
        return _getDriveVelocity(address);
    }
    private static native float _getDriveVelocity(long address);

    /**
     * @param limit float
     */
    public void setDriveForceLimit(float limit) {
        _setDriveForceLimit(address, limit);
    }
    private static native void _setDriveForceLimit(long address, float limit);

    /**
     * @return float
     */
    public float getDriveForceLimit() {
        return _getDriveForceLimit(address);
    }
    private static native float _getDriveForceLimit(long address);

    /**
     * @param ratio float
     */
    public void setDriveGearRatio(float ratio) {
        _setDriveGearRatio(address, ratio);
    }
    private static native void _setDriveGearRatio(long address, float ratio);

    /**
     * @return float
     */
    public float getDriveGearRatio() {
        return _getDriveGearRatio(address);
    }
    private static native float _getDriveGearRatio(long address);

    /**
     * @param flags {@link PxRevoluteJointFlags} [Ref]
     */
    public void setRevoluteJointFlags(PxRevoluteJointFlags flags) {
        _setRevoluteJointFlags(address, flags.getAddress());
    }
    private static native void _setRevoluteJointFlags(long address, long flags);

    /**
     * @param flag  {@link PxRevoluteJointFlagEnum} [enum]
     * @param value boolean
     */
    public void setRevoluteJointFlag(int flag, boolean value) {
        _setRevoluteJointFlag(address, flag, value);
    }
    private static native void _setRevoluteJointFlag(long address, int flag, boolean value);

    /**
     * @return {@link PxRevoluteJointFlags} [Value]
     */
    public PxRevoluteJointFlags getRevoluteJointFlags() {
        return PxRevoluteJointFlags.wrapPointer(_getRevoluteJointFlags(address));
    }
    private static native long _getRevoluteJointFlags(long address);

}
