package physx.extensions;

import physx.common.PxCpuDispatcher;

public class PxDefaultCpuDispatcher extends PxCpuDispatcher {

    protected PxDefaultCpuDispatcher() { }

    public static PxDefaultCpuDispatcher wrapPointer(long address) {
        return new PxDefaultCpuDispatcher(address);
    }
    
    protected PxDefaultCpuDispatcher(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isStackAllocated) {
            throw new IllegalStateException(this + " is stack allocated and cannot be deleted");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

}
