package physx.extensions;

import physx.NativeObject;

public class PxDefaultAllocator extends NativeObject {

    public static PxDefaultAllocator wrapPointer(long address) {
        return new PxDefaultAllocator(address);
    }
    
    protected PxDefaultAllocator(long address) {
        super(address);
    }

    // Constructors

    public PxDefaultAllocator() {
        address = _PxDefaultAllocator();
    }
    private static native long _PxDefaultAllocator();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isStackAllocated) {
            throw new IllegalStateException(this + " is stack allocated and cannot be deleted");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

}
