package physx.cooking;

import physx.NativeObject;
import physx.common.PxTolerancesScale;

public class PxCookingParams extends NativeObject {

    protected PxCookingParams() { }

    public static PxCookingParams wrapPointer(long address) {
        return new PxCookingParams(address);
    }
    
    protected PxCookingParams(long address) {
        super(address);
    }

    // Constructors

    /**
     * @param sc {@link PxTolerancesScale} [Const, Ref]
     */
    public PxCookingParams(PxTolerancesScale sc) {
        address = _PxCookingParams(sc.getAddress());
    }
    private static native long _PxCookingParams(long sc);

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isStackAllocated) {
            throw new IllegalStateException(this + " is stack allocated and cannot be deleted");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

}
