package physx.cooking;

import physx.NativeObject;
import physx.common.PxPhysicsInsertionCallback;
import physx.geomutils.PxConvexMesh;

public class PxCooking extends NativeObject {

    protected PxCooking() { }

    public static PxCooking wrapPointer(long address) {
        return new PxCooking(address);
    }
    
    protected PxCooking(long address) {
        super(address);
    }

    // Functions

    /**
     * @param desc              {@link PxConvexMeshDesc} [Const, Ref]
     * @param insertionCallback {@link PxPhysicsInsertionCallback} [Ref]
     * @return {@link PxConvexMesh}
     */
    public PxConvexMesh createConvexMesh(PxConvexMeshDesc desc, PxPhysicsInsertionCallback insertionCallback) {
        return PxConvexMesh.wrapPointer(_createConvexMesh(address, desc.getAddress(), insertionCallback.getAddress()));
    }
    private static native long _createConvexMesh(long address, long desc, long insertionCallback);

}
