package physx.common;

import physx.NativeObject;

public class PxVec3 extends NativeObject {

    public static PxVec3 wrapPointer(long address) {
        return new PxVec3(address);
    }
    
    protected PxVec3(long address) {
        super(address);
    }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;

    // Placed Constructors

    /**
     * @param address where the object is allocated
     * @return Stack allocated object of PxVec3
     */
    public static PxVec3 malloc(long address) {
        __placement_new_PxVec3(address);
        PxVec3 mallocedObj = wrapPointer(address);
        mallocedObj.isStackAllocated = true;
        return mallocedObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @return Stack allocated object of PxVec3
     */
    public static <T> PxVec3 malloc(T allocator, Allocator<T> allocate) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxVec3(address);
        PxVec3 mallocedObj = wrapPointer(address);
        mallocedObj.isStackAllocated = true;
        return mallocedObj;
    }

    private static native void __placement_new_PxVec3(long address);

    /**
     * @param address where the object is allocated
     * @param x       float
     * @param y       float
     * @param z       float
     * @return Stack allocated object of PxVec3
     */
    public static PxVec3 malloc(long address, float x, float y, float z) {
        __placement_new_PxVec3(address, x, y, z);
        PxVec3 mallocedObj = wrapPointer(address);
        mallocedObj.isStackAllocated = true;
        return mallocedObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @param x         float
     * @param y         float
     * @param z         float
     * @return Stack allocated object of PxVec3
     */
    public static <T> PxVec3 malloc(T allocator, Allocator<T> allocate, float x, float y, float z) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxVec3(address, x, y, z);
        PxVec3 mallocedObj = wrapPointer(address);
        mallocedObj.isStackAllocated = true;
        return mallocedObj;
    }

    private static native void __placement_new_PxVec3(long address, float x, float y, float z);

    // Constructors

    public PxVec3() {
        address = _PxVec3();
    }
    private static native long _PxVec3();

    /**
     * @param x float
     * @param y float
     * @param z float
     */
    public PxVec3(float x, float y, float z) {
        address = _PxVec3(x, y, z);
    }
    private static native long _PxVec3(float x, float y, float z);

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isStackAllocated) {
            throw new IllegalStateException(this + " is stack allocated and cannot be deleted");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return float
     */
    public float getX() {
        return _getX(address);
    }
    private static native float _getX(long address);

    /**
     * @param value float
     */
    public void setX(float value) {
        _setX(address, value);
    }
    private static native void _setX(long address, float value);

    /**
     * @return float
     */
    public float getY() {
        return _getY(address);
    }
    private static native float _getY(long address);

    /**
     * @param value float
     */
    public void setY(float value) {
        _setY(address, value);
    }
    private static native void _setY(long address, float value);

    /**
     * @return float
     */
    public float getZ() {
        return _getZ(address);
    }
    private static native float _getZ(long address);

    /**
     * @param value float
     */
    public void setZ(float value) {
        _setZ(address, value);
    }
    private static native void _setZ(long address, float value);

}
