package physx.common;

import physx.NativeObject;

public class PxTolerancesScale extends NativeObject {

    public static PxTolerancesScale wrapPointer(long address) {
        return new PxTolerancesScale(address);
    }
    
    protected PxTolerancesScale(long address) {
        super(address);
    }

    // Constructors

    public PxTolerancesScale() {
        address = _PxTolerancesScale();
    }
    private static native long _PxTolerancesScale();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isStackAllocated) {
            throw new IllegalStateException(this + " is stack allocated and cannot be deleted");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

}
