package physx.common;

import physx.NativeObject;

public class PxQuat extends NativeObject {

    public static PxQuat wrapPointer(long address) {
        return new PxQuat(address);
    }
    
    protected PxQuat(long address) {
        super(address);
    }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;

    // Placed Constructors

    /**
     * @param address where the object is allocated
     * @return Stack allocated object of PxQuat
     */
    public static PxQuat malloc(long address) {
        __placement_new_PxQuat(address);
        PxQuat mallocedObj = wrapPointer(address);
        mallocedObj.isStackAllocated = true;
        return mallocedObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @return Stack allocated object of PxQuat
     */
    public static <T> PxQuat malloc(T allocator, Allocator<T> allocate) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxQuat(address);
        PxQuat mallocedObj = wrapPointer(address);
        mallocedObj.isStackAllocated = true;
        return mallocedObj;
    }

    private static native void __placement_new_PxQuat(long address);

    /**
     * @param address where the object is allocated
     * @param x       float
     * @param y       float
     * @param z       float
     * @param w       float
     * @return Stack allocated object of PxQuat
     */
    public static PxQuat malloc(long address, float x, float y, float z, float w) {
        __placement_new_PxQuat(address, x, y, z, w);
        PxQuat mallocedObj = wrapPointer(address);
        mallocedObj.isStackAllocated = true;
        return mallocedObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @param x         float
     * @param y         float
     * @param z         float
     * @param w         float
     * @return Stack allocated object of PxQuat
     */
    public static <T> PxQuat malloc(T allocator, Allocator<T> allocate, float x, float y, float z, float w) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxQuat(address, x, y, z, w);
        PxQuat mallocedObj = wrapPointer(address);
        mallocedObj.isStackAllocated = true;
        return mallocedObj;
    }

    private static native void __placement_new_PxQuat(long address, float x, float y, float z, float w);

    // Constructors

    public PxQuat() {
        address = _PxQuat();
    }
    private static native long _PxQuat();

    /**
     * @param x float
     * @param y float
     * @param z float
     * @param w float
     */
    public PxQuat(float x, float y, float z, float w) {
        address = _PxQuat(x, y, z, w);
    }
    private static native long _PxQuat(float x, float y, float z, float w);

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isStackAllocated) {
            throw new IllegalStateException(this + " is stack allocated and cannot be deleted");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return float
     */
    public float getX() {
        return _getX(address);
    }
    private static native float _getX(long address);

    /**
     * @param value float
     */
    public void setX(float value) {
        _setX(address, value);
    }
    private static native void _setX(long address, float value);

    /**
     * @return float
     */
    public float getY() {
        return _getY(address);
    }
    private static native float _getY(long address);

    /**
     * @param value float
     */
    public void setY(float value) {
        _setY(address, value);
    }
    private static native void _setY(long address, float value);

    /**
     * @return float
     */
    public float getZ() {
        return _getZ(address);
    }
    private static native float _getZ(long address);

    /**
     * @param value float
     */
    public void setZ(float value) {
        _setZ(address, value);
    }
    private static native void _setZ(long address, float value);

    /**
     * @return float
     */
    public float getW() {
        return _getW(address);
    }
    private static native float _getW(long address);

    /**
     * @param value float
     */
    public void setW(float value) {
        _setW(address, value);
    }
    private static native void _setW(long address, float value);

}
