package physx.common;

import physx.NativeObject;

public class PxBounds3 extends NativeObject {

    public static PxBounds3 wrapPointer(long address) {
        return new PxBounds3(address);
    }
    
    protected PxBounds3(long address) {
        super(address);
    }

    // Constructors

    public PxBounds3() {
        address = _PxBounds3();
    }
    private static native long _PxBounds3();

    /**
     * @param minimum {@link PxVec3} [Const, Ref]
     * @param maximum {@link PxVec3} [Const, Ref]
     */
    public PxBounds3(PxVec3 minimum, PxVec3 maximum) {
        address = _PxBounds3(minimum.getAddress(), maximum.getAddress());
    }
    private static native long _PxBounds3(long minimum, long maximum);

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isStackAllocated) {
            throw new IllegalStateException(this + " is stack allocated and cannot be deleted");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return {@link PxVec3} [Value]
     */
    public PxVec3 getMinimum() {
        return PxVec3.wrapPointer(_getMinimum(address));
    }
    private static native long _getMinimum(long address);

    /**
     * @param value {@link PxVec3} [Value]
     */
    public void setMinimum(PxVec3 value) {
        _setMinimum(address, value.getAddress());
    }
    private static native void _setMinimum(long address, long value);

    /**
     * @return {@link PxVec3} [Value]
     */
    public PxVec3 getMaximum() {
        return PxVec3.wrapPointer(_getMaximum(address));
    }
    private static native long _getMaximum(long address);

    /**
     * @param value {@link PxVec3} [Value]
     */
    public void setMaximum(PxVec3 value) {
        _setMaximum(address, value.getAddress());
    }
    private static native void _setMaximum(long address, long value);

    // Functions

    public void setEmpty() {
        _setEmpty(address);
    }
    private static native void _setEmpty(long address);

    public void setMaximal() {
        _setMaximal(address);
    }
    private static native void _setMaximal(long address);

    /**
     * @param v {@link PxVec3} [Const, Ref]
     */
    public void include(PxVec3 v) {
        _include(address, v.getAddress());
    }
    private static native void _include(long address, long v);

    /**
     * @return boolean
     */
    public boolean isEmpty() {
        return _isEmpty(address);
    }
    private static native boolean _isEmpty(long address);

    /**
     * @param b {@link PxBounds3} [Const, Ref]
     * @return boolean
     */
    public boolean intersects(PxBounds3 b) {
        return _intersects(address, b.getAddress());
    }
    private static native boolean _intersects(long address, long b);

    /**
     * @param b    {@link PxBounds3} [Const, Ref]
     * @param axis unsigned long
     * @return boolean
     */
    public boolean intersects1D(PxBounds3 b, int axis) {
        return _intersects1D(address, b.getAddress(), axis);
    }
    private static native boolean _intersects1D(long address, long b, int axis);

    /**
     * @param v {@link PxVec3} [Const, Ref]
     * @return boolean
     */
    public boolean contains(PxVec3 v) {
        return _contains(address, v.getAddress());
    }
    private static native boolean _contains(long address, long v);

    /**
     * @param box {@link PxBounds3} [Const, Ref]
     * @return boolean
     */
    public boolean isInside(PxBounds3 box) {
        return _isInside(address, box.getAddress());
    }
    private static native boolean _isInside(long address, long box);

    /**
     * @return {@link PxVec3} [Value]
     */
    public PxVec3 getCenter() {
        return PxVec3.wrapPointer(_getCenter(address));
    }
    private static native long _getCenter(long address);

    /**
     * @return {@link PxVec3} [Value]
     */
    public PxVec3 getDimensions() {
        return PxVec3.wrapPointer(_getDimensions(address));
    }
    private static native long _getDimensions(long address);

    /**
     * @return {@link PxVec3} [Value]
     */
    public PxVec3 getExtents() {
        return PxVec3.wrapPointer(_getExtents(address));
    }
    private static native long _getExtents(long address);

    /**
     * @param scale float
     */
    public void scaleSafe(float scale) {
        _scaleSafe(address, scale);
    }
    private static native void _scaleSafe(long address, float scale);

    /**
     * @param scale float
     */
    public void scaleFast(float scale) {
        _scaleFast(address, scale);
    }
    private static native void _scaleFast(long address, float scale);

    /**
     * @param distance float
     */
    public void fattenSafe(float distance) {
        _fattenSafe(address, distance);
    }
    private static native void _fattenSafe(long address, float distance);

    /**
     * @param distance float
     */
    public void fattenFast(float distance) {
        _fattenFast(address, distance);
    }
    private static native void _fattenFast(long address, float distance);

    /**
     * @return boolean
     */
    public boolean isFinite() {
        return _isFinite(address);
    }
    private static native boolean _isFinite(long address);

    /**
     * @return boolean
     */
    public boolean isValid() {
        return _isValid(address);
    }
    private static native boolean _isValid(long address);

}
