package physx.common;

import physx.NativeObject;

public class PxBaseFlags extends NativeObject {

    protected PxBaseFlags() { }

    public static PxBaseFlags wrapPointer(long address) {
        return new PxBaseFlags(address);
    }
    
    protected PxBaseFlags(long address) {
        super(address);
    }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;

    // Placed Constructors

    /**
     * @param address where the object is allocated
     * @param flags   unsigned short
     * @return Stack allocated object of PxBaseFlags
     */
    public static PxBaseFlags malloc(long address, short flags) {
        __placement_new_PxBaseFlags(address, flags);
        PxBaseFlags mallocedObj = wrapPointer(address);
        mallocedObj.isStackAllocated = true;
        return mallocedObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @param flags     unsigned short
     * @return Stack allocated object of PxBaseFlags
     */
    public static <T> PxBaseFlags malloc(T allocator, Allocator<T> allocate, short flags) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxBaseFlags(address, flags);
        PxBaseFlags mallocedObj = wrapPointer(address);
        mallocedObj.isStackAllocated = true;
        return mallocedObj;
    }

    private static native void __placement_new_PxBaseFlags(long address, short flags);

    // Constructors

    /**
     * @param flags unsigned short
     */
    public PxBaseFlags(short flags) {
        address = _PxBaseFlags(flags);
    }
    private static native long _PxBaseFlags(short flags);

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isStackAllocated) {
            throw new IllegalStateException(this + " is stack allocated and cannot be deleted");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /**
     * @param flag {@link PxBaseFlagEnum} [enum]
     * @return boolean
     */
    public boolean isSet(int flag) {
        return _isSet(address, flag);
    }
    private static native boolean _isSet(long address, int flag);

    /**
     * @param flag {@link PxBaseFlagEnum} [enum]
     */
    public void set(int flag) {
        _set(address, flag);
    }
    private static native void _set(long address, int flag);

    /**
     * @param flag {@link PxBaseFlagEnum} [enum]
     */
    public void clear(int flag) {
        _clear(address, flag);
    }
    private static native void _clear(long address, int flag);

}
