package physx;

import physx.common.PxDefaultErrorCallback;
import physx.common.PxFoundation;
import physx.common.PxTolerancesScale;
import physx.common.PxTransform;
import physx.common.PxU8Ptr;
import physx.common.PxVec3;
import physx.cooking.PxCooking;
import physx.cooking.PxCookingParams;
import physx.extensions.PxDefaultAllocator;
import physx.extensions.PxDefaultCpuDispatcher;
import physx.extensions.PxRevoluteJoint;
import physx.physics.PxBatchQueryPostFilterShader;
import physx.physics.PxBatchQueryPreFilterShader;
import physx.physics.PxPhysics;
import physx.physics.PxRigidActor;
import physx.physics.PxSimulationFilterShader;

public class PxTopLevelFunctions extends NativeObject {

    protected PxTopLevelFunctions() { }

    public static PxTopLevelFunctions wrapPointer(long address) {
        return new PxTopLevelFunctions(address);
    }
    
    protected PxTopLevelFunctions(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isStackAllocated) {
            throw new IllegalStateException(this + " is stack allocated and cannot be deleted");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return unsigned long
     */
    public static int getPHYSICS_VERSION() {
        return _getPHYSICS_VERSION();
    }
    private static native int _getPHYSICS_VERSION();

    // Functions

    /**
     * @return {@link PxSimulationFilterShader} [Value]
     */
    public static PxSimulationFilterShader DefaultFilterShader() {
        return PxSimulationFilterShader.wrapPointer(_DefaultFilterShader());
    }
    private static native long _DefaultFilterShader();

    /**
     * @return {@link PxBatchQueryPreFilterShader} [Value]
     */
    public static PxBatchQueryPreFilterShader DefaultWheelSceneQueryPreFilterBlocking() {
        return PxBatchQueryPreFilterShader.wrapPointer(_DefaultWheelSceneQueryPreFilterBlocking());
    }
    private static native long _DefaultWheelSceneQueryPreFilterBlocking();

    /**
     * @return {@link PxBatchQueryPostFilterShader} [Value]
     */
    public static PxBatchQueryPostFilterShader DefaultWheelSceneQueryPostFilterBlocking() {
        return PxBatchQueryPostFilterShader.wrapPointer(_DefaultWheelSceneQueryPostFilterBlocking());
    }
    private static native long _DefaultWheelSceneQueryPostFilterBlocking();

    /**
     * @param version    unsigned long
     * @param foundation {@link PxFoundation} [Ref]
     * @param scale      {@link PxCookingParams} [Const, Ref]
     * @return {@link PxCooking}
     */
    public static PxCooking CreateCooking(int version, PxFoundation foundation, PxCookingParams scale) {
        return PxCooking.wrapPointer(_CreateCooking(version, foundation.getAddress(), scale.getAddress()));
    }
    private static native long _CreateCooking(int version, long foundation, long scale);

    /**
     * @param version       unsigned long
     * @param allocator     {@link PxDefaultAllocator} [Ref]
     * @param errorCallback {@link PxDefaultErrorCallback} [Ref]
     * @return {@link PxFoundation}
     */
    public static PxFoundation CreateFoundation(int version, PxDefaultAllocator allocator, PxDefaultErrorCallback errorCallback) {
        return PxFoundation.wrapPointer(_CreateFoundation(version, allocator.getAddress(), errorCallback.getAddress()));
    }
    private static native long _CreateFoundation(int version, long allocator, long errorCallback);

    /**
     * @param version    unsigned long
     * @param foundation {@link PxFoundation} [Ref]
     * @param params     {@link PxTolerancesScale} [Const, Ref]
     * @return {@link PxPhysics}
     */
    public static PxPhysics CreatePhysics(int version, PxFoundation foundation, PxTolerancesScale params) {
        return PxPhysics.wrapPointer(_CreatePhysics(version, foundation.getAddress(), params.getAddress()));
    }
    private static native long _CreatePhysics(int version, long foundation, long params);

    /**
     * @param numThreads unsigned long
     * @return {@link PxDefaultCpuDispatcher}
     */
    public static PxDefaultCpuDispatcher DefaultCpuDispatcherCreate(int numThreads) {
        return PxDefaultCpuDispatcher.wrapPointer(_DefaultCpuDispatcherCreate(numThreads));
    }
    private static native long _DefaultCpuDispatcherCreate(int numThreads);

    /**
     * @param physics {@link PxPhysics} [Ref]
     * @return boolean
     */
    public static boolean InitExtensions(PxPhysics physics) {
        return _InitExtensions(physics.getAddress());
    }
    private static native boolean _InitExtensions(long physics);

    /**
     * @param physics     {@link PxPhysics} [Ref]
     * @param actor0      {@link PxRigidActor}
     * @param localFrame0 {@link PxTransform} [Ref]
     * @param actor1      {@link PxRigidActor}
     * @param localFrame1 {@link PxTransform} [Ref]
     * @return {@link PxRevoluteJoint}
     */
    public static PxRevoluteJoint RevoluteJointCreate(PxPhysics physics, PxRigidActor actor0, PxTransform localFrame0, PxRigidActor actor1, PxTransform localFrame1) {
        return PxRevoluteJoint.wrapPointer(_RevoluteJointCreate(physics.getAddress(), actor0.getAddress(), localFrame0.getAddress(), actor1.getAddress(), localFrame1.getAddress()));
    }
    private static native long _RevoluteJointCreate(long physics, long actor0, long localFrame0, long actor1, long localFrame1);

    /**
     * @param base  {@link PxU8Ptr} [Ref]
     * @param index long
     * @return long
     */
    public static int getU8At(PxU8Ptr base, int index) {
        return _getU8At(base.getAddress(), index);
    }
    private static native int _getU8At(long base, int index);

    /**
     * @param base  {@link PxVec3}
     * @param index long
     * @return {@link PxVec3} [Value]
     */
    public static PxVec3 getVec3At(PxVec3 base, int index) {
        return PxVec3.wrapPointer(_getVec3At(base.getAddress(), index));
    }
    private static native long _getVec3At(long base, int index);

}
