package physx;


public class NativeObject {

    static {
        de.fabmax.physxjni.Loader.load();
    }

    protected NativeObject() { }

    protected long address = 0L;
    protected boolean isStackAllocated = false;
    
    protected NativeObject(long address) {
        this.address = address;
    }
    
    public static NativeObject wrapPointer(long address) {
        return new NativeObject(address);
    }
    
    public long getAddress() {
        return address;
    }
    
    @FunctionalInterface
    public interface Allocator<T> {
        long on(T allocator, int alignment, int size);
    }
}
