/*
 * Decompiled with CFR 0.152.
 */
package de.fabmax.kool.physics.vehicle;

import de.fabmax.kool.math.Vec3f;
import de.fabmax.kool.physics.FilterData;
import de.fabmax.kool.physics.FilterDataBuilder;
import de.fabmax.kool.physics.FilterDataKt;
import de.fabmax.kool.physics.Material;
import de.fabmax.kool.physics.Shape;
import de.fabmax.kool.physics.geometry.BoxGeometry;
import de.fabmax.kool.physics.geometry.CollisionGeometry;
import de.fabmax.kool.physics.geometry.ConvexMesh;
import de.fabmax.kool.physics.geometry.ConvexMeshGeometry;
import de.fabmax.kool.physics.vehicle.VehicleUtils;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fJ\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020!2\b\b\u0002\u0010\"\u001a\u00020\u0004J\u0016\u0010#\u001a\u00020\u001d2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020%J\u000e\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020(J\u000e\u0010*\u001a\u00020(2\u0006\u0010)\u001a\u00020(R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013R\u001b\u0010\u0016\u001a\u00020\u00178FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006+"}, d2={"Lde/fabmax/kool/physics/vehicle/VehicleUtils;", "", "()V", "COLLISION_FLAG_CHASSIS", "", "COLLISION_FLAG_CHASSIS_AGAINST", "COLLISION_FLAG_DRIVABLE_OBSTACLE", "COLLISION_FLAG_DRIVABLE_OBSTACLE_AGAINST", "COLLISION_FLAG_GROUND", "COLLISION_FLAG_GROUND_AGAINST", "COLLISION_FLAG_OBSTACLE", "COLLISION_FLAG_OBSTACLE_AGAINST", "COLLISION_FLAG_WHEEL", "COLLISION_FLAG_WHEEL_AGAINST", "SURFACE_FLAG_DRIVABLE", "SURFACE_FLAG_NON_DRIVABLE", "defaultChassisMaterial", "Lde/fabmax/kool/physics/Material;", "getDefaultChassisMaterial", "()Lde/fabmax/kool/physics/Material;", "defaultWheelMaterial", "getDefaultWheelMaterial", "defaultWheelMesh", "Lde/fabmax/kool/physics/geometry/ConvexMesh;", "getDefaultWheelMesh", "()Lde/fabmax/kool/physics/geometry/ConvexMesh;", "defaultWheelMesh$delegate", "Lkotlin/Lazy;", "defaultChassisShape", "Lde/fabmax/kool/physics/Shape;", "boxSize", "Lde/fabmax/kool/math/Vec3f;", "geometry", "Lde/fabmax/kool/physics/geometry/CollisionGeometry;", "contactFlags", "defaultWheelShape", "radius", "", "width", "setupDrivableSurface", "Lde/fabmax/kool/physics/FilterDataBuilder;", "queryFilterData", "setupNonDrivableSurface", "kool-physics"})
public final class VehicleUtils {
    @NotNull
    public static final VehicleUtils INSTANCE = new VehicleUtils();
    @NotNull
    private static final Material defaultChassisMaterial = new Material(0.5f, 0.5f, 0.5f);
    @NotNull
    private static final Material defaultWheelMaterial = new Material(0.5f, 0.5f, 0.5f);
    @NotNull
    private static final Lazy defaultWheelMesh$delegate = LazyKt.lazy((Function0)defaultWheelMesh.2.INSTANCE);
    public static final int SURFACE_FLAG_DRIVABLE = -65536;
    public static final int SURFACE_FLAG_NON_DRIVABLE = 65535;
    public static final int COLLISION_FLAG_GROUND = 1;
    public static final int COLLISION_FLAG_WHEEL = 2;
    public static final int COLLISION_FLAG_CHASSIS = 4;
    public static final int COLLISION_FLAG_OBSTACLE = 8;
    public static final int COLLISION_FLAG_DRIVABLE_OBSTACLE = 16;
    public static final int COLLISION_FLAG_GROUND_AGAINST = 28;
    public static final int COLLISION_FLAG_WHEEL_AGAINST = 14;
    public static final int COLLISION_FLAG_CHASSIS_AGAINST = 31;
    public static final int COLLISION_FLAG_OBSTACLE_AGAINST = 31;
    public static final int COLLISION_FLAG_DRIVABLE_OBSTACLE_AGAINST = 29;

    private VehicleUtils() {
    }

    @NotNull
    public final FilterDataBuilder setupDrivableSurface(@NotNull FilterDataBuilder queryFilterData) {
        Intrinsics.checkNotNullParameter((Object)queryFilterData, (String)"queryFilterData");
        queryFilterData.setWord3(-65536);
        return queryFilterData;
    }

    @NotNull
    public final FilterDataBuilder setupNonDrivableSurface(@NotNull FilterDataBuilder queryFilterData) {
        Intrinsics.checkNotNullParameter((Object)queryFilterData, (String)"queryFilterData");
        queryFilterData.setWord3(65535);
        return queryFilterData;
    }

    @NotNull
    public final Shape defaultChassisShape(@NotNull Vec3f boxSize) {
        Intrinsics.checkNotNullParameter((Object)boxSize, (String)"boxSize");
        return VehicleUtils.defaultChassisShape$default(this, new BoxGeometry(boxSize), 0, 2, null);
    }

    @NotNull
    public final Shape defaultChassisShape(@NotNull CollisionGeometry geometry, int contactFlags) {
        Intrinsics.checkNotNullParameter((Object)geometry, (String)"geometry");
        FilterData simFilterData = new FilterData(4, 31, contactFlags, 0, 8, null);
        FilterData qryFilterData2 = FilterDataKt.FilterData((Function1<? super FilterDataBuilder, Unit>)((Function1)defaultChassisShape.qryFilterData.1.INSTANCE));
        return new Shape(geometry, defaultChassisMaterial, null, simFilterData, qryFilterData2, 4, null);
    }

    public static /* synthetic */ Shape defaultChassisShape$default(VehicleUtils vehicleUtils, CollisionGeometry collisionGeometry, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return vehicleUtils.defaultChassisShape(collisionGeometry, n);
    }

    @NotNull
    public final Shape defaultWheelShape(float radius, float width) {
        ConvexMesh mesh = this.getDefaultWheelMesh();
        ConvexMeshGeometry geom = new ConvexMeshGeometry(mesh, new Vec3f(width, radius, radius));
        FilterData simFilterData = new FilterData(2, 14, 0, 0, 12, null);
        FilterData qryFilterData2 = FilterDataKt.FilterData((Function1<? super FilterDataBuilder, Unit>)((Function1)defaultWheelShape.qryFilterData.1.INSTANCE));
        return new Shape(geom, defaultWheelMaterial, null, simFilterData, qryFilterData2, 4, null);
    }

    @NotNull
    public final Material getDefaultChassisMaterial() {
        return defaultChassisMaterial;
    }

    @NotNull
    public final Material getDefaultWheelMaterial() {
        return defaultWheelMaterial;
    }

    @NotNull
    public final ConvexMesh getDefaultWheelMesh() {
        Lazy lazy = defaultWheelMesh$delegate;
        return (ConvexMesh)lazy.getValue();
    }
}

