/*
 * Decompiled with CFR 0.152.
 */
package de.fabmax.kool.physics.vehicle;

import de.fabmax.kool.math.Mat4f;
import de.fabmax.kool.math.MathKt;
import de.fabmax.kool.math.MutableVec3f;
import de.fabmax.kool.math.Vec3f;
import de.fabmax.kool.physics.FilterData;
import de.fabmax.kool.physics.FilterDataBuilder;
import de.fabmax.kool.physics.FilterDataKt;
import de.fabmax.kool.physics.PhysXExtensionsKt;
import de.fabmax.kool.physics.Physics;
import de.fabmax.kool.physics.PhysicsWorld;
import de.fabmax.kool.physics.geometry.CollisionGeometry;
import de.fabmax.kool.physics.vehicle.CommonVehicle;
import de.fabmax.kool.physics.vehicle.Vehicle;
import de.fabmax.kool.physics.vehicle.VehicleProperties;
import de.fabmax.kool.physics.vehicle.WheelInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.system.MemoryStack;
import physx.NativeObject;
import physx.common.PxIDENTITYEnum;
import physx.common.PxQuat;
import physx.common.PxTransform;
import physx.common.PxVec3;
import physx.geometry.PxBoxGeometry;
import physx.geometry.PxGeometry;
import physx.physics.PxFilterData;
import physx.physics.PxPairFlagEnum;
import physx.physics.PxQueryFilterData;
import physx.physics.PxQueryFlagEnum;
import physx.physics.PxQueryFlags;
import physx.physics.PxRigidActor;
import physx.physics.PxRigidBody;
import physx.physics.PxRigidDynamic;
import physx.physics.PxShapeFlagEnum;
import physx.support.Vector_PxReal;
import physx.support.Vector_PxVec3;
import physx.vehicle2.EngineDriveVehicle;
import physx.vehicle2.EngineDriveVehicleEnum;
import physx.vehicle2.PxVehicleAntiRollForceParams;
import physx.vehicle2.PxVehicleAutoboxParams;
import physx.vehicle2.PxVehicleAxesEnum;
import physx.vehicle2.PxVehicleAxleDescription;
import physx.vehicle2.PxVehicleBrakeCommandResponseParams;
import physx.vehicle2.PxVehicleClutchAccuracyModeEnum;
import physx.vehicle2.PxVehicleEngineDriveTransmissionCommandStateEnum;
import physx.vehicle2.PxVehiclePhysXActorUpdateModeEnum;
import physx.vehicle2.PxVehiclePhysXMaterialFriction;
import physx.vehicle2.PxVehiclePhysXRoadGeometryQueryTypeEnum;
import physx.vehicle2.PxVehiclePhysXSimulationContext;
import physx.vehicle2.PxVehicleSimulationContext;
import physx.vehicle2.PxVehicleSteerCommandResponseParams;
import physx.vehicle2.PxVehicleSuspensionComplianceParams;
import physx.vehicle2.PxVehicleSuspensionForceParams;
import physx.vehicle2.PxVehicleSuspensionJounceCalculationTypeEnum;
import physx.vehicle2.PxVehicleSuspensionParams;
import physx.vehicle2.PxVehicleTireDirectionModesEnum;
import physx.vehicle2.PxVehicleTireForceParams;
import physx.vehicle2.PxVehicleTireForceParamsExt;
import physx.vehicle2.PxVehicleTireSlipState;
import physx.vehicle2.PxVehicleTopLevelFunctions;
import physx.vehicle2.PxVehicleWheelParams;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010F\u001a\b\u0012\u0004\u0012\u00020(0G2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u0010H\u001a\u0002032\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0015\u0010I\u001a\u00020J2\u0006\u0010K\u001a\u00020\nH\u0010\u00a2\u0006\u0002\bLJ\b\u0010M\u001a\u00020JH\u0016J\u0006\u0010N\u001a\u00020JJ\"\u0010O\u001a\u00020J*\u0002032\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010P\u001a\b\u0012\u0004\u0012\u00020Q0GH\u0002J\u0014\u0010R\u001a\u00020J*\u0002032\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0014\u0010S\u001a\u00020J*\u0002032\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R$\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0016\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\rR\u000e\u0010\u0018\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0019\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\rR\u0011\u0010\u001b\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\rR\u000e\u0010\u001d\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001e\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\rR\u001a\u0010 \u001a\u00020!X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\"\"\u0004\b#\u0010$R\u0011\u0010%\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b&\u0010\rR\u000e\u0010'\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010*\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b+\u0010\rR\u000e\u0010,\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010.\u001a\u00020/X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101R\u0011\u00102\u001a\u000203\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u00105R\u0011\u00106\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b7\u0010\rR$\u00108\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b9\u0010\r\"\u0004\b:\u0010\u000fR$\u0010;\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b<\u0010\r\"\u0004\b=\u0010\u000fR\u000e\u0010>\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010?\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010@\u001a\u00020A\u00a2\u0006\b\n\u0000\u001a\u0004\bB\u0010CR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\bD\u0010E\u00a8\u0006T"}, d2={"Lde/fabmax/kool/physics/vehicle/Vehicle;", "Lde/fabmax/kool/physics/vehicle/CommonVehicle;", "vehicleProps", "Lde/fabmax/kool/physics/vehicle/VehicleProperties;", "world", "Lde/fabmax/kool/physics/PhysicsWorld;", "pose", "Lde/fabmax/kool/math/Mat4f;", "(Lde/fabmax/kool/physics/vehicle/VehicleProperties;Lde/fabmax/kool/physics/PhysicsWorld;Lde/fabmax/kool/math/Mat4f;)V", "value", "", "brakeInput", "getBrakeInput", "()F", "setBrakeInput", "(F)V", "curGear", "", "currentGear", "getCurrentGear", "()I", "engineP", "enginePowerW", "getEnginePowerW", "engineSpd", "engineSpeedRpm", "getEngineSpeedRpm", "engineTorqueNm", "getEngineTorqueNm", "engineTq", "forwardSpeed", "getForwardSpeed", "isReverse", "", "()Z", "setReverse", "(Z)V", "lateralAcceleration", "getLateralAcceleration", "linearAccel", "Lde/fabmax/kool/math/MutableVec3f;", "linearSpeed", "longitudinalAcceleration", "getLongitudinalAcceleration", "peakTorque", "prevLinearSpeed", "pxRigidActor", "Lphysx/physics/PxRigidActor;", "getPxRigidActor", "()Lphysx/physics/PxRigidActor;", "pxVehicle", "Lphysx/vehicle2/EngineDriveVehicle;", "getPxVehicle", "()Lphysx/vehicle2/EngineDriveVehicle;", "sidewaysSpeed", "getSidewaysSpeed", "steerInput", "getSteerInput", "setSteerInput", "throttleInput", "getThrottleInput", "setThrottleInput", "tmpMat", "tmpVec", "vehicleSimulationContext", "Lphysx/vehicle2/PxVehiclePhysXSimulationContext;", "getVehicleSimulationContext", "()Lphysx/vehicle2/PxVehiclePhysXSimulationContext;", "getWorld", "()Lde/fabmax/kool/physics/PhysicsWorld;", "computeWheelCenterActorOffsets", "", "createVehicle", "onPhysicsUpdate", "", "timeStep", "onPhysicsUpdate$kool_physics", "release", "setToRestState", "setupBaseParams", "wheelCenterActorOffsets", "Lde/fabmax/kool/math/Vec3f;", "setupEngineParams", "setupPhysxParams", "kool-physics"})
@SourceDebugExtension(value={"SMAP\nVehicle.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Vehicle.kt\nde/fabmax/kool/physics/vehicle/Vehicle\n+ 2 LwjglExtensions.kt\nde/fabmax/kool/util/LwjglExtensionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 Math.kt\nde/fabmax/kool/math/MathKt\n*L\n1#1,499:1\n18#2,3:500\n1#3:503\n1549#4:504\n1620#4,3:505\n24#5:508\n*S KotlinDebug\n*F\n+ 1 Vehicle.kt\nde/fabmax/kool/physics/vehicle/Vehicle\n*L\n104#1:500,3\n228#1:504\n228#1:505,3\n274#1:508\n*E\n"})
public final class Vehicle
extends CommonVehicle {
    @NotNull
    private final PhysicsWorld world;
    @NotNull
    private final EngineDriveVehicle pxVehicle;
    @NotNull
    private final PxVehiclePhysXSimulationContext vehicleSimulationContext;
    private float steerInput;
    private float throttleInput;
    private float brakeInput;
    private final float peakTorque;
    @NotNull
    private final MutableVec3f tmpVec;
    @NotNull
    private final Mat4f tmpMat;
    @NotNull
    private final MutableVec3f linearSpeed;
    @NotNull
    private final MutableVec3f prevLinearSpeed;
    @NotNull
    private final MutableVec3f linearAccel;
    private float engineSpd;
    private float engineTq;
    private float engineP;
    private int curGear;
    private boolean isReverse;
    @NotNull
    private final PxRigidActor pxRigidActor;

    /*
     * WARNING - void declaration
     */
    public Vehicle(@NotNull VehicleProperties vehicleProps, @NotNull PhysicsWorld world, @NotNull Mat4f pose) {
        void $this$_init__u24lambda_u240;
        PxVehiclePhysXSimulationContext pxVehiclePhysXSimulationContext;
        Intrinsics.checkNotNullParameter((Object)vehicleProps, (String)"vehicleProps");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pose, (String)"pose");
        super(vehicleProps);
        this.world = world;
        this.peakTorque = vehicleProps.getPeakEngineTorque();
        this.tmpVec = new MutableVec3f();
        this.tmpMat = new Mat4f();
        this.linearSpeed = new MutableVec3f();
        this.prevLinearSpeed = new MutableVec3f();
        this.linearAccel = new MutableVec3f();
        for (int i = 0; i < 4; ++i) {
            ((Collection)this.getMutWheelInfos()).add(new WheelInfo());
        }
        this.pxVehicle = this.createVehicle(vehicleProps);
        PxRigidBody pxRigidBody = this.pxVehicle.getPhysXState().getPhysxActor().getRigidBody();
        Intrinsics.checkNotNullExpressionValue((Object)pxRigidBody, (String)"pxVehicle.physXState.physxActor.rigidBody");
        this.pxRigidActor = (PxRigidActor)pxRigidBody;
        this.setMass(vehicleProps.getChassisMass());
        this.getTransform().set(pose);
        PxVehiclePhysXSimulationContext pxVehiclePhysXSimulationContext2 = pxVehiclePhysXSimulationContext = new PxVehiclePhysXSimulationContext();
        Vehicle vehicle = this;
        boolean bl = false;
        $this$_init__u24lambda_u240.setToDefault();
        $this$_init__u24lambda_u240.getFrame().setLngAxis(PxVehicleAxesEnum.ePosZ);
        $this$_init__u24lambda_u240.getFrame().setLatAxis(PxVehicleAxesEnum.ePosX);
        $this$_init__u24lambda_u240.getFrame().setVrtAxis(PxVehicleAxesEnum.ePosY);
        $this$_init__u24lambda_u240.getScale().setScale(1.0f);
        Vec3f vec3f = this.world.getGravity();
        PxVec3 pxVec3 = $this$_init__u24lambda_u240.getGravity();
        Intrinsics.checkNotNullExpressionValue((Object)pxVec3, (String)"gravity");
        PhysXExtensionsKt.toPxVec3(vec3f, pxVec3);
        $this$_init__u24lambda_u240.setPhysxScene(this.world.getPxScene());
        $this$_init__u24lambda_u240.setPhysxActorUpdateMode(PxVehiclePhysXActorUpdateModeEnum.eAPPLY_VELOCITY);
        $this$_init__u24lambda_u240.setPhysxUnitCylinderSweepMesh(Physics.INSTANCE.getUnitCylinderSweepMesh$kool_physics());
        vehicle.vehicleSimulationContext = pxVehiclePhysXSimulationContext;
    }

    public /* synthetic */ Vehicle(VehicleProperties vehicleProperties, PhysicsWorld physicsWorld, Mat4f mat4f, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            mat4f = new Mat4f();
        }
        this(vehicleProperties, physicsWorld, mat4f);
    }

    @NotNull
    public final PhysicsWorld getWorld() {
        return this.world;
    }

    @NotNull
    public final EngineDriveVehicle getPxVehicle() {
        return this.pxVehicle;
    }

    @NotNull
    public final PxVehiclePhysXSimulationContext getVehicleSimulationContext() {
        return this.vehicleSimulationContext;
    }

    @Override
    public float getSteerInput() {
        return this.steerInput;
    }

    @Override
    public void setSteerInput(float value) {
        this.steerInput = value;
        this.pxVehicle.getCommandState().setSteer(-value);
    }

    @Override
    public float getThrottleInput() {
        return this.throttleInput;
    }

    @Override
    public void setThrottleInput(float value) {
        this.throttleInput = value;
        this.pxVehicle.getCommandState().setThrottle(value);
    }

    @Override
    public float getBrakeInput() {
        return this.brakeInput;
    }

    @Override
    public void setBrakeInput(float value) {
        this.brakeInput = value;
        this.pxVehicle.getCommandState().setBrakes(0, value);
        this.pxVehicle.getCommandState().setNbBrakes(1);
    }

    public final float getForwardSpeed() {
        return this.linearSpeed.getZ();
    }

    public final float getSidewaysSpeed() {
        return this.linearSpeed.getX();
    }

    public final float getLongitudinalAcceleration() {
        return this.linearAccel.getZ();
    }

    public final float getLateralAcceleration() {
        return this.linearAccel.getX();
    }

    public final float getEngineSpeedRpm() {
        return this.engineSpd;
    }

    public final float getEngineTorqueNm() {
        return this.engineTq;
    }

    public final float getEnginePowerW() {
        return this.engineP;
    }

    public final int getCurrentGear() {
        return this.curGear;
    }

    public final boolean isReverse() {
        return this.isReverse;
    }

    public final void setReverse(boolean bl) {
        this.isReverse = bl;
    }

    @Override
    @NotNull
    public PxRigidActor getPxRigidActor() {
        return this.pxRigidActor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setToRestState() {
        this.pxVehicle.getCommandState().setToDefault();
        this.pxVehicle.getTransmissionCommandState().setToDefault();
        this.pxVehicle.getBaseState().setToDefault();
        this.pxVehicle.getEngineDriveState().setToDefault();
        boolean $i$f$memStack = false;
        AutoCloseable autoCloseable = (AutoCloseable)MemoryStack.stackPush();
        Throwable throwable = null;
        try {
            MemoryStack stack$iv = (MemoryStack)autoCloseable;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)stack$iv, (String)"stack");
            MemoryStack $this$setToRestState_u24lambda_u241 = stack$iv;
            boolean bl2 = false;
            PxVec3 pxVecZero = PhysXExtensionsKt.createPxVec3($this$setToRestState_u24lambda_u241, 0.0f, 0.0f, 0.0f);
            PxRigidDynamic actor = PxRigidDynamic.wrapPointer((long)this.pxVehicle.getPhysXState().getPhysxActor().getRigidBody().getAddress());
            actor.setLinearVelocity(pxVecZero);
            actor.setAngularVelocity(pxVecZero);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    @Override
    public void release() {
        this.pxVehicle.destroy();
        super.release();
    }

    @Override
    public void onPhysicsUpdate$kool_physics(float timeStep) {
        int targetGear = this.pxVehicle.getEngineDriveState().getGearboxState().getTargetGear();
        int neutralGear = this.pxVehicle.getEngineDriveParams().getGearBoxParams().getNeutralGear();
        if (this.isReverse && targetGear != neutralGear - 1) {
            this.pxVehicle.getTransmissionCommandState().setTargetGear(0);
            this.pxVehicle.getEngineDriveState().getGearboxState().setCurrentGear(neutralGear - 1);
            this.pxVehicle.getEngineDriveState().getGearboxState().setTargetGear(neutralGear - 1);
        } else if (!this.isReverse && targetGear == neutralGear - 1) {
            this.pxVehicle.getTransmissionCommandState().setTargetGear(PxVehicleEngineDriveTransmissionCommandStateEnum.eAUTOMATIC_GEAR.value);
            this.pxVehicle.getEngineDriveState().getGearboxState().setCurrentGear(neutralGear + 1);
            this.pxVehicle.getEngineDriveState().getGearboxState().setTargetGear(neutralGear + 1);
        }
        this.pxVehicle.step(timeStep, (PxVehicleSimulationContext)this.vehicleSimulationContext);
        this.tmpVec.set(this.getVehicleProps().getChassisCMOffset()).scale(-2.0f);
        for (int i = 0; i < 4; ++i) {
            WheelInfo wheelInfo = this.getWheelInfos().get(i);
            wheelInfo.getTransform().setIdentity().translate((Vec3f)this.tmpVec);
            PxTransform pxTransform = this.pxVehicle.getBaseState().getWheelLocalPoses(i).getLocalPose();
            Intrinsics.checkNotNullExpressionValue((Object)pxTransform, (String)"pxVehicle.baseState.getW\u2026elLocalPoses(i).localPose");
            PhysXExtensionsKt.toMat4f(pxTransform, this.tmpMat);
            wheelInfo.getTransform().mul(this.tmpMat);
            boolean isHit = this.pxVehicle.getBaseState().getRoadGeomStates(i).getHitState();
            if (isHit) {
                PxVehicleTireSlipState slipState = this.pxVehicle.getBaseState().getTireSlipStates(i);
                wheelInfo.setLateralSlip(slipState.getSlips(PxVehicleTireDirectionModesEnum.eLATERAL.value));
                wheelInfo.setLongitudinalSlip(slipState.getSlips(PxVehicleTireDirectionModesEnum.eLONGITUDINAL.value));
                continue;
            }
            wheelInfo.setLateralSlip(0.0f);
            wheelInfo.setLongitudinalSlip(0.0f);
        }
        float engineSpdOmega = this.pxVehicle.getEngineDriveState().getEngineState().getRotationSpeed();
        this.engineSpd = ((Number)((Object)MathKt.max((Comparable)Float.valueOf(750.0f), (Comparable)Float.valueOf(engineSpdOmega * 9.549296f)))).floatValue();
        this.engineTq = this.pxVehicle.getEngineDriveParams().getEngineParams().getTorqueCurve().interpolate(engineSpdOmega / this.pxVehicle.getEngineDriveParams().getEngineParams().getMaxOmega()) * this.peakTorque * this.getThrottleInput();
        this.engineP = this.engineTq * engineSpdOmega;
        this.curGear = this.pxVehicle.getEngineDriveState().getGearboxState().getCurrentGear() - this.pxVehicle.getEngineDriveParams().getGearBoxParams().getNeutralGear();
        PxRigidBody vehicleActor = this.pxVehicle.getPhysXState().getPhysxActor().getRigidBody();
        PxVec3 linearVelocity = vehicleActor.getLinearVelocity();
        PxVec3 forwardDir = vehicleActor.getGlobalPose().getQ().getBasisVector2();
        PxVec3 sideDir = vehicleActor.getGlobalPose().getQ().getBasisVector0();
        this.prevLinearSpeed.set((Vec3f)this.linearSpeed);
        this.linearSpeed.setZ(linearVelocity.dot(forwardDir));
        this.linearSpeed.setX(linearVelocity.dot(sideDir));
        this.linearAccel.setZ(this.linearAccel.getZ() * 0.5f + (this.linearSpeed.getZ() - this.prevLinearSpeed.getZ()) / timeStep * 0.5f);
        this.linearAccel.setX(this.linearAccel.getX() * 0.5f + (this.linearSpeed.getX() - this.prevLinearSpeed.getX()) / timeStep * 0.5f);
        int nbSubsteps = this.linearSpeed.getZ() < 5.0f ? 3 : 1;
        this.pxVehicle.getComponentSequence().setSubsteps(this.pxVehicle.getComponentSequenceSubstepGroupHandle(), (byte)nbSubsteps);
        super.onPhysicsUpdate$kool_physics(timeStep);
    }

    private final List<MutableVec3f> computeWheelCenterActorOffsets(VehicleProperties vehicleProps) {
        float twF = vehicleProps.getTrackWidthFront() * 0.5f;
        float twR = vehicleProps.getTrackWidthRear() * 0.5f;
        int n = 4;
        ArrayList<MutableVec3f> arrayList = new ArrayList<MutableVec3f>(n);
        int n2 = 0;
        while (n2 < n) {
            int n3;
            int n4 = n3 = n2++;
            ArrayList<MutableVec3f> arrayList2 = arrayList;
            boolean bl = false;
            arrayList2.add(new MutableVec3f());
        }
        List offsets = arrayList;
        ((MutableVec3f)offsets.get(0)).set(twF, vehicleProps.getWheelCenterHeightOffset(), vehicleProps.getWheelPosFront());
        ((MutableVec3f)offsets.get(1)).set(-twF, vehicleProps.getWheelCenterHeightOffset(), vehicleProps.getWheelPosFront());
        ((MutableVec3f)offsets.get(2)).set(twR, vehicleProps.getWheelCenterHeightOffset(), vehicleProps.getWheelPosRear());
        ((MutableVec3f)offsets.get(3)).set(-twR, vehicleProps.getWheelCenterHeightOffset(), vehicleProps.getWheelPosRear());
        return offsets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final EngineDriveVehicle createVehicle(VehicleProperties vehicleProps) {
        EngineDriveVehicle vehicle = new EngineDriveVehicle();
        List<MutableVec3f> wheelOffsets = this.computeWheelCenterActorOffsets(vehicleProps);
        this.setupBaseParams(vehicle, vehicleProps, wheelOffsets);
        this.setupPhysxParams(vehicle, vehicleProps);
        this.setupEngineParams(vehicle, vehicleProps);
        vehicle.initialize(Physics.INSTANCE.getPhysics(), Physics.INSTANCE.getCookingParams(), Physics.INSTANCE.getDefaultMaterial().getPxMaterial(), EngineDriveVehicleEnum.eDIFFTYPE_FOURWHEELDRIVE);
        AutoCloseable autoCloseable = (AutoCloseable)MemoryStack.stackPush();
        Throwable throwable = null;
        try {
            MemoryStack stack = (MemoryStack)autoCloseable;
            boolean bl = false;
            PxTransform vehiclePose = PxTransform.createAt((Object)stack, MemoryStack::nmalloc, (PxVec3)PxVec3.createAt((Object)stack, MemoryStack::nmalloc, (float)0.0f, (float)1.0f, (float)0.0f), (PxQuat)PxQuat.createAt((Object)stack, MemoryStack::nmalloc, (PxIDENTITYEnum)PxIDENTITYEnum.PxIdentity));
            vehicle.getPhysXState().getPhysxActor().getRigidBody().setGlobalPose(vehiclePose);
            vehicle.getEngineDriveState().getGearboxState().setCurrentGear(vehicle.getEngineDriveParams().getGearBoxParams().getNeutralGear() + 1);
            vehicle.getEngineDriveState().getGearboxState().setTargetGear(vehicle.getEngineDriveParams().getGearBoxParams().getNeutralGear() + 1);
            vehicle.getTransmissionCommandState().setTargetGear(PxVehicleEngineDriveTransmissionCommandStateEnum.eAUTOMATIC_GEAR.value);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return vehicle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void setupBaseParams(EngineDriveVehicle $this$setupBaseParams, VehicleProperties vehicleProps, List<? extends Vec3f> wheelCenterActorOffsets) {
        AutoCloseable autoCloseable = (AutoCloseable)MemoryStack.stackPush();
        Throwable throwable = null;
        try {
            int i;
            PxVehicleSteerCommandResponseParams i22;
            PxVehicleAxleDescription $i$f$map22;
            void $this$mapTo$iv$iv;
            MemoryStack mem = (MemoryStack)autoCloseable;
            boolean bl = false;
            int numWheels = vehicleProps.getNumWheels();
            Iterable $this$map$iv = wheelCenterActorOffsets;
            boolean $i$f$map22 = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Vec3f vec3f = (Vec3f)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(new MutableVec3f((Vec3f)it).add(vehicleProps.getChassisCMOffset()));
            }
            List wheelOffsets = (List)destination$iv$iv;
            Vector_PxVec3 pxWheelCenterActorOffsets = PhysXExtensionsKt.toVector_PxVec3(wheelOffsets);
            if (numWheels != 4) {
                String $i$f$map22 = "For now only 4 wheeled vehicles are suppoted";
                throw new NotImplementedError("An operation is not implemented: " + $i$f$map22);
            }
            PxVehicleAxleDescription $this$setupBaseParams_u24lambda_u2410_u24lambda_u245 = $i$f$map22 = $this$setupBaseParams.getBaseParams().getAxleDescription();
            boolean bl3 = false;
            $this$setupBaseParams_u24lambda_u2410_u24lambda_u245.setNbAxles(2);
            $this$setupBaseParams_u24lambda_u2410_u24lambda_u245.setNbWheels(4);
            $this$setupBaseParams_u24lambda_u2410_u24lambda_u245.setNbWheelsPerAxle(0, 2);
            $this$setupBaseParams_u24lambda_u2410_u24lambda_u245.setNbWheelsPerAxle(1, 2);
            $this$setupBaseParams_u24lambda_u2410_u24lambda_u245.setAxleToWheelIds(0, 0);
            $this$setupBaseParams_u24lambda_u2410_u24lambda_u245.setAxleToWheelIds(1, 2);
            for (int i3 = 0; i3 < 4; ++i3) {
                $this$setupBaseParams_u24lambda_u2410_u24lambda_u245.setWheelIdsInAxleOrder(i3, i3);
            }
            PxVehicleAxleDescription $this$setupBaseParams_u24lambda_u2410_u24lambda_u246 = $i$f$map22 = $this$setupBaseParams.getBaseParams().getFrame();
            boolean bl4 = false;
            $this$setupBaseParams_u24lambda_u2410_u24lambda_u246.setLatAxis(PxVehicleAxesEnum.ePosX);
            $this$setupBaseParams_u24lambda_u2410_u24lambda_u246.setLngAxis(PxVehicleAxesEnum.ePosZ);
            $this$setupBaseParams_u24lambda_u2410_u24lambda_u246.setVrtAxis(PxVehicleAxesEnum.ePosY);
            $this$setupBaseParams.getBaseParams().getScale().setScale(1.0f);
            PxVehicleAxleDescription $this$setupBaseParams_u24lambda_u2410_u24lambda_u247 = $i$f$map22 = $this$setupBaseParams.getBaseParams().getRigidBodyParams();
            boolean bl5 = false;
            $this$setupBaseParams_u24lambda_u2410_u24lambda_u247.setMass(vehicleProps.getChassisMass());
            Vec3f vec3f = vehicleProps.getChassisMOI();
            PxVec3 pxVec3 = $this$setupBaseParams_u24lambda_u2410_u24lambda_u247.getMoi();
            Intrinsics.checkNotNullExpressionValue((Object)pxVec3, (String)"moi");
            PhysXExtensionsKt.toPxVec3(vec3f, pxVec3);
            PxVehicleBrakeCommandResponseParams normalBrake = $this$setupBaseParams.getBaseParams().getBrakeResponseParams(0);
            PxVehicleBrakeCommandResponseParams handBrake = $this$setupBaseParams.getBaseParams().getBrakeResponseParams(1);
            normalBrake.getNonlinearResponse().setNbSpeedResponses((short)0);
            normalBrake.getNonlinearResponse().setNbCommandValues((short)0);
            normalBrake.setMaxResponse(vehicleProps.getMaxBrakeTorque());
            handBrake.getNonlinearResponse().setNbSpeedResponses((short)0);
            handBrake.getNonlinearResponse().setNbCommandValues((short)0);
            handBrake.setMaxResponse(vehicleProps.getMaxHandBrakeTorque());
            for (int i22 = 0; i22 < 4; ++i22) {
                boolean isFront = i22 < 2;
                normalBrake.setWheelResponseMultipliers(i22, isFront ? vehicleProps.getBrakeTorqueFrontFactor() : vehicleProps.getBrakeTorqueRearFactor());
                handBrake.setWheelResponseMultipliers(i22, isFront ? vehicleProps.getHandBrakeTorqueFrontFactor() : vehicleProps.getHandBrakeTorqueRearFactor());
            }
            PxVehicleSteerCommandResponseParams $this$setupBaseParams_u24lambda_u2410_u24lambda_u248 = i22 = $this$setupBaseParams.getBaseParams().getSteerResponseParams();
            boolean bl6 = false;
            float $this$toRad$iv = vehicleProps.getMaxSteerAngle();
            boolean $i$f$toRad = false;
            $this$setupBaseParams_u24lambda_u2410_u24lambda_u248.setMaxResponse($this$toRad$iv * ((float)Math.PI / 180));
            for (int i4 = 0; i4 < 4; ++i4) {
                boolean isFront = i4 < 2;
                $this$setupBaseParams_u24lambda_u2410_u24lambda_u248.setWheelResponseMultipliers(i4, isFront ? 1.0f : 0.0f);
            }
            PxVehicleSteerCommandResponseParams $this$setupBaseParams_u24lambda_u2410_u24lambda_u249 = i22 = $this$setupBaseParams.getBaseParams().getAckermannParams(0);
            boolean bl7 = false;
            $this$setupBaseParams_u24lambda_u2410_u24lambda_u249.setWheelIds(0, 0);
            $this$setupBaseParams_u24lambda_u2410_u24lambda_u249.setWheelIds(1, 1);
            $this$setupBaseParams_u24lambda_u2410_u24lambda_u249.setWheelBase(Math.abs(vehicleProps.getWheelPosFront()) + Math.abs(vehicleProps.getWheelPosRear()));
            $this$setupBaseParams_u24lambda_u2410_u24lambda_u249.setTrackWidth(vehicleProps.getTrackWidthFront());
            $this$setupBaseParams_u24lambda_u2410_u24lambda_u249.setStrength(1.0f);
            for (i = 0; i < numWheels; ++i) {
                boolean isFront = i < 2;
                PxVehicleWheelParams wheel = $this$setupBaseParams.getBaseParams().getWheelParams(i);
                wheel.setMass(isFront ? vehicleProps.getWheelMassFront() : vehicleProps.getWheelMassRear());
                wheel.setMoi(isFront ? vehicleProps.getWheelMoiFront() : vehicleProps.getWheelMoiRear());
                wheel.setRadius(isFront ? vehicleProps.getWheelRadiusFront() : vehicleProps.getWheelRadiusRear());
                wheel.setHalfWidth(isFront ? vehicleProps.getWheelWidthFront() / 2.0f : vehicleProps.getWheelWidthRear() / 2.0f);
                wheel.setDampingRate(0.25f);
            }
            for (i = 0; i < numWheels; ++i) {
                PxVehicleTireForceParams tire = $this$setupBaseParams.getBaseParams().getTireForceParams(i);
                tire.setLongStiff(25000.0f);
                tire.setLatStiffX(0.007f);
                tire.setLatStiffY(180000.0f);
                tire.setCamberStiff(0.0f);
                tire.setRestLoad(5500.0f);
                PxVehicleTireForceParamsExt.setFrictionVsSlip((PxVehicleTireForceParams)tire, (int)0, (int)0, (float)0.0f);
                PxVehicleTireForceParamsExt.setFrictionVsSlip((PxVehicleTireForceParams)tire, (int)0, (int)1, (float)1.0f);
                PxVehicleTireForceParamsExt.setFrictionVsSlip((PxVehicleTireForceParams)tire, (int)1, (int)0, (float)0.1f);
                PxVehicleTireForceParamsExt.setFrictionVsSlip((PxVehicleTireForceParams)tire, (int)1, (int)1, (float)1.0f);
                PxVehicleTireForceParamsExt.setFrictionVsSlip((PxVehicleTireForceParams)tire, (int)2, (int)0, (float)1.0f);
                PxVehicleTireForceParamsExt.setFrictionVsSlip((PxVehicleTireForceParams)tire, (int)2, (int)1, (float)1.0f);
                PxVehicleTireForceParamsExt.setLoadFilter((PxVehicleTireForceParams)tire, (int)0, (int)0, (float)0.0f);
                PxVehicleTireForceParamsExt.setLoadFilter((PxVehicleTireForceParams)tire, (int)0, (int)1, (float)0.23f);
                PxVehicleTireForceParamsExt.setLoadFilter((PxVehicleTireForceParams)tire, (int)1, (int)0, (float)3.0f);
                PxVehicleTireForceParamsExt.setLoadFilter((PxVehicleTireForceParams)tire, (int)1, (int)1, (float)3.0f);
            }
            $this$setupBaseParams.getBaseParams().getSuspensionStateCalculationParams().setSuspensionJounceCalculationType(PxVehicleSuspensionJounceCalculationTypeEnum.eSWEEP);
            $this$setupBaseParams.getBaseParams().getSuspensionStateCalculationParams().setLimitSuspensionExpansionVelocity(false);
            Intrinsics.checkNotNullExpressionValue((Object)mem, (String)"mem");
            PxVec3 forceAppPoint = PhysXExtensionsKt.createPxVec3(mem, 0.0f, 0.0f, -0.2f);
            Vector_PxReal suspSprungMasses = new Vector_PxReal(numWheels);
            PxVehicleTopLevelFunctions.VehicleComputeSprungMasses((int)numWheels, (Vector_PxVec3)pxWheelCenterActorOffsets, (float)vehicleProps.getChassisMass(), (PxVehicleAxesEnum)PxVehicleAxesEnum.eNegY, (Vector_PxReal)suspSprungMasses);
            for (int i5 = 0; i5 < numWheels; ++i5) {
                PxVehicleSuspensionParams susp = $this$setupBaseParams.getBaseParams().getSuspensionParams(i5);
                PxVehicleSuspensionForceParams suspForce = $this$setupBaseParams.getBaseParams().getSuspensionForceParams(i5);
                PxVehicleSuspensionComplianceParams suspComp = $this$setupBaseParams.getBaseParams().getSuspensionComplianceParams(i5);
                PxTransform pxTransform = susp.getSuspensionAttachment();
                Vec3f vec3f2 = (Vec3f)wheelOffsets.get(i5);
                PxVec3 pxVec32 = PhysXExtensionsKt.createPxVec3(mem);
                Intrinsics.checkNotNullExpressionValue((Object)pxVec32, (String)"mem.createPxVec3()");
                pxTransform.setP(PhysXExtensionsKt.toPxVec3(vec3f2, pxVec32));
                PxQuat pxQuat = susp.getSuspensionAttachment().getQ();
                Intrinsics.checkNotNullExpressionValue((Object)pxQuat, (String)"susp.suspensionAttachment.q");
                PhysXExtensionsKt.setIdentity(pxQuat);
                PxVec3 pxVec33 = susp.getSuspensionTravelDir();
                Intrinsics.checkNotNullExpressionValue((Object)pxVec33, (String)"susp.suspensionTravelDir");
                PhysXExtensionsKt.set(pxVec33, Vec3f.Companion.getNEG_Y_AXIS());
                susp.setSuspensionTravelDist(vehicleProps.getMaxCompression() + vehicleProps.getMaxDroop());
                PxVec3 pxVec34 = susp.getWheelAttachment().getP();
                Intrinsics.checkNotNullExpressionValue((Object)pxVec34, (String)"susp.wheelAttachment.p");
                PhysXExtensionsKt.set(pxVec34, Vec3f.Companion.getZERO());
                PxQuat pxQuat2 = susp.getWheelAttachment().getQ();
                Intrinsics.checkNotNullExpressionValue((Object)pxQuat2, (String)"susp.wheelAttachment.q");
                PhysXExtensionsKt.setIdentity(pxQuat2);
                suspForce.setDamping(vehicleProps.getSpringDamperRate());
                suspForce.setStiffness(vehicleProps.getSpringStrength());
                suspForce.setSprungMass(suspSprungMasses.at(i5));
                suspComp.getWheelToeAngle().addPair(0.0f, 0.0f);
                suspComp.getWheelCamberAngle().addPair(0.0f, 0.0f);
                suspComp.getSuspForceAppPoint().addPair(0.0f, forceAppPoint);
                suspComp.getTireForceAppPoint().addPair(0.0f, forceAppPoint);
            }
            int antiRollIdx = 0;
            if (vehicleProps.getFrontAntiRollBarStiffness() > 0.0f) {
                PxVehicleAntiRollForceParams barFront = $this$setupBaseParams.getBaseParams().getAntiRollForceParams(antiRollIdx++);
                barFront.setWheel0(0);
                barFront.setWheel1(1);
                barFront.setStiffness(vehicleProps.getFrontAntiRollBarStiffness());
            }
            if (vehicleProps.getRearAntiRollBarStiffness() > 0.0f) {
                PxVehicleAntiRollForceParams barRear = $this$setupBaseParams.getBaseParams().getAntiRollForceParams(antiRollIdx++);
                barRear.setWheel0(2);
                barRear.setWheel1(3);
                barRear.setStiffness(vehicleProps.getRearAntiRollBarStiffness());
            }
            $this$setupBaseParams.getBaseParams().setNbAntiRollForceParams(antiRollIdx);
            suspSprungMasses.destroy();
            pxWheelCenterActorOffsets.destroy();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void setupPhysxParams(EngineDriveVehicle $this$setupPhysxParams, VehicleProperties vehicleProps) {
        AutoCloseable autoCloseable = (AutoCloseable)MemoryStack.stackPush();
        Throwable throwable = null;
        try {
            MemoryStack mem = (MemoryStack)autoCloseable;
            boolean bl = false;
            PxFilterData roadFilterData = PxFilterData.createAt((Object)mem, MemoryStack::nmalloc, (int)0, (int)0, (int)0, (int)0);
            PxQueryFlags roadQueryFlags = PxQueryFlags.createAt((Object)mem, MemoryStack::nmalloc, (short)((short)PxQueryFlagEnum.eSTATIC.value));
            PxQueryFilterData roadQueryFilterData = PxQueryFilterData.createAt((Object)mem, MemoryStack::nmalloc, (PxFilterData)roadFilterData, (PxQueryFlags)roadQueryFlags);
            NativeObject.Allocator allocator = MemoryStack::nmalloc;
            Vec3f vec3f = (Vec3f)new MutableVec3f(vehicleProps.getChassisCMOffset()).scale(-1.0f);
            Intrinsics.checkNotNullExpressionValue((Object)mem, (String)"mem");
            PxVec3 pxVec3 = PhysXExtensionsKt.createPxVec3(mem);
            Intrinsics.checkNotNullExpressionValue((Object)pxVec3, (String)"mem.createPxVec3()");
            PxTransform actorCMassLocalPose = PxTransform.createAt((Object)mem, (NativeObject.Allocator)allocator, (PxVec3)PhysXExtensionsKt.toPxVec3(vec3f, pxVec3), (PxQuat)PxQuat.createAt((Object)mem, MemoryStack::nmalloc, (PxIDENTITYEnum)PxIDENTITYEnum.PxIdentity));
            PxTransform actorShapeLocalPose = PxTransform.createAt((Object)mem, MemoryStack::nmalloc, (PxVec3)PxVec3.createAt((Object)mem, MemoryStack::nmalloc, (float)0.0f, (float)0.83f, (float)0.0f), (PxQuat)PxQuat.createAt((Object)mem, MemoryStack::nmalloc, (PxIDENTITYEnum)PxIDENTITYEnum.PxIdentity));
            $this$setupPhysxParams.getPhysXParams().getPhysxActorShapeFlags().raise(PxShapeFlagEnum.eSCENE_QUERY_SHAPE);
            $this$setupPhysxParams.getPhysXParams().getPhysxActorShapeFlags().raise(PxShapeFlagEnum.eSIMULATION_SHAPE);
            int reportContactFlags = PxPairFlagEnum.eNOTIFY_TOUCH_FOUND.value | PxPairFlagEnum.eNOTIFY_TOUCH_LOST.value | PxPairFlagEnum.eNOTIFY_CONTACT_POINTS.value;
            FilterData filterData = new FilterData(4, 31, reportContactFlags, 0, 8, null);
            PxFilterData pxFilterData = $this$setupPhysxParams.getPhysXParams().getPhysxActorSimulationFilterData();
            Intrinsics.checkNotNullExpressionValue((Object)pxFilterData, (String)"physXParams.physxActorSimulationFilterData");
            PhysXExtensionsKt.toPxFilterData(filterData, pxFilterData);
            FilterData filterData2 = FilterDataKt.FilterData((Function1<? super FilterDataBuilder, Unit>)((Function1)setupPhysxParams.1.1.INSTANCE));
            PxFilterData pxFilterData2 = $this$setupPhysxParams.getPhysXParams().getPhysxActorQueryFilterData();
            Intrinsics.checkNotNullExpressionValue((Object)pxFilterData2, (String)"physXParams.physxActorQueryFilterData");
            PhysXExtensionsKt.toPxFilterData(filterData2, pxFilterData2);
            FilterData filterData3 = new FilterData(2, 14, 0, 0, 12, null);
            PxFilterData pxFilterData3 = $this$setupPhysxParams.getPhysXParams().getPhysxActorWheelSimulationFilterData();
            Intrinsics.checkNotNullExpressionValue((Object)pxFilterData3, (String)"physXParams.physxActorWheelSimulationFilterData");
            PhysXExtensionsKt.toPxFilterData(filterData3, pxFilterData3);
            FilterData filterData4 = FilterDataKt.FilterData((Function1<? super FilterDataBuilder, Unit>)((Function1)setupPhysxParams.1.2.INSTANCE));
            PxFilterData pxFilterData4 = $this$setupPhysxParams.getPhysXParams().getPhysxActorWheelQueryFilterData();
            Intrinsics.checkNotNullExpressionValue((Object)pxFilterData4, (String)"physXParams.physxActorWheelQueryFilterData");
            PhysXExtensionsKt.toPxFilterData(filterData4, pxFilterData4);
            CollisionGeometry collisionGeometry = vehicleProps.getChassisGeometry();
            if (collisionGeometry == null || (collisionGeometry = collisionGeometry.getPxGeometry()) == null) {
                collisionGeometry = (PxGeometry)new PxBoxGeometry(vehicleProps.getChassisDims().getX() * 0.5f, vehicleProps.getChassisDims().getY() * 0.5f, vehicleProps.getChassisDims().getZ() * 0.5f);
            }
            CollisionGeometry geometry = collisionGeometry;
            PxVehiclePhysXMaterialFriction materialFriction = new PxVehiclePhysXMaterialFriction();
            materialFriction.setFriction(1.5f);
            materialFriction.setMaterial(Physics.INSTANCE.getDefaultMaterial().getPxMaterial());
            $this$setupPhysxParams.getPhysXParams().create($this$setupPhysxParams.getBaseParams().getAxleDescription(), roadQueryFilterData, null, materialFriction, 1, 1.5f, actorCMassLocalPose, (PxGeometry)geometry, actorShapeLocalPose, PxVehiclePhysXRoadGeometryQueryTypeEnum.eSWEEP);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    private final void setupEngineParams(EngineDriveVehicle $this$setupEngineParams, VehicleProperties vehicleProps) {
        int i;
        PxVehicleAutoboxParams pxVehicleAutoboxParams;
        PxVehicleAutoboxParams $this$setupEngineParams_u24lambda_u2412 = pxVehicleAutoboxParams = $this$setupEngineParams.getEngineDriveParams().getAutoboxParams();
        boolean bl = false;
        for (i = 0; i < 7; ++i) {
            $this$setupEngineParams_u24lambda_u2412.setUpRatios(i, 0.65f);
            $this$setupEngineParams_u24lambda_u2412.setDownRatios(i, 0.5f);
        }
        $this$setupEngineParams_u24lambda_u2412.setUpRatios(1, 0.15f);
        $this$setupEngineParams_u24lambda_u2412.setLatency(2.0f);
        $this$setupEngineParams.getEngineDriveParams().getClutchCommandResponseParams().setMaxResponse(vehicleProps.getClutchStrength());
        PxVehicleAutoboxParams $this$setupEngineParams_u24lambda_u2413 = pxVehicleAutoboxParams = $this$setupEngineParams.getEngineDriveParams().getClutchParams();
        boolean bl2 = false;
        $this$setupEngineParams_u24lambda_u2413.setAccuracyMode(PxVehicleClutchAccuracyModeEnum.eBEST_POSSIBLE);
        $this$setupEngineParams_u24lambda_u2413.setEstimateIterations(5);
        PxVehicleAutoboxParams $this$setupEngineParams_u24lambda_u2414 = pxVehicleAutoboxParams = $this$setupEngineParams.getEngineDriveParams().getEngineParams();
        boolean bl3 = false;
        $this$setupEngineParams_u24lambda_u2414.getTorqueCurve().addPair(0.0f, 0.3f);
        $this$setupEngineParams_u24lambda_u2414.getTorqueCurve().addPair(0.33f, 1.0f);
        $this$setupEngineParams_u24lambda_u2414.getTorqueCurve().addPair(1.0f, 0.7f);
        $this$setupEngineParams_u24lambda_u2414.setMoi(1.0f);
        $this$setupEngineParams_u24lambda_u2414.setPeakTorque(vehicleProps.getPeakEngineTorque());
        $this$setupEngineParams_u24lambda_u2414.setIdleOmega(0.0f);
        $this$setupEngineParams_u24lambda_u2414.setMaxOmega(vehicleProps.getPeakEngineRpm() / 9.549296f);
        $this$setupEngineParams_u24lambda_u2414.setDampingRateFullThrottle(0.15f);
        $this$setupEngineParams_u24lambda_u2414.setDampingRateZeroThrottleClutchEngaged(2.0f);
        $this$setupEngineParams_u24lambda_u2414.setDampingRateZeroThrottleClutchDisengaged(0.35f);
        PxVehicleAutoboxParams $this$setupEngineParams_u24lambda_u2415 = pxVehicleAutoboxParams = $this$setupEngineParams.getEngineDriveParams().getGearBoxParams();
        boolean bl4 = false;
        $this$setupEngineParams_u24lambda_u2415.setNeutralGear(1);
        $this$setupEngineParams_u24lambda_u2415.setRatios(0, -4.0f);
        $this$setupEngineParams_u24lambda_u2415.setRatios(1, 0.0f);
        $this$setupEngineParams_u24lambda_u2415.setRatios(2, 4.0f);
        $this$setupEngineParams_u24lambda_u2415.setRatios(3, 2.0f);
        $this$setupEngineParams_u24lambda_u2415.setRatios(4, 1.5f);
        $this$setupEngineParams_u24lambda_u2415.setRatios(5, 1.1f);
        $this$setupEngineParams_u24lambda_u2415.setRatios(6, 1.0f);
        $this$setupEngineParams_u24lambda_u2415.setNbRatios(7);
        $this$setupEngineParams_u24lambda_u2415.setFinalRatio(vehicleProps.getGearFinalRatio());
        $this$setupEngineParams_u24lambda_u2415.setSwitchTime(0.35f);
        PxVehicleAutoboxParams $this$setupEngineParams_u24lambda_u2416 = pxVehicleAutoboxParams = $this$setupEngineParams.getEngineDriveParams().getFourWheelDifferentialParams();
        boolean bl5 = false;
        for (i = 0; i < 4; ++i) {
            boolean isFront = i < 2;
            $this$setupEngineParams_u24lambda_u2416.setTorqueRatios(i, isFront ? 0.15f : 0.35f);
            $this$setupEngineParams_u24lambda_u2416.setAveWheelSpeedRatios(i, 0.25f);
            $this$setupEngineParams_u24lambda_u2416.setFrontWheelIds(0, 0);
            $this$setupEngineParams_u24lambda_u2416.setFrontWheelIds(1, 1);
            $this$setupEngineParams_u24lambda_u2416.setRearWheelIds(0, 2);
            $this$setupEngineParams_u24lambda_u2416.setRearWheelIds(1, 3);
            $this$setupEngineParams_u24lambda_u2416.setCenterBias(1.3f);
            $this$setupEngineParams_u24lambda_u2416.setCenterTarget(1.29f);
            $this$setupEngineParams_u24lambda_u2416.setFrontBias(1.3f);
            $this$setupEngineParams_u24lambda_u2416.setFrontTarget(1.29f);
            $this$setupEngineParams_u24lambda_u2416.setRearBias(1.3f);
            $this$setupEngineParams_u24lambda_u2416.setRearTarget(1.29f);
            $this$setupEngineParams_u24lambda_u2416.setRate(10.0f);
        }
        for (int i2 = 0; i2 < 4; ++i2) {
            $this$setupEngineParams.getEngineDriveParams().getMultiWheelDifferentialParams().setTorqueRatios(i2, 0.25f);
            $this$setupEngineParams.getEngineDriveParams().getMultiWheelDifferentialParams().setAveWheelSpeedRatios(i2, 0.25f);
            $this$setupEngineParams.getEngineDriveParams().getTankDifferentialParams().setTorqueRatios(i2, 0.25f);
            $this$setupEngineParams.getEngineDriveParams().getTankDifferentialParams().setAveWheelSpeedRatios(i2, 0.25f);
        }
    }
}

