/*
 * Decompiled with CFR 0.152.
 */
package de.fabmax.kool.physics.util;

import de.fabmax.kool.input.CursorMode;
import de.fabmax.kool.input.Pointer;
import de.fabmax.kool.input.PointerInput;
import de.fabmax.kool.math.Mat4f;
import de.fabmax.kool.math.MutableVec3f;
import de.fabmax.kool.math.Vec3f;
import de.fabmax.kool.physics.HitResult;
import de.fabmax.kool.physics.PhysicsWorld;
import de.fabmax.kool.physics.geometry.BoxGeometry;
import de.fabmax.kool.physics.util.CharacterTrackingCamRig;
import de.fabmax.kool.pipeline.RenderPass;
import de.fabmax.kool.scene.Node;
import de.fabmax.kool.util.Time;
import java.util.Collection;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u001b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u00105\u001a\u000206J\b\u00107\u001a\u000206H\u0002J\u000e\u00108\u001a\u0002062\u0006\u00109\u001a\u00020:J\u0010\u0010;\u001a\u0002062\u0006\u0010<\u001a\u00020\u0006H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0007\u001a\u00020\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00038F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0004R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0019\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u001b\"\u0004\b \u0010\u001dR\u0011\u0010!\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0016R\u000e\u0010#\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010$\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010\u001b\"\u0004\b&\u0010\u001dR\u001a\u0010'\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\u001a\u0010,\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010\u001b\"\u0004\b.\u0010\u001dR&\u0010/\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000600X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u00102\"\u0004\b3\u00104\u00a8\u0006="}, d2={"Lde/fabmax/kool/physics/util/CharacterTrackingCamRig;", "Lde/fabmax/kool/scene/Node;", "enableCursorLock", "", "(Z)V", "actualZoom", "", "hitSweepGeometry", "Lde/fabmax/kool/physics/geometry/BoxGeometry;", "getHitSweepGeometry", "()Lde/fabmax/kool/physics/geometry/BoxGeometry;", "hitSweepGeometry$delegate", "Lkotlin/Lazy;", "hitSweepGeometryPose", "Lde/fabmax/kool/math/Mat4f;", "value", "isCursorLocked", "()Z", "setCursorLocked", "lookDirection", "Lde/fabmax/kool/math/MutableVec3f;", "getLookDirection", "()Lde/fabmax/kool/math/MutableVec3f;", "lookPhi", "lookTheta", "maxZoom", "getMaxZoom", "()F", "setMaxZoom", "(F)V", "minZoom", "getMinZoom", "setMinZoom", "pivotPoint", "getPivotPoint", "poseOrigin", "sensitivity", "getSensitivity", "setSensitivity", "trackedPose", "getTrackedPose", "()Lde/fabmax/kool/math/Mat4f;", "setTrackedPose", "(Lde/fabmax/kool/math/Mat4f;)V", "zoom", "getZoom", "setZoom", "zoomModifier", "Lkotlin/Function1;", "getZoomModifier", "()Lkotlin/jvm/functions/Function1;", "setZoomModifier", "(Lkotlin/jvm/functions/Function1;)V", "applyLookDirection", "", "handlePointerInput", "setupCollisionAwareCamZoom", "world", "Lde/fabmax/kool/physics/PhysicsWorld;", "updateTracking", "deltaT", "kool-physics"})
@SourceDebugExtension(value={"SMAP\nCharacterTrackingCamRig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CharacterTrackingCamRig.kt\nde/fabmax/kool/physics/util/CharacterTrackingCamRig\n+ 2 Math.kt\nde/fabmax/kool/math/MathKt\n*L\n1#1,111:1\n40#2,5:112\n40#2,5:117\n23#2:122\n23#2:123\n40#2,5:124\n*S KotlinDebug\n*F\n+ 1 CharacterTrackingCamRig.kt\nde/fabmax/kool/physics/util/CharacterTrackingCamRig\n*L\n85#1:112,5\n93#1:117,5\n102#1:122\n104#1:123\n107#1:124,5\n*E\n"})
public final class CharacterTrackingCamRig
extends Node {
    private float sensitivity;
    private float zoom;
    private float minZoom;
    private float maxZoom;
    private float actualZoom;
    @NotNull
    private Mat4f trackedPose;
    @NotNull
    private final MutableVec3f pivotPoint;
    @NotNull
    private final MutableVec3f lookDirection;
    @NotNull
    private Function1<? super Float, Float> zoomModifier;
    @NotNull
    private final MutableVec3f poseOrigin;
    private float lookPhi;
    private float lookTheta;
    @NotNull
    private final Lazy hitSweepGeometry$delegate;
    @NotNull
    private final Mat4f hitSweepGeometryPose;

    public CharacterTrackingCamRig(boolean enableCursorLock) {
        super("PointerLockCamRig");
        this.sensitivity = 1.0f;
        this.zoom = 4.0f;
        this.minZoom = 0.5f;
        this.maxZoom = 25.0f;
        this.actualZoom = this.zoom;
        this.trackedPose = new Mat4f();
        this.pivotPoint = new MutableVec3f();
        this.lookDirection = new MutableVec3f(Vec3f.Companion.getNEG_Z_AXIS());
        this.zoomModifier = zoomModifier.1.INSTANCE;
        this.poseOrigin = new MutableVec3f();
        this.lookTheta = 1.5707964f;
        this.hitSweepGeometry$delegate = LazyKt.lazy((Function0)hitSweepGeometry.2.INSTANCE);
        this.hitSweepGeometryPose = new Mat4f();
        this.setCursorLocked(enableCursorLock);
        ((Collection)this.getOnUpdate()).add(new Function1<RenderPass.UpdateEvent, Unit>(){

            public final void invoke(@NotNull RenderPass.UpdateEvent it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (this.isCursorLocked()) {
                    this.handlePointerInput();
                }
                this.updateTracking(Time.INSTANCE.getDeltaT());
            }
        });
    }

    public /* synthetic */ CharacterTrackingCamRig(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = true;
        }
        this(bl);
    }

    public final boolean isCursorLocked() {
        return PointerInput.INSTANCE.getCursorMode() == CursorMode.LOCKED;
    }

    public final void setCursorLocked(boolean value) {
        if (value) {
            PointerInput.INSTANCE.setCursorMode(CursorMode.LOCKED);
        } else {
            PointerInput.INSTANCE.setCursorMode(CursorMode.NORMAL);
        }
    }

    public final float getSensitivity() {
        return this.sensitivity;
    }

    public final void setSensitivity(float f) {
        this.sensitivity = f;
    }

    public final float getZoom() {
        return this.zoom;
    }

    public final void setZoom(float f) {
        this.zoom = f;
    }

    public final float getMinZoom() {
        return this.minZoom;
    }

    public final void setMinZoom(float f) {
        this.minZoom = f;
    }

    public final float getMaxZoom() {
        return this.maxZoom;
    }

    public final void setMaxZoom(float f) {
        this.maxZoom = f;
    }

    @NotNull
    public final Mat4f getTrackedPose() {
        return this.trackedPose;
    }

    public final void setTrackedPose(@NotNull Mat4f mat4f) {
        Intrinsics.checkNotNullParameter((Object)mat4f, (String)"<set-?>");
        this.trackedPose = mat4f;
    }

    @NotNull
    public final MutableVec3f getPivotPoint() {
        return this.pivotPoint;
    }

    @NotNull
    public final MutableVec3f getLookDirection() {
        return this.lookDirection;
    }

    @NotNull
    public final Function1<Float, Float> getZoomModifier() {
        return this.zoomModifier;
    }

    public final void setZoomModifier(@NotNull Function1<? super Float, Float> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"<set-?>");
        this.zoomModifier = function1;
    }

    private final BoxGeometry getHitSweepGeometry() {
        Lazy lazy = this.hitSweepGeometry$delegate;
        return (BoxGeometry)lazy.getValue();
    }

    public final void setupCollisionAwareCamZoom(@NotNull PhysicsWorld world) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        MutableVec3f testDir = new MutableVec3f();
        HitResult hitResult = new HitResult();
        this.zoomModifier = (Function1)new Function1<Float, Float>(this, testDir, world, hitResult){
            final /* synthetic */ CharacterTrackingCamRig this$0;
            final /* synthetic */ MutableVec3f $testDir;
            final /* synthetic */ PhysicsWorld $world;
            final /* synthetic */ HitResult $hitResult;
            {
                this.this$0 = $receiver;
                this.$testDir = $testDir;
                this.$world = $world;
                this.$hitResult = $hitResult;
                super(1);
            }

            @NotNull
            public final Float invoke(float desiredZoom) {
                float zoom = desiredZoom;
                this.this$0.getTransform().transform(this.$testDir.set(0.0f, 0.0f, 1.0f).norm(), 0.0f);
                CharacterTrackingCamRig.access$getHitSweepGeometryPose$p(this.this$0).set(this.this$0.getTransform().getMatrix());
                if (this.$world.sweepTest(CharacterTrackingCamRig.access$getHitSweepGeometry(this.this$0), CharacterTrackingCamRig.access$getHitSweepGeometryPose$p(this.this$0), (Vec3f)this.$testDir, desiredZoom, this.$hitResult)) {
                    zoom = Math.max(this.this$0.getMinZoom(), this.$hitResult.getHitDistance());
                }
                return Float.valueOf(zoom);
            }
        };
    }

    public final void applyLookDirection() {
        this.lookPhi = (float)Math.atan2(this.lookDirection.getZ(), this.lookDirection.getX());
        this.lookTheta = (float)Math.acos(this.lookDirection.getY());
    }

    private final void handlePointerInput() {
        float min$iv;
        float $this$clamp$iv;
        this.applyLookDirection();
        float div = 1000.0f / this.sensitivity;
        Pointer ptr = PointerInput.INSTANCE.getPrimaryPointer();
        this.lookPhi -= (float)ptr.getDeltaX() / div;
        float f = this.lookTheta - (float)ptr.getDeltaY() / div;
        float f2 = 1.0E-4f;
        float max$iv = 3.1414928f;
        boolean $i$f$clamp = false;
        this.lookTheta = $this$clamp$iv < min$iv ? min$iv : ($this$clamp$iv > max$iv ? max$iv : $this$clamp$iv);
        this.lookDirection.setX((float)Math.sin(this.lookTheta) * (float)Math.cos(this.lookPhi));
        this.lookDirection.setZ((float)Math.sin(this.lookTheta) * (float)Math.sin(this.lookPhi));
        this.lookDirection.setY((float)Math.cos(this.lookTheta));
        if (!ptr.isConsumed(64)) {
            this.zoom *= 1.0f - (float)PointerInput.INSTANCE.getPrimaryPointer().getDeltaScroll() / 10.0f;
            $this$clamp$iv = this.zoom;
            min$iv = this.minZoom;
            max$iv = this.maxZoom;
            $i$f$clamp = false;
            this.zoom = $this$clamp$iv < min$iv ? min$iv : ($this$clamp$iv > max$iv ? max$iv : $this$clamp$iv);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void updateTracking(float deltaT) {
        float min$iv;
        void $this$clamp$iv;
        Mat4f.transform$default((Mat4f)this.trackedPose, (MutableVec3f)this.poseOrigin.set(Vec3f.Companion.getZERO()), (float)0.0f, (int)2, null);
        this.getTransform().setIdentity();
        this.getTransform().translate((Vec3f)this.poseOrigin);
        float $this$toDeg$iv = this.lookPhi;
        boolean $i$f$toDeg = false;
        this.getTransform().rotate($this$toDeg$iv * 57.29578f + 90.0f, Vec3f.Companion.getY_AXIS());
        this.getTransform().translate((Vec3f)this.pivotPoint);
        $this$toDeg$iv = this.lookTheta;
        $i$f$toDeg = false;
        this.getTransform().rotate($this$toDeg$iv * 57.29578f - 90.0f, Vec3f.Companion.getX_AXIS());
        float modZoom = ((Number)this.zoomModifier.invoke((Object)Float.valueOf(this.zoom))).floatValue();
        float f = 15.0f * deltaT;
        float f2 = 0.05f;
        float max$iv = 0.95f;
        boolean $i$f$clamp = false;
        void wMod = $this$clamp$iv < min$iv ? min$iv : ($this$clamp$iv > max$iv ? max$iv : $this$clamp$iv);
        this.actualZoom = modZoom * wMod + this.actualZoom * (1.0f - wMod);
        this.getTransform().scale(this.actualZoom);
    }

    public CharacterTrackingCamRig() {
        this(false, 1, null);
    }

    public static final /* synthetic */ Mat4f access$getHitSweepGeometryPose$p(CharacterTrackingCamRig $this) {
        return $this.hitSweepGeometryPose;
    }

    public static final /* synthetic */ BoxGeometry access$getHitSweepGeometry(CharacterTrackingCamRig $this) {
        return $this.getHitSweepGeometry();
    }
}

