/*
 * Decompiled with CFR 0.152.
 */
package de.fabmax.kool.physics.joints;

import de.fabmax.kool.math.Mat4f;
import de.fabmax.kool.math.MutableVec3f;
import de.fabmax.kool.math.Vec3f;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006\u00a8\u0006\b"}, d2={"Lde/fabmax/kool/physics/joints/RevoluteJointHelper;", "", "()V", "computeFrame", "Lde/fabmax/kool/math/Mat4f;", "pivot", "Lde/fabmax/kool/math/Vec3f;", "axis", "kool-physics"})
public final class RevoluteJointHelper {
    @NotNull
    public static final RevoluteJointHelper INSTANCE = new RevoluteJointHelper();

    private RevoluteJointHelper() {
    }

    @NotNull
    public final Mat4f computeFrame(@NotNull Vec3f pivot, @NotNull Vec3f axis) {
        Intrinsics.checkNotNullParameter((Object)pivot, (String)"pivot");
        Intrinsics.checkNotNullParameter((Object)axis, (String)"axis");
        MutableVec3f ax1 = new MutableVec3f();
        MutableVec3f ax2 = new MutableVec3f();
        float dot = axis.times(Vec3f.Companion.getX_AXIS());
        if (dot >= 0.9999999f) {
            ax1.set(Vec3f.Companion.getZ_AXIS());
            ax2.set(Vec3f.Companion.getY_AXIS());
        } else if (dot <= -0.9999999f) {
            ax1.set(Vec3f.Companion.getNEG_Z_AXIS());
            ax2.set(Vec3f.Companion.getNEG_Y_AXIS());
        } else {
            axis.cross(Vec3f.Companion.getX_AXIS(), ax2);
            axis.cross((Vec3f)ax2, ax1);
        }
        Mat4f frame = new Mat4f();
        frame.translate(pivot);
        frame.setCol(0, axis, 0.0f);
        frame.setCol(1, (Vec3f)ax2.norm(), 0.0f);
        frame.setCol(2, (Vec3f)ax1.norm(), 0.0f);
        return frame;
    }
}

