/*
 * Decompiled with CFR 0.152.
 */
package de.fabmax.kool.physics.joints;

import de.fabmax.kool.math.Mat4f;
import de.fabmax.kool.physics.PhysXExtensionsKt;
import de.fabmax.kool.physics.Physics;
import de.fabmax.kool.physics.RigidActor;
import de.fabmax.kool.physics.joints.Joint;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.system.MemoryStack;
import physx.PxTopLevelFunctions;
import physx.common.PxTransform;
import physx.extensions.PxFixedJoint;
import physx.physics.PxPhysics;
import physx.physics.PxRigidActor;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lde/fabmax/kool/physics/joints/FixedJoint;", "Lde/fabmax/kool/physics/joints/Joint;", "bodyA", "Lde/fabmax/kool/physics/RigidActor;", "bodyB", "frameA", "Lde/fabmax/kool/math/Mat4f;", "frameB", "(Lde/fabmax/kool/physics/RigidActor;Lde/fabmax/kool/physics/RigidActor;Lde/fabmax/kool/math/Mat4f;Lde/fabmax/kool/math/Mat4f;)V", "getBodyA", "()Lde/fabmax/kool/physics/RigidActor;", "getBodyB", "getFrameA", "()Lde/fabmax/kool/math/Mat4f;", "getFrameB", "pxJoint", "Lphysx/extensions/PxFixedJoint;", "getPxJoint", "()Lphysx/extensions/PxFixedJoint;", "kool-physics"})
public final class FixedJoint
extends Joint {
    @NotNull
    private final RigidActor bodyA;
    @NotNull
    private final RigidActor bodyB;
    @NotNull
    private final Mat4f frameA;
    @NotNull
    private final Mat4f frameB;
    @NotNull
    private final PxFixedJoint pxJoint;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FixedJoint(@NotNull RigidActor bodyA, @NotNull RigidActor bodyB, @NotNull Mat4f frameA, @NotNull Mat4f frameB) {
        Intrinsics.checkNotNullParameter((Object)bodyA, (String)"bodyA");
        Intrinsics.checkNotNullParameter((Object)bodyB, (String)"bodyB");
        Intrinsics.checkNotNullParameter((Object)frameA, (String)"frameA");
        Intrinsics.checkNotNullParameter((Object)frameB, (String)"frameB");
        this.bodyA = bodyA;
        this.bodyB = bodyB;
        this.frameA = new Mat4f().set(frameA);
        this.frameB = new Mat4f().set(frameB);
        Physics.INSTANCE.checkIsLoaded();
        AutoCloseable autoCloseable = (AutoCloseable)MemoryStack.stackPush();
        Throwable throwable = null;
        try {
            MemoryStack mem = (MemoryStack)autoCloseable;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)mem, (String)"mem");
            PxTransform pxTransform = PhysXExtensionsKt.createPxTransform(mem);
            Intrinsics.checkNotNullExpressionValue((Object)pxTransform, (String)"mem.createPxTransform()");
            PxTransform frmA = PhysXExtensionsKt.toPxTransform(frameA, pxTransform);
            PxTransform pxTransform2 = PhysXExtensionsKt.createPxTransform(mem);
            Intrinsics.checkNotNullExpressionValue((Object)pxTransform2, (String)"mem.createPxTransform()");
            PxTransform frmB = PhysXExtensionsKt.toPxTransform(frameB, pxTransform2);
            PxFixedJoint pxFixedJoint = PxTopLevelFunctions.FixedJointCreate((PxPhysics)Physics.INSTANCE.getPhysics(), (PxRigidActor)this.bodyA.getPxRigidActor(), (PxTransform)frmA, (PxRigidActor)this.bodyB.getPxRigidActor(), (PxTransform)frmB);
            Intrinsics.checkNotNullExpressionValue((Object)pxFixedJoint, (String)"FixedJointCreate(Physics\u2026bodyB.pxRigidActor, frmB)");
            this.pxJoint = pxFixedJoint;
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    @NotNull
    public final RigidActor getBodyA() {
        return this.bodyA;
    }

    @NotNull
    public final RigidActor getBodyB() {
        return this.bodyB;
    }

    @NotNull
    public final Mat4f getFrameA() {
        return this.frameA;
    }

    @NotNull
    public final Mat4f getFrameB() {
        return this.frameB;
    }

    @NotNull
    public PxFixedJoint getPxJoint() {
        return this.pxJoint;
    }
}

