/*
 * Decompiled with CFR 0.152.
 */
package de.fabmax.kool.physics.joints;

import de.fabmax.kool.math.Mat4f;
import de.fabmax.kool.physics.PhysXExtensionsKt;
import de.fabmax.kool.physics.Physics;
import de.fabmax.kool.physics.RigidActor;
import de.fabmax.kool.physics.joints.Joint;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.system.MemoryStack;
import physx.PxTopLevelFunctions;
import physx.common.PxTransform;
import physx.extensions.PxDistanceJoint;
import physx.extensions.PxDistanceJointFlagEnum;
import physx.physics.PxPhysics;
import physx.physics.PxRigidActor;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0003\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u0015\u001a\u00020\u0016J\u0006\u0010\u0017\u001a\u00020\u0016J\u000e\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u001aR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\f\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0014\u0010\u0011\u001a\u00020\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001d"}, d2={"Lde/fabmax/kool/physics/joints/DistanceJoint;", "Lde/fabmax/kool/physics/joints/Joint;", "bodyA", "Lde/fabmax/kool/physics/RigidActor;", "bodyB", "posA", "Lde/fabmax/kool/math/Mat4f;", "posB", "(Lde/fabmax/kool/physics/RigidActor;Lde/fabmax/kool/physics/RigidActor;Lde/fabmax/kool/math/Mat4f;Lde/fabmax/kool/math/Mat4f;)V", "getBodyA", "()Lde/fabmax/kool/physics/RigidActor;", "getBodyB", "frameA", "getFrameA", "()Lde/fabmax/kool/math/Mat4f;", "frameB", "getFrameB", "pxJoint", "Lphysx/extensions/PxDistanceJoint;", "getPxJoint", "()Lphysx/extensions/PxDistanceJoint;", "removeMaxDistance", "", "removeMinDistance", "setMaxDistance", "maxDistance", "", "setMinDistance", "minDistance", "kool-physics"})
public final class DistanceJoint
extends Joint {
    @NotNull
    private final RigidActor bodyA;
    @NotNull
    private final RigidActor bodyB;
    @NotNull
    private final Mat4f frameA;
    @NotNull
    private final Mat4f frameB;
    @NotNull
    private final PxDistanceJoint pxJoint;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DistanceJoint(@NotNull RigidActor bodyA, @NotNull RigidActor bodyB, @NotNull Mat4f posA, @NotNull Mat4f posB) {
        Intrinsics.checkNotNullParameter((Object)bodyA, (String)"bodyA");
        Intrinsics.checkNotNullParameter((Object)bodyB, (String)"bodyB");
        Intrinsics.checkNotNullParameter((Object)posA, (String)"posA");
        Intrinsics.checkNotNullParameter((Object)posB, (String)"posB");
        this.bodyA = bodyA;
        this.bodyB = bodyB;
        this.frameA = new Mat4f().set(posA);
        this.frameB = new Mat4f().set(posB);
        Physics.INSTANCE.checkIsLoaded();
        AutoCloseable autoCloseable = (AutoCloseable)MemoryStack.stackPush();
        Throwable throwable = null;
        try {
            MemoryStack mem = (MemoryStack)autoCloseable;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)mem, (String)"mem");
            PxTransform pxTransform = PhysXExtensionsKt.createPxTransform(mem);
            Intrinsics.checkNotNullExpressionValue((Object)pxTransform, (String)"mem.createPxTransform()");
            PxTransform frmA = PhysXExtensionsKt.toPxTransform(this.frameA, pxTransform);
            PxTransform pxTransform2 = PhysXExtensionsKt.createPxTransform(mem);
            Intrinsics.checkNotNullExpressionValue((Object)pxTransform2, (String)"mem.createPxTransform()");
            PxTransform frmB = PhysXExtensionsKt.toPxTransform(this.frameB, pxTransform2);
            PxDistanceJoint pxDistanceJoint = PxTopLevelFunctions.DistanceJointCreate((PxPhysics)Physics.INSTANCE.getPhysics(), (PxRigidActor)this.bodyA.getPxRigidActor(), (PxTransform)frmA, (PxRigidActor)this.bodyB.getPxRigidActor(), (PxTransform)frmB);
            Intrinsics.checkNotNullExpressionValue((Object)pxDistanceJoint, (String)"DistanceJointCreate(Phys\u2026bodyB.pxRigidActor, frmB)");
            this.pxJoint = pxDistanceJoint;
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    @NotNull
    public final RigidActor getBodyA() {
        return this.bodyA;
    }

    @NotNull
    public final RigidActor getBodyB() {
        return this.bodyB;
    }

    @NotNull
    public final Mat4f getFrameA() {
        return this.frameA;
    }

    @NotNull
    public final Mat4f getFrameB() {
        return this.frameB;
    }

    @NotNull
    public PxDistanceJoint getPxJoint() {
        return this.pxJoint;
    }

    public final void setMaxDistance(float maxDistance) {
        this.getPxJoint().setMaxDistance(maxDistance);
        this.getPxJoint().setDistanceJointFlag(PxDistanceJointFlagEnum.eMAX_DISTANCE_ENABLED, true);
    }

    public final void setMinDistance(float minDistance) {
        this.getPxJoint().setMinDistance(minDistance);
        this.getPxJoint().setDistanceJointFlag(PxDistanceJointFlagEnum.eMIN_DISTANCE_ENABLED, true);
    }

    public final void removeMaxDistance() {
        this.getPxJoint().setDistanceJointFlag(PxDistanceJointFlagEnum.eMAX_DISTANCE_ENABLED, false);
    }

    public final void removeMinDistance() {
        this.getPxJoint().setDistanceJointFlag(PxDistanceJointFlagEnum.eMIN_DISTANCE_ENABLED, false);
    }
}

