/*
 * Decompiled with CFR 0.152.
 */
package de.fabmax.kool.physics.joints;

import de.fabmax.kool.math.Mat4f;
import de.fabmax.kool.physics.PhysXExtensionsKt;
import de.fabmax.kool.physics.Physics;
import de.fabmax.kool.physics.RigidActor;
import de.fabmax.kool.physics.joints.D6JointMotion;
import de.fabmax.kool.physics.joints.Joint;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.system.MemoryStack;
import physx.PxTopLevelFunctions;
import physx.common.PxTransform;
import physx.extensions.PxD6AxisEnum;
import physx.extensions.PxD6Joint;
import physx.extensions.PxD6MotionEnum;
import physx.extensions.PxJointLinearLimit;
import physx.extensions.PxJointLinearLimitPair;
import physx.extensions.PxSpring;
import physx.physics.PxPhysics;
import physx.physics.PxRigidActor;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bJ\u001e\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020%2\u0006\u0010'\u001a\u00020%J&\u0010(\u001a\u00020#2\u0006\u0010)\u001a\u00020%2\u0006\u0010*\u001a\u00020%2\u0006\u0010&\u001a\u00020%2\u0006\u0010'\u001a\u00020%J&\u0010+\u001a\u00020#2\u0006\u0010)\u001a\u00020%2\u0006\u0010*\u001a\u00020%2\u0006\u0010&\u001a\u00020%2\u0006\u0010'\u001a\u00020%J&\u0010,\u001a\u00020#2\u0006\u0010)\u001a\u00020%2\u0006\u0010*\u001a\u00020%2\u0006\u0010&\u001a\u00020%2\u0006\u0010'\u001a\u00020%R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\f\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR$\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u00128F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R$\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u00128F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0019\u0010\u0015\"\u0004\b\u001a\u0010\u0017R$\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u00128F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001c\u0010\u0015\"\u0004\b\u001d\u0010\u0017R\u0014\u0010\u001e\u001a\u00020\u001fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!\u00a8\u0006-"}, d2={"Lde/fabmax/kool/physics/joints/D6Joint;", "Lde/fabmax/kool/physics/joints/Joint;", "bodyA", "Lde/fabmax/kool/physics/RigidActor;", "bodyB", "posA", "Lde/fabmax/kool/math/Mat4f;", "posB", "(Lde/fabmax/kool/physics/RigidActor;Lde/fabmax/kool/physics/RigidActor;Lde/fabmax/kool/math/Mat4f;Lde/fabmax/kool/math/Mat4f;)V", "getBodyA", "()Lde/fabmax/kool/physics/RigidActor;", "getBodyB", "frameA", "getFrameA", "()Lde/fabmax/kool/math/Mat4f;", "frameB", "getFrameB", "value", "Lde/fabmax/kool/physics/joints/D6JointMotion;", "motionX", "getMotionX", "()Lde/fabmax/kool/physics/joints/D6JointMotion;", "setMotionX", "(Lde/fabmax/kool/physics/joints/D6JointMotion;)V", "motionY", "getMotionY", "setMotionY", "motionZ", "getMotionZ", "setMotionZ", "pxJoint", "Lphysx/extensions/PxD6Joint;", "getPxJoint", "()Lphysx/extensions/PxD6Joint;", "setDistanceLimit", "", "extend", "", "stiffness", "damping", "setXLinearLimit", "lowerLimit", "upperLimit", "setYLinearLimit", "setZLinearLimit", "kool-physics"})
public final class D6Joint
extends Joint {
    @NotNull
    private final RigidActor bodyA;
    @NotNull
    private final RigidActor bodyB;
    @NotNull
    private final Mat4f frameA;
    @NotNull
    private final Mat4f frameB;
    @NotNull
    private final PxD6Joint pxJoint;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public D6Joint(@NotNull RigidActor bodyA, @NotNull RigidActor bodyB, @NotNull Mat4f posA, @NotNull Mat4f posB) {
        Intrinsics.checkNotNullParameter((Object)bodyA, (String)"bodyA");
        Intrinsics.checkNotNullParameter((Object)bodyB, (String)"bodyB");
        Intrinsics.checkNotNullParameter((Object)posA, (String)"posA");
        Intrinsics.checkNotNullParameter((Object)posB, (String)"posB");
        this.bodyA = bodyA;
        this.bodyB = bodyB;
        this.frameA = new Mat4f().set(posA);
        this.frameB = new Mat4f().set(posB);
        Physics.INSTANCE.checkIsLoaded();
        AutoCloseable autoCloseable = (AutoCloseable)MemoryStack.stackPush();
        Throwable throwable = null;
        try {
            MemoryStack mem = (MemoryStack)autoCloseable;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)mem, (String)"mem");
            PxTransform pxTransform = PhysXExtensionsKt.createPxTransform(mem);
            Intrinsics.checkNotNullExpressionValue((Object)pxTransform, (String)"mem.createPxTransform()");
            PxTransform frmA = PhysXExtensionsKt.toPxTransform(this.frameA, pxTransform);
            PxTransform pxTransform2 = PhysXExtensionsKt.createPxTransform(mem);
            Intrinsics.checkNotNullExpressionValue((Object)pxTransform2, (String)"mem.createPxTransform()");
            PxTransform frmB = PhysXExtensionsKt.toPxTransform(this.frameB, pxTransform2);
            PxD6Joint pxD6Joint = PxTopLevelFunctions.D6JointCreate((PxPhysics)Physics.INSTANCE.getPhysics(), (PxRigidActor)this.bodyA.getPxRigidActor(), (PxTransform)frmA, (PxRigidActor)this.bodyB.getPxRigidActor(), (PxTransform)frmB);
            Intrinsics.checkNotNullExpressionValue((Object)pxD6Joint, (String)"D6JointCreate(Physics.ph\u2026bodyB.pxRigidActor, frmB)");
            this.pxJoint = pxD6Joint;
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    @NotNull
    public final RigidActor getBodyA() {
        return this.bodyA;
    }

    @NotNull
    public final RigidActor getBodyB() {
        return this.bodyB;
    }

    @NotNull
    public final Mat4f getFrameA() {
        return this.frameA;
    }

    @NotNull
    public final Mat4f getFrameB() {
        return this.frameB;
    }

    @NotNull
    public PxD6Joint getPxJoint() {
        return this.pxJoint;
    }

    @NotNull
    public final D6JointMotion getMotionX() {
        PxD6MotionEnum pxD6MotionEnum = this.getPxJoint().getMotion(PxD6AxisEnum.eX);
        Intrinsics.checkNotNullExpressionValue((Object)pxD6MotionEnum, (String)"pxJoint.getMotion(PxD6AxisEnum.eX)");
        return D6JointMotion.Companion.fromPx(pxD6MotionEnum);
    }

    public final void setMotionX(@NotNull D6JointMotion value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        this.getPxJoint().setMotion(PxD6AxisEnum.eX, value.getPxVal());
    }

    @NotNull
    public final D6JointMotion getMotionY() {
        PxD6MotionEnum pxD6MotionEnum = this.getPxJoint().getMotion(PxD6AxisEnum.eY);
        Intrinsics.checkNotNullExpressionValue((Object)pxD6MotionEnum, (String)"pxJoint.getMotion(PxD6AxisEnum.eY)");
        return D6JointMotion.Companion.fromPx(pxD6MotionEnum);
    }

    public final void setMotionY(@NotNull D6JointMotion value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        this.getPxJoint().setMotion(PxD6AxisEnum.eY, value.getPxVal());
    }

    @NotNull
    public final D6JointMotion getMotionZ() {
        PxD6MotionEnum pxD6MotionEnum = this.getPxJoint().getMotion(PxD6AxisEnum.eZ);
        Intrinsics.checkNotNullExpressionValue((Object)pxD6MotionEnum, (String)"pxJoint.getMotion(PxD6AxisEnum.eZ)");
        return D6JointMotion.Companion.fromPx(pxD6MotionEnum);
    }

    public final void setMotionZ(@NotNull D6JointMotion value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        this.getPxJoint().setMotion(PxD6AxisEnum.eZ, value.getPxVal());
    }

    public final void setDistanceLimit(float extend, float stiffness, float damping) {
        this.getPxJoint().setDistanceLimit(new PxJointLinearLimit(extend, new PxSpring(stiffness, damping)));
    }

    public final void setXLinearLimit(float lowerLimit, float upperLimit, float stiffness, float damping) {
        this.getPxJoint().setLinearLimit(PxD6AxisEnum.eX, new PxJointLinearLimitPair(lowerLimit, upperLimit, new PxSpring(stiffness, damping)));
        this.setMotionX(D6JointMotion.Limited);
    }

    public final void setYLinearLimit(float lowerLimit, float upperLimit, float stiffness, float damping) {
        this.getPxJoint().setLinearLimit(PxD6AxisEnum.eY, new PxJointLinearLimitPair(lowerLimit, upperLimit, new PxSpring(stiffness, damping)));
        this.setMotionY(D6JointMotion.Limited);
    }

    public final void setZLinearLimit(float lowerLimit, float upperLimit, float stiffness, float damping) {
        this.getPxJoint().setLinearLimit(PxD6AxisEnum.eZ, new PxJointLinearLimitPair(lowerLimit, upperLimit, new PxSpring(stiffness, damping)));
        this.setMotionZ(D6JointMotion.Limited);
    }
}

