/*
 * Decompiled with CFR 0.152.
 */
package de.fabmax.kool.physics.geometry;

import de.fabmax.kool.KoolContext;
import de.fabmax.kool.math.Vec3f;
import de.fabmax.kool.physics.PhysXExtensionsKt;
import de.fabmax.kool.physics.Physics;
import de.fabmax.kool.physics.Releasable;
import de.fabmax.kool.scene.geometry.IndexedVertexList;
import de.fabmax.kool.scene.geometry.VertexView;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.system.MemoryStack;
import physx.NativeObject;
import physx.common.PxBoundedData;
import physx.common.PxVec3;
import physx.cooking.PxTriangleMeshDesc;
import physx.geometry.PxTriangleMesh;
import physx.support.Vector_PxU32;
import physx.support.Vector_PxVec3;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0017\u001a\u00020\u0018H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0019"}, d2={"Lde/fabmax/kool/physics/geometry/TriangleMesh;", "Lde/fabmax/kool/physics/Releasable;", "geometry", "Lde/fabmax/kool/scene/geometry/IndexedVertexList;", "(Lde/fabmax/kool/scene/geometry/IndexedVertexList;)V", "getGeometry", "()Lde/fabmax/kool/scene/geometry/IndexedVertexList;", "pxTriangleMesh", "Lphysx/geometry/PxTriangleMesh;", "getPxTriangleMesh", "()Lphysx/geometry/PxTriangleMesh;", "refCnt", "", "getRefCnt$kool_physics", "()I", "setRefCnt$kool_physics", "(I)V", "releaseWithGeometry", "", "getReleaseWithGeometry", "()Z", "setReleaseWithGeometry", "(Z)V", "release", "", "kool-physics"})
@SourceDebugExtension(value={"SMAP\nTriangleMesh.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TriangleMesh.kt\nde/fabmax/kool/physics/geometry/TriangleMesh\n+ 2 IndexedVertexList.kt\nde/fabmax/kool/scene/geometry/IndexedVertexList\n*L\n1#1,60:1\n317#2,5:61\n*S KotlinDebug\n*F\n+ 1 TriangleMesh.kt\nde/fabmax/kool/physics/geometry/TriangleMesh\n*L\n24#1:61,5\n*E\n"})
public final class TriangleMesh
implements Releasable {
    @NotNull
    private final IndexedVertexList geometry;
    @NotNull
    private final PxTriangleMesh pxTriangleMesh;
    private boolean releaseWithGeometry;
    private int refCnt;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TriangleMesh(@NotNull IndexedVertexList geometry) {
        Intrinsics.checkNotNullParameter((Object)geometry, (String)"geometry");
        this.geometry = geometry;
        this.releaseWithGeometry = true;
        Physics.INSTANCE.checkIsLoaded();
        AutoCloseable autoCloseable = (AutoCloseable)MemoryStack.stackPush();
        Throwable throwable = null;
        try {
            MemoryStack mem = (MemoryStack)autoCloseable;
            boolean bl = false;
            Vector_PxVec3 pointVector = new Vector_PxVec3();
            Vector_PxU32 indexVector = new Vector_PxU32();
            Intrinsics.checkNotNullExpressionValue((Object)mem, (String)"mem");
            PxVec3 pxVec3 = PhysXExtensionsKt.createPxVec3(mem);
            IndexedVertexList this_$iv = this.geometry;
            int $i$f$forEach = 0;
            int n = this_$iv.getNumVertices();
            for (int i$iv = 0; i$iv < n; ++i$iv) {
                this_$iv.getVertexIt().setIndex(i$iv);
                VertexView it = this_$iv.getVertexIt();
                boolean bl2 = false;
                Vec3f vec3f = (Vec3f)it;
                Intrinsics.checkNotNullExpressionValue((Object)pxVec3, (String)"pxVec3");
                pointVector.push_back(PhysXExtensionsKt.toPxVec3(vec3f, pxVec3));
            }
            $i$f$forEach = this.geometry.getNumIndices();
            for (int i = 0; i < $i$f$forEach; ++i) {
                indexVector.push_back(this.geometry.getIndices().get(i));
            }
            PxBoundedData points = PhysXExtensionsKt.createPxBoundedData(mem);
            points.setCount(pointVector.size());
            points.setStride(PxVec3.SIZEOF);
            points.setData((NativeObject)pointVector.data());
            PxBoundedData triangles = PhysXExtensionsKt.createPxBoundedData(mem);
            triangles.setCount(indexVector.size() / 3);
            triangles.setStride(12);
            triangles.setData(indexVector.data());
            PxTriangleMeshDesc desc = PhysXExtensionsKt.createPxTriangleMeshDesc(mem);
            desc.setPoints(points);
            desc.setTriangles(triangles);
            PxTriangleMesh pxTriangleMesh = Physics.INSTANCE.getCooking().createTriangleMesh(desc, Physics.INSTANCE.getPhysics().getPhysicsInsertionCallback());
            Intrinsics.checkNotNullExpressionValue((Object)pxTriangleMesh, (String)"Physics.cooking.createTr\u2026physicsInsertionCallback)");
            this.pxTriangleMesh = pxTriangleMesh;
            pointVector.destroy();
            indexVector.destroy();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    @NotNull
    public final IndexedVertexList getGeometry() {
        return this.geometry;
    }

    @NotNull
    public final PxTriangleMesh getPxTriangleMesh() {
        return this.pxTriangleMesh;
    }

    public final boolean getReleaseWithGeometry() {
        return this.releaseWithGeometry;
    }

    public final void setReleaseWithGeometry(boolean bl) {
        this.releaseWithGeometry = bl;
    }

    public final int getRefCnt$kool_physics() {
        return this.refCnt;
    }

    public final void setRefCnt$kool_physics(int n) {
        this.refCnt = n;
    }

    @Override
    public void release() {
        this.pxTriangleMesh.release();
    }

    @Override
    public void dispose(@NotNull KoolContext ctx) {
        Releasable.DefaultImpls.dispose(this, ctx);
    }
}

