/*
 * Decompiled with CFR 0.152.
 */
package de.fabmax.kool.physics.geometry;

import de.fabmax.kool.KoolContext;
import de.fabmax.kool.physics.PhysXExtensionsKt;
import de.fabmax.kool.physics.Physics;
import de.fabmax.kool.physics.Releasable;
import de.fabmax.kool.util.HeightMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.system.MemoryStack;
import physx.NativeObject;
import physx.geometry.PxHeightField;
import physx.geometry.PxHeightFieldDesc;
import physx.geometry.PxHeightFieldFormatEnum;
import physx.geometry.PxHeightFieldSample;
import physx.support.Vector_PxHeightFieldSample;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u001f\u001a\u00020 H\u0016R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\tR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0013X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\t\u00a8\u0006!"}, d2={"Lde/fabmax/kool/physics/geometry/HeightField;", "Lde/fabmax/kool/physics/Releasable;", "heightMap", "Lde/fabmax/kool/util/HeightMap;", "rowScale", "", "columnScale", "(Lde/fabmax/kool/util/HeightMap;FF)V", "getColumnScale", "()F", "getHeightMap", "()Lde/fabmax/kool/util/HeightMap;", "heightScale", "getHeightScale", "pxHeightField", "Lphysx/geometry/PxHeightField;", "getPxHeightField", "()Lphysx/geometry/PxHeightField;", "refCnt", "", "getRefCnt$kool_physics", "()I", "setRefCnt$kool_physics", "(I)V", "releaseWithGeometry", "", "getReleaseWithGeometry", "()Z", "setReleaseWithGeometry", "(Z)V", "getRowScale", "release", "", "kool-physics"})
public final class HeightField
implements Releasable {
    @NotNull
    private final HeightMap heightMap;
    private final float rowScale;
    private final float columnScale;
    @NotNull
    private final PxHeightField pxHeightField;
    private final float heightScale;
    private boolean releaseWithGeometry;
    private int refCnt;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HeightField(@NotNull HeightMap heightMap, float rowScale, float columnScale) {
        Intrinsics.checkNotNullParameter((Object)heightMap, (String)"heightMap");
        this.heightMap = heightMap;
        this.rowScale = rowScale;
        this.columnScale = columnScale;
        this.releaseWithGeometry = true;
        float maxAbsHeight = Math.max(-this.heightMap.getMinHeight(), this.heightMap.getMaxHeight());
        this.heightScale = maxAbsHeight / 32767.0f;
        float revHeightToI16 = this.heightScale > 0.0f ? 1.0f / this.heightScale : 0.0f;
        Physics.INSTANCE.checkIsLoaded();
        AutoCloseable autoCloseable = (AutoCloseable)MemoryStack.stackPush();
        Throwable throwable = null;
        try {
            MemoryStack mem = (MemoryStack)autoCloseable;
            boolean bl = false;
            int rows = this.heightMap.getWidth();
            int cols = this.heightMap.getHeight();
            Intrinsics.checkNotNullExpressionValue((Object)mem, (String)"mem");
            PxHeightFieldSample sample = PhysXExtensionsKt.createPxHeightFieldSample(mem);
            Vector_PxHeightFieldSample samples = new Vector_PxHeightFieldSample();
            int row = 0;
            if (row <= rows) {
                while (true) {
                    for (int col = cols - 1; -1 < col; --col) {
                        sample.setHeight((short)MathKt.roundToInt((float)(this.heightMap.getHeight(row, col) * revHeightToI16)));
                        if (row % 2 != col % 2) {
                            sample.clearTessFlag();
                        } else {
                            sample.setTessFlag();
                        }
                        samples.push_back(sample);
                    }
                    if (row == rows) break;
                    ++row;
                }
            }
            PxHeightFieldDesc desc = PhysXExtensionsKt.createPxHeightFieldDesc(mem);
            desc.setFormat(PxHeightFieldFormatEnum.eS16_TM);
            desc.setNbRows(rows);
            desc.setNbColumns(cols);
            desc.getSamples().setData((NativeObject)samples.data());
            desc.getSamples().setStride(PxHeightFieldSample.SIZEOF);
            PxHeightField pxHeightField = Physics.INSTANCE.getCooking().createHeightField(desc, Physics.INSTANCE.getPhysics().getPhysicsInsertionCallback());
            Intrinsics.checkNotNullExpressionValue((Object)pxHeightField, (String)"Physics.cooking.createHe\u2026physicsInsertionCallback)");
            this.pxHeightField = pxHeightField;
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    @NotNull
    public final HeightMap getHeightMap() {
        return this.heightMap;
    }

    public final float getRowScale() {
        return this.rowScale;
    }

    public final float getColumnScale() {
        return this.columnScale;
    }

    @NotNull
    public final PxHeightField getPxHeightField() {
        return this.pxHeightField;
    }

    public final float getHeightScale() {
        return this.heightScale;
    }

    public final boolean getReleaseWithGeometry() {
        return this.releaseWithGeometry;
    }

    public final void setReleaseWithGeometry(boolean bl) {
        this.releaseWithGeometry = bl;
    }

    public final int getRefCnt$kool_physics() {
        return this.refCnt;
    }

    public final void setRefCnt$kool_physics(int n) {
        this.refCnt = n;
    }

    @Override
    public void release() {
        this.pxHeightField.release();
    }

    @Override
    public void dispose(@NotNull KoolContext ctx) {
        Releasable.DefaultImpls.dispose(this, ctx);
    }
}

