/*
 * Decompiled with CFR 0.152.
 */
package de.fabmax.kool.physics.geometry;

import de.fabmax.kool.KoolContext;
import de.fabmax.kool.math.Vec3f;
import de.fabmax.kool.physics.PhysXExtensionsKt;
import de.fabmax.kool.physics.Physics;
import de.fabmax.kool.physics.geometry.CollisionGeometry;
import de.fabmax.kool.physics.geometry.CommonConvexMeshGeometry;
import de.fabmax.kool.physics.geometry.ConvexMesh;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.system.MemoryStack;
import physx.common.PxQuat;
import physx.common.PxVec3;
import physx.geometry.PxConvexMeshGeometry;
import physx.geometry.PxGeometry;
import physx.geometry.PxMeshScale;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\b\u0016\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0002\u0010\u0006B\u0017\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0013"}, d2={"Lde/fabmax/kool/physics/geometry/ConvexMeshGeometry;", "Lde/fabmax/kool/physics/geometry/CommonConvexMeshGeometry;", "Lde/fabmax/kool/physics/geometry/CollisionGeometry;", "points", "", "Lde/fabmax/kool/math/Vec3f;", "(Ljava/util/List;)V", "convexMesh", "Lde/fabmax/kool/physics/geometry/ConvexMesh;", "scale", "(Lde/fabmax/kool/physics/geometry/ConvexMesh;Lde/fabmax/kool/math/Vec3f;)V", "pxGeometry", "Lphysx/geometry/PxGeometry;", "getPxGeometry", "()Lphysx/geometry/PxGeometry;", "dispose", "", "ctx", "Lde/fabmax/kool/KoolContext;", "kool-physics"})
public final class ConvexMeshGeometry
extends CommonConvexMeshGeometry
implements CollisionGeometry {
    @NotNull
    private final PxGeometry pxGeometry;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConvexMeshGeometry(@NotNull ConvexMesh convexMesh, @NotNull Vec3f scale) {
        Intrinsics.checkNotNullParameter((Object)convexMesh, (String)"convexMesh");
        Intrinsics.checkNotNullParameter((Object)scale, (String)"scale");
        super(convexMesh, scale);
        Physics.INSTANCE.checkIsLoaded();
        AutoCloseable autoCloseable = (AutoCloseable)MemoryStack.stackPush();
        Throwable throwable = null;
        try {
            MemoryStack mem = (MemoryStack)autoCloseable;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)mem, (String)"mem");
            PxVec3 pxVec3 = PhysXExtensionsKt.createPxVec3(mem);
            Intrinsics.checkNotNullExpressionValue((Object)pxVec3, (String)"mem.createPxVec3()");
            PxVec3 s = PhysXExtensionsKt.toPxVec3(scale, pxVec3);
            PxQuat r = PhysXExtensionsKt.createPxQuat(mem, 0.0f, 0.0f, 0.0f, 1.0f);
            Intrinsics.checkNotNullExpressionValue((Object)r, (String)"r");
            PxMeshScale meshScale = PhysXExtensionsKt.createPxMeshScale(mem, s, r);
            this.pxGeometry = (PxGeometry)new PxConvexMeshGeometry(convexMesh.getPxConvexMesh(), meshScale);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        if (convexMesh.getReleaseWithGeometry()) {
            if (convexMesh.getRefCnt$kool_physics() > 0) {
                convexMesh.getPxConvexMesh().acquireReference();
            }
            int n = convexMesh.getRefCnt$kool_physics();
            convexMesh.setRefCnt$kool_physics(n + 1);
        }
    }

    public /* synthetic */ ConvexMeshGeometry(ConvexMesh convexMesh, Vec3f vec3f, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            vec3f = Vec3f.Companion.getONES();
        }
        this(convexMesh, vec3f);
    }

    @Override
    @NotNull
    public PxGeometry getPxGeometry() {
        return this.pxGeometry;
    }

    public ConvexMeshGeometry(@NotNull List<? extends Vec3f> points) {
        Intrinsics.checkNotNullParameter(points, (String)"points");
        this(new ConvexMesh(points), null, 2, null);
    }

    @Override
    public void dispose(@NotNull KoolContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        CollisionGeometry.DefaultImpls.dispose(this, ctx);
        if (this.getConvexMesh().getReleaseWithGeometry()) {
            this.getConvexMesh().getPxConvexMesh().release();
        }
    }

    @Override
    public void release() {
        CollisionGeometry.DefaultImpls.release(this);
    }
}

