/*
 * Decompiled with CFR 0.152.
 */
package de.fabmax.kool.physics.geometry;

import de.fabmax.kool.KoolContext;
import de.fabmax.kool.math.MutableVec3f;
import de.fabmax.kool.math.Vec3f;
import de.fabmax.kool.physics.PhysXExtensionsKt;
import de.fabmax.kool.physics.Physics;
import de.fabmax.kool.physics.Releasable;
import de.fabmax.kool.pipeline.Attribute;
import de.fabmax.kool.scene.geometry.IndexedVertexList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.system.MemoryStack;
import physx.NativeObject;
import physx.common.PxVec3;
import physx.cooking.PxConvexFlagEnum;
import physx.cooking.PxConvexMeshDesc;
import physx.geometry.PxConvexMesh;
import physx.geometry.PxHullPolygon;
import physx.support.NativeArrayHelpers;
import physx.support.PxU8ConstPtr;
import physx.support.Vector_PxVec3;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\rH\u0002J\b\u0010 \u001a\u00020!H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001b\u00a8\u0006\""}, d2={"Lde/fabmax/kool/physics/geometry/ConvexMesh;", "Lde/fabmax/kool/physics/Releasable;", "points", "", "Lde/fabmax/kool/math/Vec3f;", "(Ljava/util/List;)V", "convexHull", "Lde/fabmax/kool/scene/geometry/IndexedVertexList;", "getConvexHull", "()Lde/fabmax/kool/scene/geometry/IndexedVertexList;", "getPoints", "()Ljava/util/List;", "pxConvexMesh", "Lphysx/geometry/PxConvexMesh;", "getPxConvexMesh", "()Lphysx/geometry/PxConvexMesh;", "refCnt", "", "getRefCnt$kool_physics", "()I", "setRefCnt$kool_physics", "(I)V", "releaseWithGeometry", "", "getReleaseWithGeometry", "()Z", "setReleaseWithGeometry", "(Z)V", "makeConvexHull", "mem", "Lorg/lwjgl/system/MemoryStack;", "convexMesh", "release", "", "kool-physics"})
public final class ConvexMesh
implements Releasable {
    @NotNull
    private final List<Vec3f> points;
    @NotNull
    private final IndexedVertexList convexHull;
    @NotNull
    private final PxConvexMesh pxConvexMesh;
    private boolean releaseWithGeometry;
    private int refCnt;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConvexMesh(@NotNull List<? extends Vec3f> points) {
        Intrinsics.checkNotNullParameter(points, (String)"points");
        this.points = points;
        this.releaseWithGeometry = true;
        Physics.INSTANCE.checkIsLoaded();
        AutoCloseable autoCloseable = (AutoCloseable)MemoryStack.stackPush();
        Throwable throwable = null;
        try {
            MemoryStack mem = (MemoryStack)autoCloseable;
            boolean bl = false;
            Vector_PxVec3 vec3Vector = PhysXExtensionsKt.toVector_PxVec3(this.points);
            Intrinsics.checkNotNullExpressionValue((Object)mem, (String)"mem");
            PxConvexMeshDesc desc = PhysXExtensionsKt.createPxConvexMeshDesc(mem);
            desc.setFlags(PhysXExtensionsKt.createPxConvexFlags(mem, PxConvexFlagEnum.eCOMPUTE_CONVEX.value));
            desc.getPoints().setCount(this.points.size());
            desc.getPoints().setStride(PxVec3.SIZEOF);
            desc.getPoints().setData((NativeObject)vec3Vector.data());
            PxConvexMesh pxConvexMesh = Physics.INSTANCE.getCooking().createConvexMesh(desc, Physics.INSTANCE.getPhysics().getPhysicsInsertionCallback());
            Intrinsics.checkNotNullExpressionValue((Object)pxConvexMesh, (String)"Physics.cooking.createCo\u2026physicsInsertionCallback)");
            this.pxConvexMesh = pxConvexMesh;
            vec3Vector.destroy();
            this.convexHull = this.makeConvexHull(mem, this.pxConvexMesh);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    @NotNull
    public final List<Vec3f> getPoints() {
        return this.points;
    }

    @NotNull
    public final IndexedVertexList getConvexHull() {
        return this.convexHull;
    }

    @NotNull
    public final PxConvexMesh getPxConvexMesh() {
        return this.pxConvexMesh;
    }

    public final boolean getReleaseWithGeometry() {
        return this.releaseWithGeometry;
    }

    public final void setReleaseWithGeometry(boolean bl) {
        this.releaseWithGeometry = bl;
    }

    public final int getRefCnt$kool_physics() {
        return this.refCnt;
    }

    public final void setRefCnt$kool_physics(int n) {
        this.refCnt = n;
    }

    private final IndexedVertexList makeConvexHull(MemoryStack mem, PxConvexMesh convexMesh) {
        Attribute[] attributeArray = new Attribute[]{Attribute.Companion.getPOSITIONS(), Attribute.Companion.getNORMALS()};
        IndexedVertexList geometry = new IndexedVertexList(attributeArray);
        MutableVec3f v = new MutableVec3f();
        List polyIndices = new ArrayList();
        PxHullPolygon poly = PhysXExtensionsKt.createPxHullPolygon(mem);
        int n = convexMesh.getNbPolygons();
        for (int i = 0; i < n; ++i) {
            int j;
            polyIndices.clear();
            convexMesh.getPolygonData(i, poly);
            int n2 = poly.getMNbVerts();
            for (j = 0; j < n2; ++j) {
                int vi = NativeArrayHelpers.getU8At((PxU8ConstPtr)convexMesh.getIndexBuffer(), (int)(poly.getMIndexBase() + j)) & 0xFF;
                PxVec3 pt = PxVec3.arrayGet((long)convexMesh.getVertices().getAddress(), (int)vi);
                Collection collection = polyIndices;
                Intrinsics.checkNotNullExpressionValue((Object)pt, (String)"pt");
                collection.add(IndexedVertexList.addVertex$default((IndexedVertexList)geometry, (Vec3f)((Vec3f)PhysXExtensionsKt.toVec3f(pt, v)), null, null, null, (int)14, null));
            }
            n2 = polyIndices.size();
            for (j = 2; j < n2; ++j) {
                int v0 = ((Number)polyIndices.get(0)).intValue();
                int v1 = ((Number)polyIndices.get(j - 1)).intValue();
                int v2 = ((Number)polyIndices.get(j)).intValue();
                geometry.addTriIndices(v0, v1, v2);
            }
        }
        geometry.generateNormals();
        return geometry;
    }

    @Override
    public void release() {
        this.pxConvexMesh.release();
    }

    @Override
    public void dispose(@NotNull KoolContext ctx) {
        Releasable.DefaultImpls.dispose(this, ctx);
    }
}

