/*
 * Decompiled with CFR 0.152.
 */
package de.fabmax.kool.physics.geometry;

import de.fabmax.kool.KoolContext;
import de.fabmax.kool.math.MutableVec3f;
import de.fabmax.kool.math.spatial.BoundingBox;
import de.fabmax.kool.physics.geometry.CollisionGeometry;
import de.fabmax.kool.physics.geometry.HeightField;
import de.fabmax.kool.scene.geometry.GridProps;
import de.fabmax.kool.scene.geometry.MeshBuilder;
import de.fabmax.kool.util.HeightMap;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J.\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0012J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000b\u001a\u00020\u0017H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0018"}, d2={"Lde/fabmax/kool/physics/geometry/CommonHeightFieldGeometry;", "Lde/fabmax/kool/physics/geometry/CollisionGeometry;", "heightField", "Lde/fabmax/kool/physics/geometry/HeightField;", "(Lde/fabmax/kool/physics/geometry/HeightField;)V", "getHeightField", "()Lde/fabmax/kool/physics/geometry/HeightField;", "estimateInertiaForMass", "Lde/fabmax/kool/math/MutableVec3f;", "mass", "", "result", "generateMesh", "", "target", "Lde/fabmax/kool/scene/geometry/MeshBuilder;", "generateTiledMesh", "gridX", "", "gridY", "gridSizeX", "gridSizeY", "getBounds", "Lde/fabmax/kool/math/spatial/BoundingBox;", "kool-physics"})
@SourceDebugExtension(value={"SMAP\nHeightFieldGeometry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HeightFieldGeometry.kt\nde/fabmax/kool/physics/geometry/CommonHeightFieldGeometry\n+ 2 MeshBuilder.kt\nde/fabmax/kool/scene/geometry/MeshBuilder\n*L\n1#1,68:1\n58#2,2:69\n790#2,4:71\n60#2,2:75\n58#2,2:77\n790#2,4:79\n60#2,2:83\n*S KotlinDebug\n*F\n+ 1 HeightFieldGeometry.kt\nde/fabmax/kool/physics/geometry/CommonHeightFieldGeometry\n*L\n13#1:69,2\n23#1:71,4\n13#1:75,2\n42#1:77,2\n46#1:79,4\n42#1:83,2\n*E\n"})
public abstract class CommonHeightFieldGeometry
implements CollisionGeometry {
    @NotNull
    private final HeightField heightField;

    public CommonHeightFieldGeometry(@NotNull HeightField heightField) {
        Intrinsics.checkNotNullParameter((Object)heightField, (String)"heightField");
        this.heightField = heightField;
    }

    @NotNull
    public final HeightField getHeightField() {
        return this.heightField;
    }

    public final void generateTiledMesh(@NotNull MeshBuilder target, int gridX, int gridY, int gridSizeX, int gridSizeY) {
        GridProps props$iv;
        MeshBuilder meshBuilder;
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        MeshBuilder $this$generateTiledMesh_u24lambda_u242 = meshBuilder = target;
        boolean bl = false;
        MeshBuilder this_$iv = $this$generateTiledMesh_u24lambda_u242;
        boolean $i$f$withTransform = false;
        this_$iv.getTransform().push();
        MeshBuilder $this$generateTiledMesh_u24lambda_u242_u24lambda_u241 = this_$iv;
        boolean bl2 = false;
        int stepsX = this.heightField.getHeightMap().getWidth() / gridSizeX;
        int stepsY = this.heightField.getHeightMap().getHeight() / gridSizeY;
        float szX = (float)stepsX * this.heightField.getRowScale();
        float szY = (float)stepsY * this.heightField.getColumnScale();
        float tx = (float)(gridX * stepsX) * this.heightField.getRowScale() + szX * 0.5f;
        float tz = (float)(this.heightField.getHeightMap().getHeight() - 1) * this.heightField.getColumnScale() - ((float)gridY + 0.5f) * (float)stepsY * this.heightField.getColumnScale();
        $this$generateTiledMesh_u24lambda_u242_u24lambda_u241.translate(tx, 0.0f, tz);
        MeshBuilder this_$iv2 = $this$generateTiledMesh_u24lambda_u242_u24lambda_u241;
        boolean $i$f$grid = false;
        GridProps $this$generateTiledMesh_u24lambda_u242_u24lambda_u241_u24lambda_u240 = props$iv = new GridProps();
        boolean bl3 = false;
        $this$generateTiledMesh_u24lambda_u242_u24lambda_u241_u24lambda_u240.setSizeX(szX);
        $this$generateTiledMesh_u24lambda_u242_u24lambda_u241_u24lambda_u240.setSizeY(szY);
        $this$generateTiledMesh_u24lambda_u242_u24lambda_u241_u24lambda_u240.setStepsX(stepsX);
        $this$generateTiledMesh_u24lambda_u242_u24lambda_u241_u24lambda_u240.setStepsY(stepsY);
        float tst = 0.0f;
        $this$generateTiledMesh_u24lambda_u242_u24lambda_u241_u24lambda_u240.getTexCoordScale().set(1.0f / (float)gridSizeX + tst, 1.0f / (float)gridSizeY + tst);
        $this$generateTiledMesh_u24lambda_u242_u24lambda_u241_u24lambda_u240.getTexCoordOffset().set((float)gridX / (float)gridSizeX, ((float)gridSizeY - 1.0f - (float)gridY) / (float)gridSizeY);
        $this$generateTiledMesh_u24lambda_u242_u24lambda_u241_u24lambda_u240.setHeightFun((Function2)new Function2<Integer, Integer, Float>(this, gridX, stepsX, gridY, stepsY){
            final /* synthetic */ CommonHeightFieldGeometry this$0;
            final /* synthetic */ int $gridX;
            final /* synthetic */ int $stepsX;
            final /* synthetic */ int $gridY;
            final /* synthetic */ int $stepsY;
            {
                this.this$0 = $receiver;
                this.$gridX = $gridX;
                this.$stepsX = $stepsX;
                this.$gridY = $gridY;
                this.$stepsY = $stepsY;
                super(2);
            }

            @NotNull
            public final Float invoke(int hx, int hy) {
                return Float.valueOf(this.this$0.getHeightField().getHeightMap().getHeight(hx + this.$gridX * this.$stepsX, hy + this.$gridY * this.$stepsY));
            }
        });
        this_$iv2.grid(props$iv);
        this_$iv.getTransform().pop();
    }

    @Override
    public void generateMesh(@NotNull MeshBuilder target) {
        GridProps props$iv;
        MeshBuilder meshBuilder;
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        MeshBuilder $this$generateMesh_u24lambda_u245 = meshBuilder = target;
        boolean bl = false;
        MeshBuilder this_$iv = $this$generateMesh_u24lambda_u245;
        boolean $i$f$withTransform = false;
        this_$iv.getTransform().push();
        MeshBuilder $this$generateMesh_u24lambda_u245_u24lambda_u244 = this_$iv;
        boolean bl2 = false;
        float szX = (float)(this.heightField.getHeightMap().getWidth() - 1) * this.heightField.getRowScale();
        float szY = (float)(this.heightField.getHeightMap().getHeight() - 1) * this.heightField.getColumnScale();
        $this$generateMesh_u24lambda_u245_u24lambda_u244.translate(szX * 0.5f, 0.0f, szY * 0.5f);
        MeshBuilder this_$iv2 = $this$generateMesh_u24lambda_u245_u24lambda_u244;
        boolean $i$f$grid = false;
        GridProps $this$generateMesh_u24lambda_u245_u24lambda_u244_u24lambda_u243 = props$iv = new GridProps();
        boolean bl3 = false;
        $this$generateMesh_u24lambda_u245_u24lambda_u244_u24lambda_u243.setSizeX(szX);
        $this$generateMesh_u24lambda_u245_u24lambda_u244_u24lambda_u243.setSizeY(szY);
        $this$generateMesh_u24lambda_u245_u24lambda_u244_u24lambda_u243.useHeightMap(this.heightField.getHeightMap());
        this_$iv2.grid(props$iv);
        this_$iv.getTransform().pop();
    }

    @Override
    @NotNull
    public BoundingBox getBounds(@NotNull BoundingBox result) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        float rowScale = this.heightField.getRowScale();
        float columnScale = this.heightField.getColumnScale();
        HeightMap map = this.heightField.getHeightMap();
        return result.set(0.0f, map.getMinHeight(), 0.0f, (float)map.getWidth() * rowScale, map.getMaxHeight(), (float)map.getHeight() * columnScale);
    }

    @Override
    @NotNull
    public MutableVec3f estimateInertiaForMass(float mass, @NotNull MutableVec3f result) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        return result.set(1.0f, 1.0f, 1.0f);
    }

    @Override
    public void release() {
        CollisionGeometry.DefaultImpls.release(this);
    }

    @Override
    public void dispose(@NotNull KoolContext ctx) {
        CollisionGeometry.DefaultImpls.dispose(this, ctx);
    }
}

