/*
 * Decompiled with CFR 0.152.
 */
package de.fabmax.kool.physics.geometry;

import de.fabmax.kool.math.MutableVec3f;
import de.fabmax.kool.math.Vec3f;
import de.fabmax.kool.math.spatial.BoundingBox;
import de.fabmax.kool.scene.geometry.CylinderProps;
import de.fabmax.kool.scene.geometry.MeshBuilder;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\nH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\u0012H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lde/fabmax/kool/physics/geometry/CommonCylinderGeometry;", "", "length", "", "radius", "(FF)V", "getLength", "()F", "getRadius", "estimateInertiaForMass", "Lde/fabmax/kool/math/MutableVec3f;", "mass", "result", "generateMesh", "", "target", "Lde/fabmax/kool/scene/geometry/MeshBuilder;", "getBounds", "Lde/fabmax/kool/math/spatial/BoundingBox;", "Companion", "kool-physics"})
@SourceDebugExtension(value={"SMAP\nCylinderGeometry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CylinderGeometry.kt\nde/fabmax/kool/physics/geometry/CommonCylinderGeometry\n+ 2 MeshBuilder.kt\nde/fabmax/kool/scene/geometry/MeshBuilder\n*L\n1#1,53:1\n58#2,2:54\n725#2,4:56\n60#2,2:60\n*S KotlinDebug\n*F\n+ 1 CylinderGeometry.kt\nde/fabmax/kool/physics/geometry/CommonCylinderGeometry\n*L\n16#1:54,2\n19#1:56,4\n16#1:60,2\n*E\n"})
public abstract class CommonCylinderGeometry {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final float length;
    private final float radius;

    public CommonCylinderGeometry(float length, float radius) {
        this.length = length;
        this.radius = radius;
    }

    public final float getLength() {
        return this.length;
    }

    public final float getRadius() {
        return this.radius;
    }

    public void generateMesh(@NotNull MeshBuilder target) {
        CylinderProps props$iv;
        MeshBuilder meshBuilder;
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        MeshBuilder $this$generateMesh_u24lambda_u242 = meshBuilder = target;
        boolean bl = false;
        MeshBuilder this_$iv = $this$generateMesh_u24lambda_u242;
        boolean $i$f$withTransform = false;
        this_$iv.getTransform().push();
        MeshBuilder $this$generateMesh_u24lambda_u242_u24lambda_u241 = this_$iv;
        boolean bl2 = false;
        $this$generateMesh_u24lambda_u242_u24lambda_u241.rotate(90.0f, Vec3f.Companion.getZ_AXIS());
        MeshBuilder this_$iv2 = $this$generateMesh_u24lambda_u242_u24lambda_u241;
        boolean $i$f$cylinder = false;
        CylinderProps $this$generateMesh_u24lambda_u242_u24lambda_u241_u24lambda_u240 = props$iv = new CylinderProps();
        boolean bl3 = false;
        $this$generateMesh_u24lambda_u242_u24lambda_u241_u24lambda_u240.setHeight(this.length);
        $this$generateMesh_u24lambda_u242_u24lambda_u241_u24lambda_u240.setRadius(this.radius);
        $this$generateMesh_u24lambda_u242_u24lambda_u241_u24lambda_u240.setSteps(32);
        $this$generateMesh_u24lambda_u242_u24lambda_u241_u24lambda_u240.getOrigin().set(0.0f, -$this$generateMesh_u24lambda_u242_u24lambda_u241_u24lambda_u240.getHeight() / 2.0f, 0.0f);
        this_$iv2.cylinder(props$iv);
        this_$iv.getTransform().pop();
    }

    @NotNull
    public BoundingBox getBounds(@NotNull BoundingBox result) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        result.set(-this.length * 0.5f, -this.radius, -this.radius, this.length * 0.5f, this.radius, this.radius);
        return result;
    }

    @NotNull
    public MutableVec3f estimateInertiaForMass(float mass, @NotNull MutableVec3f result) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        float ix = 0.5f * mass * this.radius * this.radius;
        float iyz = 0.083333336f * mass * ((float)3 * this.radius * this.radius + this.length * this.length);
        return result.set(ix, iyz, iyz);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\b\b\u0002\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lde/fabmax/kool/physics/geometry/CommonCylinderGeometry$Companion;", "", "()V", "convexMeshPoints", "", "Lde/fabmax/kool/math/Vec3f;", "length", "", "radius", "n", "", "kool-physics"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<Vec3f> convexMeshPoints(float length, float radius, int n) {
            List points = new ArrayList();
            for (int i = 0; i < n; ++i) {
                float a = (float)i * 2.0f * (float)Math.PI / (float)n;
                float y = (float)Math.cos(a) * radius;
                float z = (float)Math.sin(a) * radius;
                points.add(new Vec3f(length * -0.5f, y, z));
                points.add(new Vec3f(length * 0.5f, y, z));
            }
            return points;
        }

        public static /* synthetic */ List convexMeshPoints$default(Companion companion, float f, float f2, int n, int n2, Object object) {
            if ((n2 & 4) != 0) {
                n = 32;
            }
            return companion.convexMeshPoints(f, f2, n);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

