/*
 * Decompiled with CFR 0.152.
 */
package de.fabmax.kool.physics.geometry;

import de.fabmax.kool.math.MutableVec3f;
import de.fabmax.kool.math.Vec3f;
import de.fabmax.kool.math.spatial.BoundingBox;
import de.fabmax.kool.physics.geometry.ConvexMesh;
import de.fabmax.kool.scene.geometry.IndexedVertexList;
import de.fabmax.kool.scene.geometry.MeshBuilder;
import de.fabmax.kool.scene.geometry.VertexView;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u0015H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0016"}, d2={"Lde/fabmax/kool/physics/geometry/CommonConvexMeshGeometry;", "", "convexMesh", "Lde/fabmax/kool/physics/geometry/ConvexMesh;", "scale", "Lde/fabmax/kool/math/Vec3f;", "(Lde/fabmax/kool/physics/geometry/ConvexMesh;Lde/fabmax/kool/math/Vec3f;)V", "getConvexMesh", "()Lde/fabmax/kool/physics/geometry/ConvexMesh;", "getScale", "()Lde/fabmax/kool/math/Vec3f;", "estimateInertiaForMass", "Lde/fabmax/kool/math/MutableVec3f;", "mass", "", "result", "generateMesh", "", "target", "Lde/fabmax/kool/scene/geometry/MeshBuilder;", "getBounds", "Lde/fabmax/kool/math/spatial/BoundingBox;", "kool-physics"})
@SourceDebugExtension(value={"SMAP\nConvexMeshGeometry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConvexMeshGeometry.kt\nde/fabmax/kool/physics/geometry/CommonConvexMeshGeometry\n+ 2 MeshBuilder.kt\nde/fabmax/kool/scene/geometry/MeshBuilder\n+ 3 IndexedVertexList.kt\nde/fabmax/kool/scene/geometry/IndexedVertexList\n*L\n1#1,43:1\n58#2,2:44\n60#2,2:51\n317#3,5:46\n*S KotlinDebug\n*F\n+ 1 ConvexMeshGeometry.kt\nde/fabmax/kool/physics/geometry/CommonConvexMeshGeometry\n*L\n15#1:44,2\n15#1:51,2\n19#1:46,5\n*E\n"})
public abstract class CommonConvexMeshGeometry {
    @NotNull
    private final ConvexMesh convexMesh;
    @NotNull
    private final Vec3f scale;

    public CommonConvexMeshGeometry(@NotNull ConvexMesh convexMesh, @NotNull Vec3f scale) {
        Intrinsics.checkNotNullParameter((Object)convexMesh, (String)"convexMesh");
        Intrinsics.checkNotNullParameter((Object)scale, (String)"scale");
        this.convexMesh = convexMesh;
        this.scale = scale;
    }

    @NotNull
    public final ConvexMesh getConvexMesh() {
        return this.convexMesh;
    }

    @NotNull
    public final Vec3f getScale() {
        return this.scale;
    }

    public void generateMesh(@NotNull MeshBuilder target) {
        MeshBuilder meshBuilder;
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        MeshBuilder $this$generateMesh_u24lambda_u242 = meshBuilder = target;
        boolean bl = false;
        MeshBuilder this_$iv = $this$generateMesh_u24lambda_u242;
        boolean $i$f$withTransform = false;
        this_$iv.getTransform().push();
        MeshBuilder $this$generateMesh_u24lambda_u242_u24lambda_u241 = this_$iv;
        boolean bl2 = false;
        $this$generateMesh_u24lambda_u242_u24lambda_u241.scale(this.scale.getX(), this.scale.getY(), this.scale.getZ());
        IndexedVertexList hull = this.convexMesh.getConvexHull();
        List inds = new ArrayList();
        IndexedVertexList this_$iv2 = hull;
        boolean $i$f$forEach = false;
        int n = this_$iv2.getNumVertices();
        for (int i$iv = 0; i$iv < n; ++i$iv) {
            this_$iv2.getVertexIt().setIndex(i$iv);
            VertexView it = this_$iv2.getVertexIt();
            boolean bl3 = false;
            ((Collection)inds).add(MeshBuilder.vertex$default((MeshBuilder)$this$generateMesh_u24lambda_u242_u24lambda_u241, (Vec3f)((Vec3f)it), (Vec3f)((Vec3f)it.getNormal()), null, (int)4, null));
        }
        IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)0, (int)hull.getNumIndices())), (int)3);
        int i = intProgression.getFirst();
        int n2 = intProgression.getLast();
        n = intProgression.getStep();
        if (n > 0 && i <= n2 || n < 0 && n2 <= i) {
            while (true) {
                int i0 = ((Number)inds.get(hull.getIndices().get(i))).intValue();
                int i1 = ((Number)inds.get(hull.getIndices().get(i + 1))).intValue();
                int i2 = ((Number)inds.get(hull.getIndices().get(i + 2))).intValue();
                $this$generateMesh_u24lambda_u242_u24lambda_u241.getGeometry().addTriIndices(i0, i1, i2);
                if (i == n2) break;
                i += n;
            }
        }
        this_$iv.getTransform().pop();
    }

    @NotNull
    public BoundingBox getBounds(@NotNull BoundingBox result) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        return result.set(this.convexMesh.getConvexHull().getBounds());
    }

    @NotNull
    public MutableVec3f estimateInertiaForMass(float mass, @NotNull MutableVec3f result) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        BoundingBox bounds = this.convexMesh.getConvexHull().getBounds();
        result.setX(mass / 12.0f * (bounds.getSize().getY() * bounds.getSize().getY() + bounds.getSize().getZ() * bounds.getSize().getZ()));
        result.setZ(mass / 12.0f * (bounds.getSize().getX() * bounds.getSize().getX() + bounds.getSize().getY() * bounds.getSize().getY()));
        result.setY(mass / 12.0f * (bounds.getSize().getX() * bounds.getSize().getX() + bounds.getSize().getZ() * bounds.getSize().getZ()));
        return result;
    }
}

