/*
 * Decompiled with CFR 0.152.
 */
package de.fabmax.kool.physics.geometry;

import de.fabmax.kool.math.MutableVec3f;
import de.fabmax.kool.math.Vec2f;
import de.fabmax.kool.math.spatial.BoundingBox;
import de.fabmax.kool.scene.geometry.MeshBuilder;
import de.fabmax.kool.scene.geometry.Profile;
import de.fabmax.kool.scene.geometry.ShapeContainer;
import de.fabmax.kool.scene.geometry.SimpleShape;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\nH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\u0012H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lde/fabmax/kool/physics/geometry/CommonCapsuleGeometry;", "", "height", "", "radius", "(FF)V", "getHeight", "()F", "getRadius", "estimateInertiaForMass", "Lde/fabmax/kool/math/MutableVec3f;", "mass", "result", "generateMesh", "", "target", "Lde/fabmax/kool/scene/geometry/MeshBuilder;", "getBounds", "Lde/fabmax/kool/math/spatial/BoundingBox;", "kool-physics"})
@SourceDebugExtension(value={"SMAP\nCapsuleGeometry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CapsuleGeometry.kt\nde/fabmax/kool/physics/geometry/CommonCapsuleGeometry\n+ 2 MeshBuilder.kt\nde/fabmax/kool/scene/geometry/MeshBuilder\n+ 3 Profile.kt\nde/fabmax/kool/scene/geometry/ProfileKt\n*L\n1#1,40:1\n133#2,2:41\n135#2:47\n22#3,4:43\n*S KotlinDebug\n*F\n+ 1 CapsuleGeometry.kt\nde/fabmax/kool/physics/geometry/CommonCapsuleGeometry\n*L\n14#1:41,2\n14#1:47\n16#1:43,4\n*E\n"})
public abstract class CommonCapsuleGeometry {
    private final float height;
    private final float radius;

    public CommonCapsuleGeometry(float height, float radius) {
        this.height = height;
        this.radius = radius;
    }

    public final float getHeight() {
        return this.height;
    }

    public final float getRadius() {
        return this.radius;
    }

    /*
     * WARNING - void declaration
     */
    public void generateMesh(@NotNull MeshBuilder target) {
        void $this$simpleShape$iv;
        Profile profile$iv;
        MeshBuilder meshBuilder;
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        MeshBuilder $this$generateMesh_u24lambda_u242 = meshBuilder = target;
        boolean bl = false;
        MeshBuilder this_$iv = $this$generateMesh_u24lambda_u242;
        boolean $i$f$profile = false;
        Profile $this$generateMesh_u24lambda_u242_u24lambda_u241 = profile$iv = new Profile();
        boolean bl2 = false;
        float halfHeight = this.height / 2.0f;
        ShapeContainer shapeContainer = (ShapeContainer)$this$generateMesh_u24lambda_u242_u24lambda_u241;
        boolean isClosed$iv = false;
        boolean $i$f$simpleShape = false;
        SimpleShape shape$iv = new SimpleShape(isClosed$iv);
        ((Collection)$this$simpleShape$iv.getShapes()).add(shape$iv);
        SimpleShape $this$generateMesh_u24lambda_u242_u24lambda_u241_u24lambda_u240 = shape$iv;
        boolean bl3 = false;
        $this$generateMesh_u24lambda_u242_u24lambda_u241_u24lambda_u240.xyArc(new Vec2f(halfHeight + this.radius, 0.0f), new Vec2f(halfHeight, 0.0f), 90.0f, 10, true);
        $this$generateMesh_u24lambda_u242_u24lambda_u241_u24lambda_u240.xyArc(new Vec2f(-halfHeight, this.radius), new Vec2f(-halfHeight, 0.0f), 90.0f, 10, true);
        for (int i = 0; i < 21; ++i) {
            MeshBuilder.sample$default((MeshBuilder)$this$generateMesh_u24lambda_u242, (Profile)$this$generateMesh_u24lambda_u242_u24lambda_u241, (boolean)false, (boolean)false, (int)3, null);
            $this$generateMesh_u24lambda_u242.rotate(18.0f, 0.0f, 0.0f);
        }
    }

    @NotNull
    public BoundingBox getBounds(@NotNull BoundingBox result) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        return result.set(-this.radius - this.height / 2.0f, -this.radius, -this.radius, this.radius + this.height / 2.0f, this.radius, this.radius);
    }

    @NotNull
    public MutableVec3f estimateInertiaForMass(float mass, @NotNull MutableVec3f result) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        float h = this.height - this.radius;
        float iy = 0.5f * mass * this.radius * this.radius;
        float ixz = 0.083333336f * mass * ((float)3 * this.radius * this.radius + h * h);
        return result.set(ixz, iy, ixz);
    }
}

