/*
 * Decompiled with CFR 0.152.
 */
package de.fabmax.kool.physics.geometry;

import de.fabmax.kool.math.MutableVec3f;
import de.fabmax.kool.math.Vec3f;
import de.fabmax.kool.math.spatial.BoundingBox;
import de.fabmax.kool.scene.geometry.CubeProps;
import de.fabmax.kool.scene.geometry.MeshBuilder;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\u0011H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0012"}, d2={"Lde/fabmax/kool/physics/geometry/CommonBoxGeometry;", "", "size", "Lde/fabmax/kool/math/Vec3f;", "(Lde/fabmax/kool/math/Vec3f;)V", "getSize", "()Lde/fabmax/kool/math/Vec3f;", "estimateInertiaForMass", "Lde/fabmax/kool/math/MutableVec3f;", "mass", "", "result", "generateMesh", "", "target", "Lde/fabmax/kool/scene/geometry/MeshBuilder;", "getBounds", "Lde/fabmax/kool/math/spatial/BoundingBox;", "kool-physics"})
@SourceDebugExtension(value={"SMAP\nBoxGeometry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BoxGeometry.kt\nde/fabmax/kool/physics/geometry/CommonBoxGeometry\n+ 2 MeshBuilder.kt\nde/fabmax/kool/scene/geometry/MeshBuilder\n+ 3 Log.kt\nde/fabmax/kool/util/LogKt\n+ 4 Log.kt\nde/fabmax/kool/util/Log\n*L\n1#1,30:1\n569#2,6:31\n576#2,3:48\n34#3,7:37\n16#4,4:44\n*S KotlinDebug\n*F\n+ 1 BoxGeometry.kt\nde/fabmax/kool/physics/geometry/CommonBoxGeometry\n*L\n12#1:31,6\n12#1:48,3\n12#1:37,7\n12#1:44,4\n*E\n"})
public abstract class CommonBoxGeometry {
    @NotNull
    private final Vec3f size;

    public CommonBoxGeometry(@NotNull Vec3f size) {
        Intrinsics.checkNotNullParameter((Object)size, (String)"size");
        this.size = size;
    }

    @NotNull
    public final Vec3f getSize() {
        return this.size;
    }

    /*
     * WARNING - void declaration
     */
    public void generateMesh(@NotNull MeshBuilder target) {
        void this_$iv;
        CubeProps props$iv;
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        MeshBuilder meshBuilder = target;
        boolean centered$iv = true;
        boolean $i$f$cube = false;
        CubeProps $this$generateMesh_u24lambda_u240 = props$iv = new CubeProps();
        boolean bl = false;
        $this$generateMesh_u24lambda_u240.getSize().set(this.size);
        this_$iv.centeredCube(props$iv);
    }

    @NotNull
    public BoundingBox getBounds(@NotNull BoundingBox result) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        result.set(-this.size.getX() * 0.5f, -this.size.getY() * 0.5f, -this.size.getZ() * 0.5f, this.size.getX() * 0.5f, this.size.getY() * 0.5f, this.size.getZ() * 0.5f);
        return result;
    }

    @NotNull
    public MutableVec3f estimateInertiaForMass(float mass, @NotNull MutableVec3f result) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        result.setX(mass / 12.0f * (this.size.getY() * this.size.getY() + this.size.getZ() * this.size.getZ()));
        result.setY(mass / 12.0f * (this.size.getX() * this.size.getX() + this.size.getZ() * this.size.getZ()));
        result.setZ(mass / 12.0f * (this.size.getX() * this.size.getX() + this.size.getY() * this.size.getY()));
        return result;
    }
}

