/*
 * Decompiled with CFR 0.152.
 */
package de.fabmax.kool.physics.character;

import de.fabmax.kool.math.Mat4f;
import de.fabmax.kool.math.MutableVec3d;
import de.fabmax.kool.math.Vec3d;
import de.fabmax.kool.math.Vec3f;
import de.fabmax.kool.physics.PhysXExtensionsKt;
import de.fabmax.kool.physics.PhysicsWorld;
import de.fabmax.kool.physics.RigidDynamic;
import de.fabmax.kool.physics.character.CharacterController;
import de.fabmax.kool.physics.character.CharacterControllerManager;
import de.fabmax.kool.physics.character.ControllerBahaviorCallback;
import de.fabmax.kool.physics.character.ControllerHitListener;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import physx.character.PxController;
import physx.character.PxControllerCollisionFlagEnum;
import physx.character.PxControllerCollisionFlags;
import physx.character.PxControllerFilters;
import physx.character.PxExtendedVec3;
import physx.common.PxVec3;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0018\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0014J\b\u0010&\u001a\u00020!H\u0016R\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0017\u001a\u00020\u00188V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lde/fabmax/kool/physics/character/JvmCharacterController;", "Lde/fabmax/kool/physics/character/CharacterController;", "pxController", "Lphysx/character/PxController;", "hitListener", "Lde/fabmax/kool/physics/character/ControllerHitListener;", "behaviorCallback", "Lde/fabmax/kool/physics/character/ControllerBahaviorCallback;", "manager", "Lde/fabmax/kool/physics/character/CharacterControllerManager;", "world", "Lde/fabmax/kool/physics/PhysicsWorld;", "(Lphysx/character/PxController;Lde/fabmax/kool/physics/character/ControllerHitListener;Lde/fabmax/kool/physics/character/ControllerBahaviorCallback;Lde/fabmax/kool/physics/character/CharacterControllerManager;Lde/fabmax/kool/physics/PhysicsWorld;)V", "actor", "Lde/fabmax/kool/physics/RigidDynamic;", "getActor", "()Lde/fabmax/kool/physics/RigidDynamic;", "bufPosition", "Lde/fabmax/kool/math/MutableVec3d;", "bufPxPosition", "Lphysx/character/PxExtendedVec3;", "bufPxVec3", "Lphysx/common/PxVec3;", "value", "Lde/fabmax/kool/math/Vec3d;", "position", "getPosition", "()Lde/fabmax/kool/math/Vec3d;", "setPosition", "(Lde/fabmax/kool/math/Vec3d;)V", "pxControllerFilters", "Lphysx/character/PxControllerFilters;", "move", "", "displacement", "Lde/fabmax/kool/math/Vec3f;", "timeStep", "", "release", "kool-physics"})
public final class JvmCharacterController
extends CharacterController {
    @NotNull
    private final PxController pxController;
    @NotNull
    private final ControllerHitListener hitListener;
    @NotNull
    private final ControllerBahaviorCallback behaviorCallback;
    @NotNull
    private final MutableVec3d bufPosition;
    @NotNull
    private final PxExtendedVec3 bufPxPosition;
    @NotNull
    private final PxVec3 bufPxVec3;
    @NotNull
    private final PxControllerFilters pxControllerFilters;
    @NotNull
    private final RigidDynamic actor;

    public JvmCharacterController(@NotNull PxController pxController, @NotNull ControllerHitListener hitListener, @NotNull ControllerBahaviorCallback behaviorCallback, @NotNull CharacterControllerManager manager, @NotNull PhysicsWorld world) {
        Intrinsics.checkNotNullParameter((Object)pxController, (String)"pxController");
        Intrinsics.checkNotNullParameter((Object)((Object)hitListener), (String)"hitListener");
        Intrinsics.checkNotNullParameter((Object)((Object)behaviorCallback), (String)"behaviorCallback");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        super(manager, world);
        this.pxController = pxController;
        this.hitListener = hitListener;
        this.behaviorCallback = behaviorCallback;
        this.bufPosition = new MutableVec3d();
        this.bufPxPosition = new PxExtendedVec3();
        this.bufPxVec3 = new PxVec3();
        this.pxControllerFilters = new PxControllerFilters();
        this.hitListener.setController(this);
        this.behaviorCallback.setController(this);
        this.actor = new RigidDynamic(1.0f, new Mat4f(), false, this.pxController.getActor());
    }

    @Override
    @NotNull
    public Vec3d getPosition() {
        PxExtendedVec3 pxExtendedVec3 = this.pxController.getPosition();
        Intrinsics.checkNotNullExpressionValue((Object)pxExtendedVec3, (String)"pxController.position");
        return (Vec3d)PhysXExtensionsKt.toVec3d(pxExtendedVec3, this.bufPosition);
    }

    @Override
    public void setPosition(@NotNull Vec3d value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.pxController.setPosition(PhysXExtensionsKt.toPxExtendedVec3(value, this.bufPxPosition));
        this.getPrevPosition().set(value);
    }

    @Override
    @NotNull
    public RigidDynamic getActor() {
        return this.actor;
    }

    @Override
    protected void move(@NotNull Vec3f displacement, float timeStep) {
        Intrinsics.checkNotNullParameter((Object)displacement, (String)"displacement");
        PxControllerCollisionFlags flags = this.pxController.move(PhysXExtensionsKt.toPxVec3(displacement, this.bufPxVec3), 0.001f, timeStep, this.pxControllerFilters);
        this.setDownCollision(flags.isSet(PxControllerCollisionFlagEnum.eCOLLISION_DOWN));
        this.setUpCollision(flags.isSet(PxControllerCollisionFlagEnum.eCOLLISION_UP));
        this.setSideCollision(flags.isSet(PxControllerCollisionFlagEnum.eCOLLISION_SIDES));
    }

    @Override
    public void release() {
        super.release();
        this.pxController.release();
        this.bufPxPosition.destroy();
        this.bufPxVec3.destroy();
        this.pxControllerFilters.destroy();
        this.hitListener.destroy();
        this.behaviorCallback.destroy();
    }
}

