/*
 * Decompiled with CFR 0.152.
 */
package de.fabmax.kool.physics.character;

import de.fabmax.kool.physics.Physics;
import de.fabmax.kool.physics.PhysicsWorld;
import de.fabmax.kool.physics.character.CommonCharacterControllerManager;
import de.fabmax.kool.physics.character.ControllerBahaviorCallback;
import de.fabmax.kool.physics.character.ControllerHitListener;
import de.fabmax.kool.physics.character.JvmCharacterController;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import physx.PxTopLevelFunctions;
import physx.character.PxCapsuleClimbingModeEnum;
import physx.character.PxCapsuleControllerDesc;
import physx.character.PxController;
import physx.character.PxControllerBehaviorCallback;
import physx.character.PxControllerDesc;
import physx.character.PxControllerManager;
import physx.character.PxControllerNonWalkableModeEnum;
import physx.character.PxUserControllerHitReport;
import physx.physics.PxScene;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0014J\b\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lde/fabmax/kool/physics/character/CharacterControllerManager;", "Lde/fabmax/kool/physics/character/CommonCharacterControllerManager;", "world", "Lde/fabmax/kool/physics/PhysicsWorld;", "(Lde/fabmax/kool/physics/PhysicsWorld;)V", "pxManager", "Lphysx/character/PxControllerManager;", "doCreateController", "Lde/fabmax/kool/physics/character/JvmCharacterController;", "release", "", "kool-physics"})
@SourceDebugExtension(value={"SMAP\nCharacterControllerManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CharacterControllerManager.kt\nde/fabmax/kool/physics/character/CharacterControllerManager\n+ 2 Math.kt\nde/fabmax/kool/math/MathKt\n*L\n1#1,45:1\n24#2:46\n*S KotlinDebug\n*F\n+ 1 CharacterControllerManager.kt\nde/fabmax/kool/physics/character/CharacterControllerManager\n*L\n31#1:46\n*E\n"})
public final class CharacterControllerManager
extends CommonCharacterControllerManager {
    @NotNull
    private final PxControllerManager pxManager;

    public CharacterControllerManager(@NotNull PhysicsWorld world) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        super(world);
        Physics.INSTANCE.checkIsLoaded();
        PxControllerManager pxControllerManager = PxTopLevelFunctions.CreateControllerManager((PxScene)world.getPxScene());
        Intrinsics.checkNotNullExpressionValue((Object)pxControllerManager, (String)"CreateControllerManager(world.pxScene)");
        this.pxManager = pxControllerManager;
    }

    @Override
    @NotNull
    protected JvmCharacterController doCreateController() {
        ControllerHitListener hitCallback = new ControllerHitListener(this.getWorld());
        ControllerBahaviorCallback behaviorCallback = new ControllerBahaviorCallback(this.getWorld());
        PxCapsuleControllerDesc desc = new PxCapsuleControllerDesc();
        desc.setHeight(1.0f);
        desc.setRadius(0.3f);
        desc.setClimbingMode(PxCapsuleClimbingModeEnum.eEASY);
        desc.setNonWalkableMode(PxControllerNonWalkableModeEnum.ePREVENT_CLIMBING);
        float $this$toRad$iv = 50.0f;
        boolean $i$f$toRad = false;
        desc.setSlopeLimit((float)Math.cos($this$toRad$iv * ((float)Math.PI / 180)));
        desc.setMaterial(Physics.INSTANCE.getDefaultMaterial().getPxMaterial());
        desc.setContactOffset(0.1f);
        desc.setReportCallback((PxUserControllerHitReport)hitCallback);
        desc.setBehaviorCallback((PxControllerBehaviorCallback)behaviorCallback);
        PxController pxCharacter = this.pxManager.createController((PxControllerDesc)desc);
        desc.destroy();
        Intrinsics.checkNotNullExpressionValue((Object)pxCharacter, (String)"pxCharacter");
        return new JvmCharacterController(pxCharacter, hitCallback, behaviorCallback, this, this.getWorld());
    }

    @Override
    public void release() {
        super.release();
        this.pxManager.release();
    }
}

