/*
 * Decompiled with CFR 0.152.
 */
package de.fabmax.kool.physics.character;

import de.fabmax.kool.KoolContext;
import de.fabmax.kool.math.MutableVec3d;
import de.fabmax.kool.math.MutableVec3f;
import de.fabmax.kool.math.Vec3d;
import de.fabmax.kool.math.Vec3f;
import de.fabmax.kool.physics.PhysicsWorld;
import de.fabmax.kool.physics.Releasable;
import de.fabmax.kool.physics.RigidActor;
import de.fabmax.kool.physics.RigidDynamic;
import de.fabmax.kool.physics.character.CharacterControllerManager;
import de.fabmax.kool.physics.character.HitActorBehaviorCallback;
import de.fabmax.kool.physics.character.OnHitActorListener;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\u0007\n\u0002\b\r\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010K\u001a\u0002092\u0006\u0010\u000b\u001a\u00020H2\u0006\u0010L\u001a\u00020%H$J\u0010\u0010M\u001a\u0002092\u0006\u0010L\u001a\u00020%H\u0016J%\u0010N\u001a\u0002092\u0006\u0010\u0007\u001a\u00020O2\u0006\u0010P\u001a\u00020H2\u0006\u0010Q\u001a\u00020HH\u0000\u00a2\u0006\u0002\bRJ\u0010\u00107\u001a\u0002092\u0006\u0010L\u001a\u00020%H\u0016J\b\u0010S\u001a\u000209H\u0016R\u0012\u0010\u0007\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R$\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0017\u001a\u00020\u0018@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR$\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u0017\u001a\u00020\u0018@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001a\"\u0004\b\u001e\u0010\u001cR$\u0010\u001f\u001a\u00020\u00182\u0006\u0010\u0017\u001a\u00020\u0018@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u001a\"\u0004\b \u0010\u001cR\u001a\u0010!\u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u001a\"\u0004\b#\u0010\u001cR\u001a\u0010$\u001a\u00020%X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u000e\u0010*\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010,\u001a\u00020%X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010'\"\u0004\b.\u0010)R\u0011\u0010/\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u0010\u000fR\u000e\u00101\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u00102\u001a\b\u0012\u0004\u0012\u00020403\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u00106R#\u00107\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u0002090803\u00a2\u0006\b\n\u0000\u001a\u0004\b:\u00106R\u000e\u0010;\u001a\u00020<X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010=\u001a\u00020>X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b?\u0010@\"\u0004\bA\u0010BR\u0014\u0010C\u001a\u00020<X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bD\u0010ER\u000e\u0010F\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010G\u001a\u00020H8F\u00a2\u0006\u0006\u001a\u0004\bI\u0010J\u00a8\u0006T"}, d2={"Lde/fabmax/kool/physics/character/CharacterController;", "Lde/fabmax/kool/physics/Releasable;", "manager", "Lde/fabmax/kool/physics/character/CharacterControllerManager;", "world", "Lde/fabmax/kool/physics/PhysicsWorld;", "(Lde/fabmax/kool/physics/character/CharacterControllerManager;Lde/fabmax/kool/physics/PhysicsWorld;)V", "actor", "Lde/fabmax/kool/physics/RigidDynamic;", "getActor", "()Lde/fabmax/kool/physics/RigidDynamic;", "displacement", "Lde/fabmax/kool/math/MutableVec3f;", "gravity", "getGravity", "()Lde/fabmax/kool/math/MutableVec3f;", "gravityVelocity", "hitActorBehaviorCallback", "Lde/fabmax/kool/physics/character/HitActorBehaviorCallback;", "getHitActorBehaviorCallback", "()Lde/fabmax/kool/physics/character/HitActorBehaviorCallback;", "setHitActorBehaviorCallback", "(Lde/fabmax/kool/physics/character/HitActorBehaviorCallback;)V", "<set-?>", "", "isDownCollision", "()Z", "setDownCollision", "(Z)V", "isSideCollision", "setSideCollision", "isUpCollision", "setUpCollision", "jump", "getJump", "setJump", "jumpSpeed", "", "getJumpSpeed", "()F", "setJumpSpeed", "(F)V", "jumpVelocity", "lastGroundTuch", "maxFallSpeed", "getMaxFallSpeed", "setMaxFallSpeed", "movement", "getMovement", "mutVelocity", "onHitActorListeners", "", "Lde/fabmax/kool/physics/character/OnHitActorListener;", "getOnHitActorListeners", "()Ljava/util/List;", "onPhysicsUpdate", "Lkotlin/Function1;", "", "getOnPhysicsUpdate", "posBuffer", "Lde/fabmax/kool/math/MutableVec3d;", "position", "Lde/fabmax/kool/math/Vec3d;", "getPosition", "()Lde/fabmax/kool/math/Vec3d;", "setPosition", "(Lde/fabmax/kool/math/Vec3d;)V", "prevPosition", "getPrevPosition", "()Lde/fabmax/kool/math/MutableVec3d;", "tmpVec", "velocity", "Lde/fabmax/kool/math/Vec3f;", "getVelocity", "()Lde/fabmax/kool/math/Vec3f;", "move", "timeStep", "onAdvancePhysics", "onHitActor", "Lde/fabmax/kool/physics/RigidActor;", "hitWorldPos", "hitWorldNormal", "onHitActor$kool_physics", "release", "kool-physics"})
public abstract class CharacterController
implements Releasable {
    @NotNull
    private final CharacterControllerManager manager;
    @NotNull
    private final MutableVec3d prevPosition;
    @NotNull
    private final MutableVec3d posBuffer;
    @NotNull
    private final MutableVec3f tmpVec;
    @NotNull
    private final MutableVec3f gravityVelocity;
    @NotNull
    private final MutableVec3f jumpVelocity;
    @NotNull
    private final MutableVec3f displacement;
    @NotNull
    private final MutableVec3f mutVelocity;
    @NotNull
    private final MutableVec3f gravity;
    @NotNull
    private final MutableVec3f movement;
    private float maxFallSpeed;
    private float jumpSpeed;
    private boolean jump;
    private boolean isDownCollision;
    private boolean isUpCollision;
    private boolean isSideCollision;
    private float lastGroundTuch;
    @NotNull
    private final List<Function1<Float, Unit>> onPhysicsUpdate;
    @NotNull
    private final List<OnHitActorListener> onHitActorListeners;
    @Nullable
    private HitActorBehaviorCallback hitActorBehaviorCallback;

    public CharacterController(@NotNull CharacterControllerManager manager, @NotNull PhysicsWorld world) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        this.manager = manager;
        this.prevPosition = new MutableVec3d();
        this.posBuffer = new MutableVec3d();
        this.tmpVec = new MutableVec3f();
        this.gravityVelocity = new MutableVec3f();
        this.jumpVelocity = new MutableVec3f();
        this.displacement = new MutableVec3f();
        this.mutVelocity = new MutableVec3f();
        this.gravity = new MutableVec3f(world.getGravity());
        this.movement = new MutableVec3f();
        this.maxFallSpeed = 30.0f;
        this.jumpSpeed = 6.0f;
        this.onPhysicsUpdate = new ArrayList();
        this.onHitActorListeners = new ArrayList();
    }

    @NotNull
    public abstract RigidDynamic getActor();

    @NotNull
    public abstract Vec3d getPosition();

    public abstract void setPosition(@NotNull Vec3d var1);

    @NotNull
    protected final MutableVec3d getPrevPosition() {
        return this.prevPosition;
    }

    @NotNull
    public final MutableVec3f getGravity() {
        return this.gravity;
    }

    @NotNull
    public final MutableVec3f getMovement() {
        return this.movement;
    }

    @NotNull
    public final Vec3f getVelocity() {
        return (Vec3f)this.mutVelocity;
    }

    public final float getMaxFallSpeed() {
        return this.maxFallSpeed;
    }

    public final void setMaxFallSpeed(float f) {
        this.maxFallSpeed = f;
    }

    public final float getJumpSpeed() {
        return this.jumpSpeed;
    }

    public final void setJumpSpeed(float f) {
        this.jumpSpeed = f;
    }

    public final boolean getJump() {
        return this.jump;
    }

    public final void setJump(boolean bl) {
        this.jump = bl;
    }

    public final boolean isDownCollision() {
        return this.isDownCollision;
    }

    protected final void setDownCollision(boolean bl) {
        this.isDownCollision = bl;
    }

    public final boolean isUpCollision() {
        return this.isUpCollision;
    }

    protected final void setUpCollision(boolean bl) {
        this.isUpCollision = bl;
    }

    public final boolean isSideCollision() {
        return this.isSideCollision;
    }

    protected final void setSideCollision(boolean bl) {
        this.isSideCollision = bl;
    }

    @NotNull
    public final List<Function1<Float, Unit>> getOnPhysicsUpdate() {
        return this.onPhysicsUpdate;
    }

    @NotNull
    public final List<OnHitActorListener> getOnHitActorListeners() {
        return this.onHitActorListeners;
    }

    @Nullable
    public final HitActorBehaviorCallback getHitActorBehaviorCallback() {
        return this.hitActorBehaviorCallback;
    }

    public final void setHitActorBehaviorCallback(@Nullable HitActorBehaviorCallback hitActorBehaviorCallback) {
        this.hitActorBehaviorCallback = hitActorBehaviorCallback;
    }

    public void onAdvancePhysics(float timeStep) {
        if (!this.isDownCollision) {
            this.lastGroundTuch += timeStep;
            this.gravityVelocity.add((Vec3f)this.tmpVec.set((Vec3f)this.gravity).scale(timeStep));
        } else {
            this.lastGroundTuch = 0.0f;
            this.gravityVelocity.set(Vec3f.Companion.getZERO());
        }
        float fallSpeed = this.tmpVec.set((Vec3f)this.gravity).norm().times((Vec3f)this.gravityVelocity);
        if (this.jump && this.lastGroundTuch < 0.25f && fallSpeed >= 0.0f) {
            this.gravityVelocity.add((Vec3f)this.tmpVec.set((Vec3f)this.gravity).norm().scale(-this.jumpSpeed));
        }
        this.displacement.set((Vec3f)this.movement).scale(timeStep).add((Vec3f)this.tmpVec.set((Vec3f)this.gravityVelocity).scale(timeStep));
        this.move((Vec3f)this.displacement, timeStep);
    }

    public void onPhysicsUpdate(float timeStep) {
        this.posBuffer.set(this.getPosition());
        this.mutVelocity.set((float)(this.posBuffer.getX() - this.prevPosition.getX()), (float)(this.posBuffer.getY() - this.prevPosition.getY()), (float)(this.posBuffer.getZ() - this.prevPosition.getZ())).scale(1.0f / timeStep);
        this.prevPosition.set((Vec3d)this.posBuffer);
        this.getActor().onPhysicsUpdate$kool_physics(timeStep);
        int n = this.onPhysicsUpdate.size();
        for (int i = 0; i < n; ++i) {
            this.onPhysicsUpdate.get(i).invoke((Object)Float.valueOf(timeStep));
        }
    }

    public final void onHitActor$kool_physics(@NotNull RigidActor actor, @NotNull Vec3f hitWorldPos, @NotNull Vec3f hitWorldNormal) {
        Intrinsics.checkNotNullParameter((Object)actor, (String)"actor");
        Intrinsics.checkNotNullParameter((Object)hitWorldPos, (String)"hitWorldPos");
        Intrinsics.checkNotNullParameter((Object)hitWorldNormal, (String)"hitWorldNormal");
        int n = this.onHitActorListeners.size();
        for (int i = 0; i < n; ++i) {
            this.onHitActorListeners.get(i).onHitActor(actor, hitWorldPos, hitWorldNormal);
        }
    }

    protected abstract void move(@NotNull Vec3f var1, float var2);

    @Override
    public void release() {
        this.manager.removeController(this);
    }

    @Override
    public void dispose(@NotNull KoolContext ctx) {
        Releasable.DefaultImpls.dispose(this, ctx);
    }
}

