/*
 * Decompiled with CFR 0.152.
 */
package de.fabmax.kool.physics.articulations;

import de.fabmax.kool.math.Mat4f;
import de.fabmax.kool.physics.PhysXExtensionsKt;
import de.fabmax.kool.physics.articulations.ArticulationDriveType;
import de.fabmax.kool.physics.articulations.ArticulationJointAxis;
import de.fabmax.kool.physics.articulations.ArticulationJointType;
import de.fabmax.kool.physics.articulations.ArticulationMotionMode;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.system.MemoryStack;
import physx.common.PxTransform;
import physx.physics.PxArticulationDrive;
import physx.physics.PxArticulationJointReducedCoordinate;
import physx.physics.PxArticulationJointTypeEnum;
import physx.physics.PxArticulationLimit;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0015\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013J\u0016\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u001aJ.\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020\u00132\u0006\u0010 \u001a\u00020\u0013J\u0016\u0010!\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\"\u001a\u00020\u0013J\u0016\u0010#\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010$\u001a\u00020\u0013J\u000e\u0010%\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u001aJ&\u0010&\u001a\u00020\u000f2\u0006\u0010'\u001a\u00020\u00132\u0006\u0010(\u001a\u00020\u00132\u0006\u0010)\u001a\u00020\u00132\u0006\u0010*\u001a\u00020\u0013J6\u0010&\u001a\u00020\u000f2\u0006\u0010'\u001a\u00020\u00132\u0006\u0010(\u001a\u00020\u00132\u0006\u0010+\u001a\u00020\u00132\u0006\u0010,\u001a\u00020\u00132\u0006\u0010-\u001a\u00020\u00132\u0006\u0010.\u001a\u00020\u0013J\u0016\u0010/\u001a\u00020\u000f2\u0006\u00100\u001a\u00020\u00132\u0006\u00101\u001a\u00020\u0013R$\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00068F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u00062"}, d2={"Lde/fabmax/kool/physics/articulations/ArticulationJoint;", "", "pxJoint", "Lphysx/physics/PxArticulationJointReducedCoordinate;", "(Lphysx/physics/PxArticulationJointReducedCoordinate;)V", "value", "Lde/fabmax/kool/physics/articulations/ArticulationJointType;", "jointType", "getJointType", "()Lde/fabmax/kool/physics/articulations/ArticulationJointType;", "setJointType", "(Lde/fabmax/kool/physics/articulations/ArticulationJointType;)V", "getPxJoint", "()Lphysx/physics/PxArticulationJointReducedCoordinate;", "setAxisLimits", "", "axis", "Lde/fabmax/kool/physics/articulations/ArticulationJointAxis;", "low", "", "high", "setAxisMotion", "motionType", "Lde/fabmax/kool/physics/articulations/ArticulationMotionMode;", "setChildPose", "pose", "Lde/fabmax/kool/math/Mat4f;", "setDriveParams", "driveType", "Lde/fabmax/kool/physics/articulations/ArticulationDriveType;", "damping", "stiffness", "maxForce", "setDriveTarget", "target", "setJointPosition", "jointPos", "setParentPose", "setupSpherical", "twistMinDeg", "twistMaxDeg", "swingMinDeg", "swingMaxDeg", "swing1MinDeg", "swing1MaxDeg", "swing2MinDeg", "swing2MaxDeg", "setupSphericalSymmetrical", "twistLimitDeg", "swingLimitDeg", "kool-physics"})
@SourceDebugExtension(value={"SMAP\nArticulationJoint.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ArticulationJoint.kt\nde/fabmax/kool/physics/articulations/ArticulationJoint\n+ 2 Math.kt\nde/fabmax/kool/math/MathKt\n*L\n1#1,171:1\n24#2:172\n24#2:173\n24#2:174\n24#2:175\n24#2:176\n*S KotlinDebug\n*F\n+ 1 ArticulationJoint.kt\nde/fabmax/kool/physics/articulations/ArticulationJoint\n*L\n106#1:172\n118#1:173\n139#1:174\n143#1:175\n144#1:176\n*E\n"})
public final class ArticulationJoint {
    @NotNull
    private final PxArticulationJointReducedCoordinate pxJoint;

    public ArticulationJoint(@NotNull PxArticulationJointReducedCoordinate pxJoint) {
        Intrinsics.checkNotNullParameter((Object)pxJoint, (String)"pxJoint");
        this.pxJoint = pxJoint;
        this.pxJoint.setJointType(PxArticulationJointTypeEnum.eFIX);
    }

    @NotNull
    public final PxArticulationJointReducedCoordinate getPxJoint() {
        return this.pxJoint;
    }

    @NotNull
    public final ArticulationJointType getJointType() {
        PxArticulationJointTypeEnum pxArticulationJointTypeEnum = this.pxJoint.getJointType();
        Intrinsics.checkNotNullExpressionValue((Object)pxArticulationJointTypeEnum, (String)"pxJoint.jointType");
        return ArticulationJointType.Companion.fromPx(pxArticulationJointTypeEnum);
    }

    public final void setJointType(@NotNull ArticulationJointType value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        this.pxJoint.setJointType(value.getPxVal());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setParentPose(@NotNull Mat4f pose) {
        Intrinsics.checkNotNullParameter((Object)pose, (String)"pose");
        AutoCloseable autoCloseable = (AutoCloseable)MemoryStack.stackPush();
        Throwable throwable = null;
        try {
            MemoryStack mem = (MemoryStack)autoCloseable;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)mem, (String)"mem");
            PxTransform pxTransform = PhysXExtensionsKt.createPxTransform(mem);
            Intrinsics.checkNotNullExpressionValue((Object)pxTransform, (String)"mem.createPxTransform()");
            this.pxJoint.setParentPose(PhysXExtensionsKt.toPxTransform(pose, pxTransform));
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setChildPose(@NotNull Mat4f pose) {
        Intrinsics.checkNotNullParameter((Object)pose, (String)"pose");
        AutoCloseable autoCloseable = (AutoCloseable)MemoryStack.stackPush();
        Throwable throwable = null;
        try {
            MemoryStack mem = (MemoryStack)autoCloseable;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)mem, (String)"mem");
            PxTransform pxTransform = PhysXExtensionsKt.createPxTransform(mem);
            Intrinsics.checkNotNullExpressionValue((Object)pxTransform, (String)"mem.createPxTransform()");
            this.pxJoint.setChildPose(PhysXExtensionsKt.toPxTransform(pose, pxTransform));
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    public final void setAxisMotion(@NotNull ArticulationJointAxis axis, @NotNull ArticulationMotionMode motionType) {
        Intrinsics.checkNotNullParameter((Object)((Object)axis), (String)"axis");
        Intrinsics.checkNotNullParameter((Object)((Object)motionType), (String)"motionType");
        this.pxJoint.setMotion(axis.getPxVal(), motionType.getPxVal());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setAxisLimits(@NotNull ArticulationJointAxis axis, float low, float high) {
        Intrinsics.checkNotNullParameter((Object)((Object)axis), (String)"axis");
        AutoCloseable autoCloseable = (AutoCloseable)MemoryStack.stackPush();
        Throwable throwable = null;
        try {
            MemoryStack mem = (MemoryStack)autoCloseable;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)mem, (String)"mem");
            PxArticulationLimit limit = PhysXExtensionsKt.createPxArticulationLimit(mem, low, high);
            this.pxJoint.setLimitParams(axis.getPxVal(), limit);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    public final void setupSphericalSymmetrical(float twistLimitDeg, float swingLimitDeg) {
        float limit;
        boolean $i$f$toRad;
        float $this$toRad$iv;
        this.setJointType(ArticulationJointType.SPHERICAL);
        if (twistLimitDeg > 0.0f) {
            if (twistLimitDeg < 360.0f) {
                this.setAxisMotion(ArticulationJointAxis.ROT_TWIST, ArticulationMotionMode.LIMITED);
                $this$toRad$iv = twistLimitDeg;
                $i$f$toRad = false;
                limit = $this$toRad$iv * ((float)Math.PI / 180);
                this.setAxisLimits(ArticulationJointAxis.ROT_TWIST, -limit, limit);
            } else {
                this.setAxisMotion(ArticulationJointAxis.ROT_TWIST, ArticulationMotionMode.FREE);
            }
        } else {
            this.setAxisMotion(ArticulationJointAxis.ROT_TWIST, ArticulationMotionMode.LOCKED);
        }
        if (swingLimitDeg > 0.0f) {
            if (swingLimitDeg < 360.0f) {
                this.setAxisMotion(ArticulationJointAxis.ROT_SWING1, ArticulationMotionMode.LIMITED);
                this.setAxisMotion(ArticulationJointAxis.ROT_SWING2, ArticulationMotionMode.LIMITED);
                $this$toRad$iv = swingLimitDeg;
                $i$f$toRad = false;
                limit = $this$toRad$iv * ((float)Math.PI / 180);
                this.setAxisLimits(ArticulationJointAxis.ROT_SWING1, -limit, limit);
                this.setAxisLimits(ArticulationJointAxis.ROT_SWING2, -limit, limit);
            } else {
                this.setAxisMotion(ArticulationJointAxis.ROT_SWING1, ArticulationMotionMode.FREE);
                this.setAxisMotion(ArticulationJointAxis.ROT_SWING2, ArticulationMotionMode.FREE);
            }
        }
    }

    public final void setupSpherical(float twistMinDeg, float twistMaxDeg, float swingMinDeg, float swingMaxDeg) {
        this.setupSpherical(twistMinDeg, twistMaxDeg, swingMinDeg, swingMaxDeg, swingMinDeg, swingMaxDeg);
    }

    public final void setupSpherical(float twistMinDeg, float twistMaxDeg, float swing1MinDeg, float swing1MaxDeg, float swing2MinDeg, float swing2MaxDeg) {
        this.setJointType(ArticulationJointType.SPHERICAL);
        this.setAxisMotion(ArticulationJointAxis.ROT_TWIST, ArticulationMotionMode.LIMITED);
        float $this$toRad$iv = twistMinDeg;
        boolean $i$f$toRad = false;
        float f = $this$toRad$iv * ((float)Math.PI / 180);
        $this$toRad$iv = twistMaxDeg;
        $i$f$toRad = false;
        this.setAxisLimits(ArticulationJointAxis.ROT_TWIST, f, $this$toRad$iv * ((float)Math.PI / 180));
        this.setAxisMotion(ArticulationJointAxis.ROT_SWING1, ArticulationMotionMode.LIMITED);
        this.setAxisMotion(ArticulationJointAxis.ROT_SWING2, ArticulationMotionMode.LIMITED);
        $this$toRad$iv = swing1MinDeg;
        $i$f$toRad = false;
        float f2 = $this$toRad$iv * ((float)Math.PI / 180);
        $this$toRad$iv = swing1MaxDeg;
        $i$f$toRad = false;
        this.setAxisLimits(ArticulationJointAxis.ROT_SWING1, f2, $this$toRad$iv * ((float)Math.PI / 180));
        $this$toRad$iv = swing2MinDeg;
        $i$f$toRad = false;
        float f3 = $this$toRad$iv * ((float)Math.PI / 180);
        $this$toRad$iv = swing2MaxDeg;
        $i$f$toRad = false;
        this.setAxisLimits(ArticulationJointAxis.ROT_SWING2, f3, $this$toRad$iv * ((float)Math.PI / 180));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setDriveParams(@NotNull ArticulationJointAxis axis, @NotNull ArticulationDriveType driveType, float damping, float stiffness, float maxForce) {
        Intrinsics.checkNotNullParameter((Object)((Object)axis), (String)"axis");
        Intrinsics.checkNotNullParameter((Object)((Object)driveType), (String)"driveType");
        AutoCloseable autoCloseable = (AutoCloseable)MemoryStack.stackPush();
        Throwable throwable = null;
        try {
            MemoryStack mem = (MemoryStack)autoCloseable;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)mem, (String)"mem");
            PxArticulationDrive drive = PhysXExtensionsKt.createPxArticulationDrive(mem);
            drive.setDriveType(driveType.getPxVal());
            drive.setStiffness(stiffness);
            drive.setDamping(damping);
            drive.setMaxForce(maxForce);
            this.pxJoint.setDriveParams(axis.getPxVal(), drive);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    public final void setDriveTarget(@NotNull ArticulationJointAxis axis, float target) {
        Intrinsics.checkNotNullParameter((Object)((Object)axis), (String)"axis");
        this.pxJoint.setDriveTarget(axis.getPxVal(), target);
    }

    public final void setJointPosition(@NotNull ArticulationJointAxis axis, float jointPos) {
        Intrinsics.checkNotNullParameter((Object)((Object)axis), (String)"axis");
        this.pxJoint.setJointPosition(axis.getPxVal(), jointPos);
    }
}

