/*
 * Decompiled with CFR 0.152.
 */
package de.fabmax.kool.physics.articulations;

import de.fabmax.kool.math.Mat4f;
import de.fabmax.kool.physics.PhysXExtensionsKt;
import de.fabmax.kool.physics.Physics;
import de.fabmax.kool.physics.articulations.ArticulationLink;
import de.fabmax.kool.physics.articulations.CommonArticulation;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.system.MemoryStack;
import physx.common.PxTransform;
import physx.physics.PxArticulationFlagEnum;
import physx.physics.PxArticulationLink;
import physx.physics.PxArticulationReducedCoordinate;
import physx.support.SupportFunctions;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010\u0018\u001a\u00020\u0019J\b\u0010\u001a\u001a\u00020\u0019H\u0016J\u0006\u0010\u001b\u001a\u00020\u0019R$\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00068F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR$\u0010\f\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00068F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\r\u0010\t\"\u0004\b\u000e\u0010\u000bR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001c"}, d2={"Lde/fabmax/kool/physics/articulations/Articulation;", "Lde/fabmax/kool/physics/articulations/CommonArticulation;", "isFixedBase", "", "(Z)V", "value", "", "minPositionIterations", "getMinPositionIterations", "()I", "setMinPositionIterations", "(I)V", "minVelocityIterations", "getMinVelocityIterations", "setMinVelocityIterations", "pxArticulation", "Lphysx/physics/PxArticulationReducedCoordinate;", "getPxArticulation", "()Lphysx/physics/PxArticulationReducedCoordinate;", "createLink", "Lde/fabmax/kool/physics/articulations/ArticulationLink;", "parent", "pose", "Lde/fabmax/kool/math/Mat4f;", "putToSleep", "", "release", "wakeUp", "kool-physics"})
public final class Articulation
extends CommonArticulation {
    @NotNull
    private final PxArticulationReducedCoordinate pxArticulation;

    public Articulation(boolean isFixedBase) {
        super(isFixedBase);
        Physics.INSTANCE.checkIsLoaded();
        PxArticulationReducedCoordinate pxArticulationReducedCoordinate = Physics.INSTANCE.getPhysics().createArticulationReducedCoordinate();
        Intrinsics.checkNotNullExpressionValue((Object)pxArticulationReducedCoordinate, (String)"Physics.physics.createAr\u2026lationReducedCoordinate()");
        this.pxArticulation = pxArticulationReducedCoordinate;
        if (isFixedBase) {
            this.pxArticulation.setArticulationFlag(PxArticulationFlagEnum.eFIX_BASE, true);
        }
    }

    @NotNull
    public final PxArticulationReducedCoordinate getPxArticulation() {
        return this.pxArticulation;
    }

    public final int getMinPositionIterations() {
        return SupportFunctions.PxArticulationReducedCoordinate_getMinSolverPositionIterations((PxArticulationReducedCoordinate)this.pxArticulation);
    }

    public final void setMinPositionIterations(int value) {
        this.pxArticulation.setSolverIterationCounts(value, this.getMinVelocityIterations());
    }

    public final int getMinVelocityIterations() {
        return SupportFunctions.PxArticulationReducedCoordinate_getMinSolverVelocityIterations((PxArticulationReducedCoordinate)this.pxArticulation);
    }

    public final void setMinVelocityIterations(int value) {
        this.pxArticulation.setSolverIterationCounts(this.getMinPositionIterations(), value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final ArticulationLink createLink(@Nullable ArticulationLink parent, @NotNull Mat4f pose) {
        ArticulationLink articulationLink;
        Intrinsics.checkNotNullParameter((Object)pose, (String)"pose");
        AutoCloseable autoCloseable = (AutoCloseable)MemoryStack.stackPush();
        Throwable throwable = null;
        try {
            MemoryStack mem = (MemoryStack)autoCloseable;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)mem, (String)"mem");
            PxTransform pxTransform = PhysXExtensionsKt.createPxTransform(mem);
            Intrinsics.checkNotNullExpressionValue((Object)pxTransform, (String)"mem.createPxTransform()");
            PxTransform pxPose = PhysXExtensionsKt.toPxTransform(pose, pxTransform);
            ArticulationLink articulationLink2 = parent;
            PxArticulationLink pxLink = this.pxArticulation.createLink((PxArticulationLink)(articulationLink2 != null ? articulationLink2.getPxLink() : null), pxPose);
            Intrinsics.checkNotNullExpressionValue((Object)pxLink, (String)"pxLink");
            ArticulationLink link = new ArticulationLink(pxLink, parent);
            ((Collection)this.getMutLinks()).add(link);
            articulationLink = link;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return articulationLink;
    }

    public final void wakeUp() {
        this.pxArticulation.wakeUp();
    }

    public final void putToSleep() {
        this.pxArticulation.putToSleep();
    }

    @Override
    public void release() {
        this.pxArticulation.release();
    }
}

