/*
 * Decompiled with CFR 0.152.
 */
package de.fabmax.kool.physics;

import de.fabmax.kool.math.Mat4f;
import de.fabmax.kool.math.Vec3f;
import de.fabmax.kool.math.Vec4f;
import de.fabmax.kool.physics.PhysXExtensionsKt;
import de.fabmax.kool.physics.Physics;
import de.fabmax.kool.physics.RigidBody;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.system.MemoryStack;
import physx.common.PxQuat;
import physx.common.PxTransform;
import physx.common.PxVec3;
import physx.physics.PxRigidActor;
import physx.physics.PxRigidBodyFlagEnum;
import physx.physics.PxRigidDynamic;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B%\b\u0016\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB)\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0004\u001a\u00020\u0005J\u001e\u0010\u0015\u001a\u00020\u00142\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u00172\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u0019J\u0006\u0010\u001a\u001a\u00020\u0014R\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001b"}, d2={"Lde/fabmax/kool/physics/RigidDynamic;", "Lde/fabmax/kool/physics/RigidBody;", "mass", "", "pose", "Lde/fabmax/kool/math/Mat4f;", "isKinematic", "", "(FLde/fabmax/kool/math/Mat4f;Z)V", "pxActor", "Lphysx/physics/PxRigidDynamic;", "(FLde/fabmax/kool/math/Mat4f;ZLphysx/physics/PxRigidDynamic;)V", "pxRigidActor", "Lphysx/physics/PxRigidActor;", "getPxRigidActor", "()Lphysx/physics/PxRigidActor;", "pxRigidDynamic", "getPxRigidDynamic", "()Lphysx/physics/PxRigidDynamic;", "putToSleep", "", "setKinematicTarget", "position", "Lde/fabmax/kool/math/Vec3f;", "rotation", "Lde/fabmax/kool/math/Vec4f;", "wakeUp", "kool-physics"})
public final class RigidDynamic
extends RigidBody {
    @NotNull
    private final PxRigidActor pxRigidActor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RigidDynamic(float mass, @NotNull Mat4f pose, boolean isKinematic, @Nullable PxRigidDynamic pxActor) {
        Intrinsics.checkNotNullParameter((Object)pose, (String)"pose");
        if (pxActor == null) {
            AutoCloseable autoCloseable = (AutoCloseable)MemoryStack.stackPush();
            Throwable throwable = null;
            try {
                MemoryStack mem = (MemoryStack)autoCloseable;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)mem, (String)"mem");
                PxTransform pxTransform = PhysXExtensionsKt.createPxTransform(mem);
                Intrinsics.checkNotNullExpressionValue((Object)pxTransform, (String)"mem.createPxTransform()");
                PxTransform pxPose = PhysXExtensionsKt.toPxTransform(pose, pxTransform);
                PxRigidDynamic pxRigidDynamic = Physics.INSTANCE.getPhysics().createRigidDynamic(pxPose);
                Intrinsics.checkNotNullExpressionValue((Object)pxRigidDynamic, (String)"Physics.physics.createRigidDynamic(pxPose)");
                this.pxRigidActor = (PxRigidActor)pxRigidDynamic;
                this.setMass(mass);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        } else {
            this.pxRigidActor = (PxRigidActor)pxActor;
        }
        if (isKinematic) {
            this.getPxRigidBody$kool_physics().setRigidBodyFlag(PxRigidBodyFlagEnum.eKINEMATIC, true);
        }
        this.getTransform().set(pose);
    }

    public RigidDynamic(float mass, @NotNull Mat4f pose, boolean isKinematic) {
        Intrinsics.checkNotNullParameter((Object)pose, (String)"pose");
        this(mass, pose, isKinematic, null);
    }

    public /* synthetic */ RigidDynamic(float f, Mat4f mat4f, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            f = 1.0f;
        }
        if ((n & 2) != 0) {
            mat4f = new Mat4f();
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        this(f, mat4f, bl);
    }

    private final PxRigidDynamic getPxRigidDynamic() {
        PxRigidActor pxRigidActor = this.getPxRigidActor();
        Intrinsics.checkNotNull((Object)pxRigidActor, (String)"null cannot be cast to non-null type physx.physics.PxRigidDynamic");
        return (PxRigidDynamic)pxRigidActor;
    }

    @Override
    @NotNull
    public PxRigidActor getPxRigidActor() {
        return this.pxRigidActor;
    }

    public final void wakeUp() {
        this.getPxRigidDynamic().wakeUp();
    }

    public final void putToSleep() {
        this.getPxRigidDynamic().putToSleep();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setKinematicTarget(@NotNull Mat4f pose) {
        Intrinsics.checkNotNullParameter((Object)pose, (String)"pose");
        AutoCloseable autoCloseable = (AutoCloseable)MemoryStack.stackPush();
        Throwable throwable = null;
        try {
            MemoryStack mem = (MemoryStack)autoCloseable;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)mem, (String)"mem");
            PxTransform pxTransform = PhysXExtensionsKt.createPxTransform(mem);
            Intrinsics.checkNotNullExpressionValue((Object)pxTransform, (String)"mem.createPxTransform()");
            PxTransform pxPose = PhysXExtensionsKt.toPxTransform(pose, pxTransform);
            this.getPxRigidDynamic().setKinematicTarget(pxPose);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setKinematicTarget(@Nullable Vec3f position, @Nullable Vec4f rotation) {
        AutoCloseable autoCloseable = (AutoCloseable)MemoryStack.stackPush();
        Throwable throwable = null;
        try {
            Vec4f vec4f;
            PxTransform pxPose;
            block13: {
                block12: {
                    Vec3f vec3f;
                    MemoryStack mem;
                    block11: {
                        block10: {
                            mem = (MemoryStack)autoCloseable;
                            boolean bl = false;
                            Intrinsics.checkNotNullExpressionValue((Object)mem, (String)"mem");
                            pxPose = PhysXExtensionsKt.createPxTransform(mem);
                            vec3f = position;
                            if (vec3f == null) break block10;
                            PxVec3 pxVec3 = PhysXExtensionsKt.createPxVec3(mem);
                            Intrinsics.checkNotNullExpressionValue((Object)pxVec3, (String)"mem.createPxVec3()");
                            if ((vec3f = PhysXExtensionsKt.toPxVec3(vec3f, pxVec3)) != null) break block11;
                        }
                        vec3f = this.getPxRigidActor().getGlobalPose().getP();
                    }
                    pxPose.setP((PxVec3)vec3f);
                    vec4f = rotation;
                    if (vec4f == null) break block12;
                    PxQuat pxQuat = PhysXExtensionsKt.createPxQuat(mem);
                    Intrinsics.checkNotNullExpressionValue((Object)pxQuat, (String)"mem.createPxQuat()");
                    if ((vec4f = PhysXExtensionsKt.toPxQuat(vec4f, pxQuat)) != null) break block13;
                }
                vec4f = this.getPxRigidActor().getGlobalPose().getQ();
            }
            pxPose.setQ((PxQuat)vec4f);
            this.getPxRigidDynamic().setKinematicTarget(pxPose);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    public static /* synthetic */ void setKinematicTarget$default(RigidDynamic rigidDynamic, Vec3f vec3f, Vec4f vec4f, int n, Object object) {
        if ((n & 1) != 0) {
            vec3f = null;
        }
        if ((n & 2) != 0) {
            vec4f = null;
        }
        rigidDynamic.setKinematicTarget(vec3f, vec4f);
    }
}

