/*
 * Decompiled with CFR 0.152.
 */
package de.fabmax.kool.physics;

import de.fabmax.kool.math.MutableVec3f;
import de.fabmax.kool.math.Vec3f;
import de.fabmax.kool.physics.PhysXExtensionsKt;
import de.fabmax.kool.physics.RigidActor;
import de.fabmax.kool.physics.Shape;
import de.fabmax.kool.physics.geometry.CollisionGeometry;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.system.MemoryStack;
import physx.common.PxVec3;
import physx.extensions.PxRigidBodyExt;
import physx.physics.PxForceModeEnum;
import physx.physics.PxRigidActor;
import physx.physics.PxRigidBody;
import physx.physics.PxRigidDynamic;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J*\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\n2\u0006\u00102\u001a\u00020\n2\b\b\u0002\u00103\u001a\u00020\u00182\b\b\u0002\u00104\u001a\u00020\u0018J*\u00105\u001a\u0002002\u0006\u00106\u001a\u00020\n2\u0006\u00102\u001a\u00020\n2\b\b\u0002\u00107\u001a\u00020\u00182\b\b\u0002\u00104\u001a\u00020\u0018J\u0018\u00108\u001a\u0002002\u0006\u00109\u001a\u00020\n2\b\b\u0002\u0010:\u001a\u00020\u0018J\u0010\u0010;\u001a\u0002002\u0006\u0010<\u001a\u00020=H\u0016J\b\u0010>\u001a\u000200H\u0016J\u0006\u0010?\u001a\u000200R$\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00048F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR$\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0003\u001a\u00020\n8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0003\u001a\u00020\n8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0015\u0010\r\"\u0004\b\u0016\u0010\u000fR\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00048F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001a\u0010\u0007\"\u0004\b\u001b\u0010\tR$\u0010\u001c\u001a\u00020\n2\u0006\u0010\u0003\u001a\u00020\n8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001d\u0010\r\"\u0004\b\u001e\u0010\u000fR$\u0010\u001f\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00048F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b \u0010\u0007\"\u0004\b!\u0010\tR$\u0010\"\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00048F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b#\u0010\u0007\"\u0004\b$\u0010\tR$\u0010%\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00048F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b&\u0010\u0007\"\u0004\b'\u0010\tR\u0014\u0010(\u001a\u00020)8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010+R\u000e\u0010,\u001a\u00020-X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lde/fabmax/kool/physics/RigidBody;", "Lde/fabmax/kool/physics/RigidActor;", "()V", "value", "", "angularDamping", "getAngularDamping", "()F", "setAngularDamping", "(F)V", "Lde/fabmax/kool/math/Vec3f;", "angularVelocity", "getAngularVelocity", "()Lde/fabmax/kool/math/Vec3f;", "setAngularVelocity", "(Lde/fabmax/kool/math/Vec3f;)V", "bufAngVelocity", "Lde/fabmax/kool/math/MutableVec3f;", "bufInertia", "bufLinVelocity", "inertia", "getInertia", "setInertia", "isInertiaSet", "", "linearDamping", "getLinearDamping", "setLinearDamping", "linearVelocity", "getLinearVelocity", "setLinearVelocity", "mass", "getMass", "setMass", "maxAngularVelocity", "getMaxAngularVelocity", "setMaxAngularVelocity", "maxLinearVelocity", "getMaxLinearVelocity", "setMaxLinearVelocity", "pxRigidBody", "Lphysx/physics/PxRigidBody;", "getPxRigidBody$kool_physics", "()Lphysx/physics/PxRigidBody;", "pxTmpVec", "Lphysx/common/PxVec3;", "tmpVec", "addForceAtPos", "", "force", "pos", "isLocalForce", "isLocalPos", "addImpulseAtPos", "impulse", "isLocalImpulse", "addTorque", "torque", "isLocalTorque", "attachShape", "shape", "Lde/fabmax/kool/physics/Shape;", "release", "updateInertiaFromShapesAndMass", "kool-physics"})
public abstract class RigidBody
extends RigidActor {
    private boolean isInertiaSet;
    @NotNull
    private final MutableVec3f bufInertia = new MutableVec3f();
    @NotNull
    private final MutableVec3f bufLinVelocity = new MutableVec3f();
    @NotNull
    private final MutableVec3f bufAngVelocity = new MutableVec3f();
    @NotNull
    private final MutableVec3f tmpVec = new MutableVec3f();
    @NotNull
    private final PxVec3 pxTmpVec = new PxVec3();

    @NotNull
    public final PxRigidBody getPxRigidBody$kool_physics() {
        PxRigidActor pxRigidActor = this.getPxRigidActor();
        Intrinsics.checkNotNull((Object)pxRigidActor, (String)"null cannot be cast to non-null type physx.physics.PxRigidBody");
        return (PxRigidBody)pxRigidActor;
    }

    public final float getMass() {
        return this.getPxRigidBody$kool_physics().getMass();
    }

    public final void setMass(float value) {
        this.getPxRigidBody$kool_physics().setMass(value);
    }

    @NotNull
    public final Vec3f getInertia() {
        PxVec3 pxVec3 = this.getPxRigidBody$kool_physics().getMassSpaceInertiaTensor();
        Intrinsics.checkNotNullExpressionValue((Object)pxVec3, (String)"pxRigidBody.massSpaceInertiaTensor");
        return (Vec3f)PhysXExtensionsKt.toVec3f(pxVec3, this.bufInertia);
    }

    public final void setInertia(@NotNull Vec3f value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.getPxRigidBody$kool_physics().setMassSpaceInertiaTensor(PhysXExtensionsKt.toPxVec3(value, this.pxTmpVec));
        this.isInertiaSet = true;
    }

    @NotNull
    public final Vec3f getLinearVelocity() {
        PxVec3 pxVec3 = this.getPxRigidBody$kool_physics().getLinearVelocity();
        Intrinsics.checkNotNullExpressionValue((Object)pxVec3, (String)"pxRigidBody.linearVelocity");
        return (Vec3f)PhysXExtensionsKt.toVec3f(pxVec3, this.bufLinVelocity);
    }

    public final void setLinearVelocity(@NotNull Vec3f value) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            PxRigidBody pxRigidBody = this.getPxRigidBody$kool_physics();
            PxRigidDynamic pxRigidDynamic = pxRigidBody instanceof PxRigidDynamic ? (PxRigidDynamic)pxRigidBody : null;
            if (pxRigidDynamic == null) break block0;
            PxRigidDynamic it = pxRigidDynamic;
            boolean bl = false;
            it.setLinearVelocity(PhysXExtensionsKt.toPxVec3(value, this.pxTmpVec));
        }
    }

    @NotNull
    public final Vec3f getAngularVelocity() {
        PxVec3 pxVec3 = this.getPxRigidBody$kool_physics().getAngularVelocity();
        Intrinsics.checkNotNullExpressionValue((Object)pxVec3, (String)"pxRigidBody.angularVelocity");
        return (Vec3f)PhysXExtensionsKt.toVec3f(pxVec3, this.bufAngVelocity);
    }

    public final void setAngularVelocity(@NotNull Vec3f value) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            PxRigidBody pxRigidBody = this.getPxRigidBody$kool_physics();
            PxRigidDynamic pxRigidDynamic = pxRigidBody instanceof PxRigidDynamic ? (PxRigidDynamic)pxRigidBody : null;
            if (pxRigidDynamic == null) break block0;
            PxRigidDynamic it = pxRigidDynamic;
            boolean bl = false;
            it.setAngularVelocity(PhysXExtensionsKt.toPxVec3(value, this.pxTmpVec));
        }
    }

    public final float getMaxLinearVelocity() {
        return this.getPxRigidBody$kool_physics().getMaxLinearVelocity();
    }

    public final void setMaxLinearVelocity(float value) {
        this.getPxRigidBody$kool_physics().setMaxLinearVelocity(value);
    }

    public final float getMaxAngularVelocity() {
        return this.getPxRigidBody$kool_physics().getMaxAngularVelocity();
    }

    public final void setMaxAngularVelocity(float value) {
        this.getPxRigidBody$kool_physics().setMaxAngularVelocity(value);
    }

    public final float getLinearDamping() {
        return this.getPxRigidBody$kool_physics().getLinearDamping();
    }

    public final void setLinearDamping(float value) {
        this.getPxRigidBody$kool_physics().setLinearDamping(value);
    }

    public final float getAngularDamping() {
        return this.getPxRigidBody$kool_physics().getAngularDamping();
    }

    public final void setAngularDamping(float value) {
        this.getPxRigidBody$kool_physics().setAngularDamping(value);
    }

    @Override
    public void attachShape(@NotNull Shape shape) {
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        super.attachShape(shape);
        if (!this.isInertiaSet) {
            this.setInertia((Vec3f)CollisionGeometry.DefaultImpls.estimateInertiaForMass$default(shape.getGeometry(), this.getMass(), null, 2, null));
        }
    }

    @Override
    public void release() {
        super.release();
        this.pxTmpVec.destroy();
    }

    public final void updateInertiaFromShapesAndMass() {
        PxRigidBodyExt.setMassAndUpdateInertia((PxRigidBody)this.getPxRigidBody$kool_physics(), (float)this.getMass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addForceAtPos(@NotNull Vec3f force, @NotNull Vec3f pos, boolean isLocalForce, boolean isLocalPos) {
        Intrinsics.checkNotNullParameter((Object)force, (String)"force");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        AutoCloseable autoCloseable = (AutoCloseable)MemoryStack.stackPush();
        Throwable throwable = null;
        try {
            MemoryStack mem = (MemoryStack)autoCloseable;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)mem, (String)"mem");
            PxVec3 pxVec3 = PhysXExtensionsKt.createPxVec3(mem);
            Intrinsics.checkNotNullExpressionValue((Object)pxVec3, (String)"mem.createPxVec3()");
            PxVec3 pxForce = PhysXExtensionsKt.toPxVec3(force, pxVec3);
            PxVec3 pxVec32 = PhysXExtensionsKt.createPxVec3(mem);
            Intrinsics.checkNotNullExpressionValue((Object)pxVec32, (String)"mem.createPxVec3()");
            PxVec3 pxPos = PhysXExtensionsKt.toPxVec3(pos, pxVec32);
            if (isLocalForce && isLocalPos) {
                PxRigidBodyExt.addLocalForceAtLocalPos((PxRigidBody)this.getPxRigidBody$kool_physics(), (PxVec3)pxForce, (PxVec3)pxPos);
            } else if (isLocalForce && !isLocalPos) {
                PxRigidBodyExt.addLocalForceAtPos((PxRigidBody)this.getPxRigidBody$kool_physics(), (PxVec3)pxForce, (PxVec3)pxPos);
            } else if (!isLocalForce && isLocalPos) {
                PxRigidBodyExt.addForceAtLocalPos((PxRigidBody)this.getPxRigidBody$kool_physics(), (PxVec3)pxForce, (PxVec3)pxPos);
            } else {
                PxRigidBodyExt.addForceAtPos((PxRigidBody)this.getPxRigidBody$kool_physics(), (PxVec3)pxForce, (PxVec3)pxPos);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    public static /* synthetic */ void addForceAtPos$default(RigidBody rigidBody, Vec3f vec3f, Vec3f vec3f2, boolean bl, boolean bl2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: addForceAtPos");
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            bl2 = false;
        }
        rigidBody.addForceAtPos(vec3f, vec3f2, bl, bl2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addImpulseAtPos(@NotNull Vec3f impulse, @NotNull Vec3f pos, boolean isLocalImpulse, boolean isLocalPos) {
        Intrinsics.checkNotNullParameter((Object)impulse, (String)"impulse");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        AutoCloseable autoCloseable = (AutoCloseable)MemoryStack.stackPush();
        Throwable throwable = null;
        try {
            MemoryStack mem = (MemoryStack)autoCloseable;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)mem, (String)"mem");
            PxVec3 pxVec3 = PhysXExtensionsKt.createPxVec3(mem);
            Intrinsics.checkNotNullExpressionValue((Object)pxVec3, (String)"mem.createPxVec3()");
            PxVec3 pxImpulse = PhysXExtensionsKt.toPxVec3(impulse, pxVec3);
            PxVec3 pxVec32 = PhysXExtensionsKt.createPxVec3(mem);
            Intrinsics.checkNotNullExpressionValue((Object)pxVec32, (String)"mem.createPxVec3()");
            PxVec3 pxPos = PhysXExtensionsKt.toPxVec3(pos, pxVec32);
            if (isLocalImpulse && isLocalPos) {
                PxRigidBodyExt.addLocalForceAtLocalPos((PxRigidBody)this.getPxRigidBody$kool_physics(), (PxVec3)pxImpulse, (PxVec3)pxPos, (PxForceModeEnum)PxForceModeEnum.eIMPULSE);
            } else if (isLocalImpulse && !isLocalPos) {
                PxRigidBodyExt.addLocalForceAtPos((PxRigidBody)this.getPxRigidBody$kool_physics(), (PxVec3)pxImpulse, (PxVec3)pxPos, (PxForceModeEnum)PxForceModeEnum.eIMPULSE);
            } else if (!isLocalImpulse && isLocalPos) {
                PxRigidBodyExt.addForceAtLocalPos((PxRigidBody)this.getPxRigidBody$kool_physics(), (PxVec3)pxImpulse, (PxVec3)pxPos, (PxForceModeEnum)PxForceModeEnum.eIMPULSE);
            } else {
                PxRigidBodyExt.addForceAtPos((PxRigidBody)this.getPxRigidBody$kool_physics(), (PxVec3)pxImpulse, (PxVec3)pxPos, (PxForceModeEnum)PxForceModeEnum.eIMPULSE);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    public static /* synthetic */ void addImpulseAtPos$default(RigidBody rigidBody, Vec3f vec3f, Vec3f vec3f2, boolean bl, boolean bl2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: addImpulseAtPos");
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            bl2 = false;
        }
        rigidBody.addImpulseAtPos(vec3f, vec3f2, bl, bl2);
    }

    public final void addTorque(@NotNull Vec3f torque, boolean isLocalTorque) {
        Intrinsics.checkNotNullParameter((Object)torque, (String)"torque");
        this.tmpVec.set(torque);
        if (isLocalTorque) {
            this.getTransform().transform(this.tmpVec, 0.0f);
        }
        this.getPxRigidBody$kool_physics().addTorque(PhysXExtensionsKt.toPxVec3((Vec3f)this.tmpVec, this.pxTmpVec));
    }

    public static /* synthetic */ void addTorque$default(RigidBody rigidBody, Vec3f vec3f, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: addTorque");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        rigidBody.addTorque(vec3f, bl);
    }
}

