/*
 * Decompiled with CFR 0.152.
 */
package de.fabmax.kool.physics;

import de.fabmax.kool.math.Mat4f;
import de.fabmax.kool.math.MutableVec3f;
import de.fabmax.kool.math.MutableVec4f;
import de.fabmax.kool.math.Vec3f;
import de.fabmax.kool.math.Vec4f;
import de.fabmax.kool.math.spatial.BoundingBox;
import de.fabmax.kool.physics.CommonRigidActor;
import de.fabmax.kool.physics.FilterData;
import de.fabmax.kool.physics.FilterDataBuilder;
import de.fabmax.kool.physics.FilterDataKt;
import de.fabmax.kool.physics.PhysXExtensionsKt;
import de.fabmax.kool.physics.Physics;
import de.fabmax.kool.physics.RigidActor;
import de.fabmax.kool.physics.Shape;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.system.MemoryStack;
import physx.common.PxBounds3;
import physx.common.PxQuat;
import physx.common.PxTransform;
import physx.common.PxVec3;
import physx.extensions.PxRigidActorExt;
import physx.geometry.PxGeometry;
import physx.physics.PxFilterData;
import physx.physics.PxMaterial;
import physx.physics.PxRigidActor;
import physx.physics.PxShape;
import physx.physics.PxShapeFlagEnum;
import physx.physics.PxShapeFlags;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0006\b&\u0018\u0000 :2\u00020\u0001:\u0001:B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0016J\u0010\u00102\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0016J\u0015\u00103\u001a\u00020/2\u0006\u00104\u001a\u000205H\u0010\u00a2\u0006\u0002\b6J\b\u00107\u001a\u00020/H\u0016J\b\u00108\u001a\u00020/H\u0002J\b\u00109\u001a\u00020/H\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@PX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR$\u0010\u0010\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\n@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\f\"\u0004\b\u0011\u0010\u000eR$\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u00128V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0012\u0010\u0018\u001a\u00020\u0019X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR$\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u000f\u001a\u00020\u001c@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R$\u0010#\u001a\u00020\"2\u0006\u0010\u000f\u001a\u00020\"8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R$\u0010(\u001a\u00020\u001c2\u0006\u0010\u000f\u001a\u00020\u001c@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010\u001f\"\u0004\b*\u0010!R\u0011\u0010+\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b,\u0010-\u00a8\u0006;"}, d2={"Lde/fabmax/kool/physics/RigidActor;", "Lde/fabmax/kool/physics/CommonRigidActor;", "()V", "bufBounds", "Lde/fabmax/kool/math/spatial/BoundingBox;", "bufPosition", "Lde/fabmax/kool/math/MutableVec3f;", "bufRotation", "Lde/fabmax/kool/math/MutableVec4f;", "<set-?>", "", "isActive", "()Z", "setActive$kool_physics", "(Z)V", "value", "isTrigger", "setTrigger", "Lde/fabmax/kool/math/Vec3f;", "position", "getPosition", "()Lde/fabmax/kool/math/Vec3f;", "setPosition", "(Lde/fabmax/kool/math/Vec3f;)V", "pxRigidActor", "Lphysx/physics/PxRigidActor;", "getPxRigidActor", "()Lphysx/physics/PxRigidActor;", "Lde/fabmax/kool/physics/FilterData;", "queryFilterData", "getQueryFilterData", "()Lde/fabmax/kool/physics/FilterData;", "setQueryFilterData", "(Lde/fabmax/kool/physics/FilterData;)V", "Lde/fabmax/kool/math/Vec4f;", "rotation", "getRotation", "()Lde/fabmax/kool/math/Vec4f;", "setRotation", "(Lde/fabmax/kool/math/Vec4f;)V", "simulationFilterData", "getSimulationFilterData", "setSimulationFilterData", "worldBounds", "getWorldBounds", "()Lde/fabmax/kool/math/spatial/BoundingBox;", "attachShape", "", "shape", "Lde/fabmax/kool/physics/Shape;", "detachShape", "onPhysicsUpdate", "timeStep", "", "onPhysicsUpdate$kool_physics", "release", "updateFilterData", "updateTransform", "Companion", "kool-physics"})
@SourceDebugExtension(value={"SMAP\nRigidActor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RigidActor.kt\nde/fabmax/kool/physics/RigidActor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,126:1\n1855#2,2:127\n1855#2,2:129\n*S KotlinDebug\n*F\n+ 1 RigidActor.kt\nde/fabmax/kool/physics/RigidActor\n*L\n61#1:127,2\n75#1:129,2\n*E\n"})
public abstract class RigidActor
extends CommonRigidActor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private FilterData simulationFilterData;
    @NotNull
    private FilterData queryFilterData;
    @NotNull
    private final BoundingBox bufBounds;
    @NotNull
    private final MutableVec3f bufPosition;
    @NotNull
    private final MutableVec4f bufRotation;
    private boolean isTrigger;
    private boolean isActive;
    private static final int SIM_SHAPE_FLAGS = PxShapeFlagEnum.eSIMULATION_SHAPE.value | PxShapeFlagEnum.eSCENE_QUERY_SHAPE.value;
    private static final int TRIGGER_SHAPE_FLAGS = PxShapeFlagEnum.eTRIGGER_SHAPE.value;

    public RigidActor() {
        Physics.INSTANCE.checkIsLoaded();
        this.simulationFilterData = FilterDataKt.FilterData((Function1<? super FilterDataBuilder, Unit>)((Function1)simulationFilterData.1.INSTANCE));
        this.queryFilterData = new FilterData(0, 0, 0, 0, 15, null);
        this.bufBounds = new BoundingBox();
        this.bufPosition = new MutableVec3f();
        this.bufRotation = new MutableVec4f();
        this.isActive = true;
    }

    @NotNull
    public abstract PxRigidActor getPxRigidActor();

    @NotNull
    public final FilterData getSimulationFilterData() {
        return this.simulationFilterData;
    }

    public final void setSimulationFilterData(@NotNull FilterData value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.simulationFilterData = value;
        this.updateFilterData();
    }

    @NotNull
    public final FilterData getQueryFilterData() {
        return this.queryFilterData;
    }

    public final void setQueryFilterData(@NotNull FilterData value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.queryFilterData = value;
        this.updateFilterData();
    }

    @Override
    @NotNull
    public Vec3f getPosition() {
        PxVec3 pxVec3 = this.getPxRigidActor().getGlobalPose().getP();
        Intrinsics.checkNotNullExpressionValue((Object)pxVec3, (String)"pxRigidActor.globalPose.p");
        return (Vec3f)PhysXExtensionsKt.toVec3f(pxVec3, this.bufPosition);
    }

    @Override
    public void setPosition(@NotNull Vec3f value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        PxTransform pose = this.getPxRigidActor().getGlobalPose();
        PxVec3 pxVec3 = pose.getP();
        Intrinsics.checkNotNullExpressionValue((Object)pxVec3, (String)"pose.p");
        PhysXExtensionsKt.toPxVec3(value, pxVec3);
        this.getPxRigidActor().setGlobalPose(pose);
        this.updateTransform();
    }

    @Override
    @NotNull
    public Vec4f getRotation() {
        PxQuat pxQuat = this.getPxRigidActor().getGlobalPose().getQ();
        Intrinsics.checkNotNullExpressionValue((Object)pxQuat, (String)"pxRigidActor.globalPose.q");
        return (Vec4f)PhysXExtensionsKt.toVec4f(pxQuat, this.bufRotation);
    }

    @Override
    public void setRotation(@NotNull Vec4f value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        PxTransform pose = this.getPxRigidActor().getGlobalPose();
        PxQuat pxQuat = pose.getQ();
        Intrinsics.checkNotNullExpressionValue((Object)pxQuat, (String)"pose.q");
        PhysXExtensionsKt.toPxQuat(value, pxQuat);
        this.getPxRigidActor().setGlobalPose(pose);
        this.updateTransform();
    }

    @Override
    public boolean isTrigger() {
        return this.isTrigger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTrigger(boolean value) {
        this.isTrigger = value;
        AutoCloseable autoCloseable = (AutoCloseable)MemoryStack.stackPush();
        Throwable throwable = null;
        try {
            MemoryStack mem = (MemoryStack)autoCloseable;
            boolean bl = false;
            int flags = this.isTrigger() ? TRIGGER_SHAPE_FLAGS : SIM_SHAPE_FLAGS;
            Intrinsics.checkNotNullExpressionValue((Object)mem, (String)"mem");
            PxShapeFlags shapeFlags = PhysXExtensionsKt.createPxShapeFlags(mem, flags);
            Iterable $this$forEach$iv = this.getShapes();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Shape it = (Shape)element$iv;
                boolean bl2 = false;
                PxShape pxShape = it.getPxShape$kool_physics();
                if (pxShape == null) continue;
                pxShape.setFlags(shapeFlags);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    public void setActive$kool_physics(boolean bl) {
        this.isActive = bl;
    }

    @NotNull
    public final BoundingBox getWorldBounds() {
        PxBounds3 pxBounds3 = this.getPxRigidActor().getWorldBounds();
        Intrinsics.checkNotNullExpressionValue((Object)pxBounds3, (String)"pxRigidActor.worldBounds");
        return PhysXExtensionsKt.toBoundingBox(pxBounds3, this.bufBounds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void updateFilterData() {
        AutoCloseable autoCloseable = (AutoCloseable)MemoryStack.stackPush();
        Throwable throwable = null;
        try {
            MemoryStack mem = (MemoryStack)autoCloseable;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)mem, (String)"mem");
            PxFilterData pxFilterData = PhysXExtensionsKt.createPxFilterData(mem);
            Intrinsics.checkNotNullExpressionValue((Object)pxFilterData, (String)"mem.createPxFilterData()");
            PxFilterData sfd = PhysXExtensionsKt.toPxFilterData(this.simulationFilterData, pxFilterData);
            PxFilterData pxFilterData2 = PhysXExtensionsKt.createPxFilterData(mem);
            Intrinsics.checkNotNullExpressionValue((Object)pxFilterData2, (String)"mem.createPxFilterData()");
            PxFilterData qfd = PhysXExtensionsKt.toPxFilterData(this.queryFilterData, pxFilterData2);
            Iterable $this$forEach$iv = this.getShapes();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PxShape it;
                Shape shape = (Shape)element$iv;
                boolean bl2 = false;
                if (shape.getPxShape$kool_physics() == null) continue;
                boolean bl3 = false;
                it.setSimulationFilterData(sfd);
                it.setQueryFilterData(qfd);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void attachShape(@NotNull Shape shape) {
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        super.attachShape(shape);
        AutoCloseable autoCloseable = (AutoCloseable)MemoryStack.stackPush();
        Throwable throwable = null;
        try {
            MemoryStack mem = (MemoryStack)autoCloseable;
            boolean bl = false;
            int flags = this.isTrigger() ? TRIGGER_SHAPE_FLAGS : SIM_SHAPE_FLAGS;
            Intrinsics.checkNotNullExpressionValue((Object)mem, (String)"mem");
            PxShapeFlags shapeFlags = PhysXExtensionsKt.createPxShapeFlags(mem, flags);
            PxShape pxShape = PxRigidActorExt.createExclusiveShape((PxRigidActor)this.getPxRigidActor(), (PxGeometry)shape.getGeometry().getPxGeometry(), (PxMaterial)shape.getMaterial().getPxMaterial(), (PxShapeFlags)shapeFlags);
            Mat4f mat4f = shape.getLocalPose();
            PxTransform pxTransform = PhysXExtensionsKt.createPxTransform(mem);
            Intrinsics.checkNotNullExpressionValue((Object)pxTransform, (String)"mem.createPxTransform()");
            pxShape.setLocalPose(PhysXExtensionsKt.toPxTransform(mat4f, pxTransform));
            FilterData simFd = shape.getSimFilterData() != null ? shape.getSimFilterData() : this.simulationFilterData;
            PxFilterData pxFilterData = PhysXExtensionsKt.createPxFilterData(mem);
            Intrinsics.checkNotNullExpressionValue((Object)pxFilterData, (String)"mem.createPxFilterData()");
            pxShape.setSimulationFilterData(PhysXExtensionsKt.toPxFilterData(simFd, pxFilterData));
            FilterData qryFd = shape.getQueryFilterData() != null ? shape.getQueryFilterData() : this.queryFilterData;
            PxFilterData pxFilterData2 = PhysXExtensionsKt.createPxFilterData(mem);
            Intrinsics.checkNotNullExpressionValue((Object)pxFilterData2, (String)"mem.createPxFilterData()");
            pxShape.setQueryFilterData(PhysXExtensionsKt.toPxFilterData(qryFd, pxFilterData2));
            shape.setPxShape$kool_physics(pxShape);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    @Override
    public void detachShape(@NotNull Shape shape) {
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        PxShape pxShape = shape.getPxShape$kool_physics();
        if (pxShape != null) {
            pxShape.release();
        }
        super.detachShape(shape);
    }

    @Override
    public void release() {
        this.getPxRigidActor().release();
        super.release();
    }

    @Override
    public void onPhysicsUpdate$kool_physics(float timeStep) {
        this.updateTransform();
        super.onPhysicsUpdate$kool_physics(timeStep);
    }

    protected final void updateTransform() {
        if (this.isActive()) {
            PxTransform pxTransform = this.getPxRigidActor().getGlobalPose();
            Intrinsics.checkNotNullExpressionValue((Object)pxTransform, (String)"pxRigidActor.globalPose");
            PhysXExtensionsKt.toMat4f(pxTransform, this.getTransform());
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\t"}, d2={"Lde/fabmax/kool/physics/RigidActor$Companion;", "", "()V", "SIM_SHAPE_FLAGS", "", "getSIM_SHAPE_FLAGS", "()I", "TRIGGER_SHAPE_FLAGS", "getTRIGGER_SHAPE_FLAGS", "kool-physics"})
    public static final class Companion {
        private Companion() {
        }

        public final int getSIM_SHAPE_FLAGS() {
            return SIM_SHAPE_FLAGS;
        }

        public final int getTRIGGER_SHAPE_FLAGS() {
            return TRIGGER_SHAPE_FLAGS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

