/*
 * Decompiled with CFR 0.152.
 */
package de.fabmax.kool.physics;

import de.fabmax.kool.math.Mat4f;
import de.fabmax.kool.math.MutableVec3f;
import de.fabmax.kool.math.Ray;
import de.fabmax.kool.math.Vec3f;
import de.fabmax.kool.physics.CommonPhysicsWorld;
import de.fabmax.kool.physics.ContactPoint;
import de.fabmax.kool.physics.FilterDataBuilder;
import de.fabmax.kool.physics.FilterDataKt;
import de.fabmax.kool.physics.HitResult;
import de.fabmax.kool.physics.PhysXExtensionsKt;
import de.fabmax.kool.physics.Physics;
import de.fabmax.kool.physics.Releasable;
import de.fabmax.kool.physics.RigidActor;
import de.fabmax.kool.physics.TriggerListener;
import de.fabmax.kool.physics.articulations.Articulation;
import de.fabmax.kool.physics.articulations.ArticulationLink;
import de.fabmax.kool.physics.geometry.CollisionGeometry;
import de.fabmax.kool.scene.Scene;
import de.fabmax.kool.util.Log;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.system.MemoryStack;
import physx.PxTopLevelFunctions;
import physx.common.PxCpuDispatcher;
import physx.common.PxTolerancesScale;
import physx.common.PxTransform;
import physx.common.PxVec3;
import physx.physics.PxActor;
import physx.physics.PxContactPair;
import physx.physics.PxContactPairHeader;
import physx.physics.PxContactPairPoint;
import physx.physics.PxPairFlagEnum;
import physx.physics.PxPairFlags;
import physx.physics.PxRaycastBuffer10;
import physx.physics.PxRaycastCallback;
import physx.physics.PxRaycastHit;
import physx.physics.PxRigidActor;
import physx.physics.PxRigidBody;
import physx.physics.PxRigidBodyFlagEnum;
import physx.physics.PxScene;
import physx.physics.PxSceneDesc;
import physx.physics.PxSceneFlagEnum;
import physx.physics.PxSimulationEventCallback;
import physx.physics.PxSimulationEventCallbackImpl;
import physx.physics.PxSweepBuffer10;
import physx.physics.PxSweepCallback;
import physx.physics.PxSweepHit;
import physx.physics.PxTriggerPair;
import physx.support.SupportFunctions;
import physx.support.Vector_PxActorPtr;
import physx.support.Vector_PxContactPairPoint;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002:\u0001AB\u001b\u0012\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u001cH\u0016J\u0010\u0010(\u001a\u00020&2\u0006\u0010)\u001a\u00020*H\u0016J\b\u0010+\u001a\u00020&H\u0016J\u0010\u0010,\u001a\u0004\u0018\u00010\u001c2\u0006\u0010-\u001a\u00020\u001bJ\u001e\u0010.\u001a\u00020\u00062\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u000204J\b\u00105\u001a\u00020&H\u0016J\u0010\u00106\u001a\u00020&2\u0006\u0010'\u001a\u00020\u001cH\u0016J\u0010\u00107\u001a\u00020&2\u0006\u0010)\u001a\u00020*H\u0016J\u0010\u00108\u001a\u00020&2\u0006\u00109\u001a\u000202H\u0016J.\u0010:\u001a\u00020\u00062\u0006\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020\u00112\u0006\u0010@\u001a\u0002022\u0006\u00103\u001a\u000204R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u00118F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001c0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001d\u001a\u00020\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006B"}, d2={"Lde/fabmax/kool/physics/PhysicsWorld;", "Lde/fabmax/kool/physics/CommonPhysicsWorld;", "Lde/fabmax/kool/physics/Releasable;", "scene", "Lde/fabmax/kool/scene/Scene;", "isContinuousCollisionDetection", "", "(Lde/fabmax/kool/scene/Scene;Z)V", "activeActors", "", "getActiveActors", "()I", "bufGravity", "Lde/fabmax/kool/math/MutableVec3f;", "bufPxGravity", "Lphysx/common/PxVec3;", "value", "Lde/fabmax/kool/math/Vec3f;", "gravity", "getGravity", "()Lde/fabmax/kool/math/Vec3f;", "setGravity", "(Lde/fabmax/kool/math/Vec3f;)V", "()Z", "mutActiveActors", "pxActors", "", "Lphysx/physics/PxActor;", "Lde/fabmax/kool/physics/RigidActor;", "pxScene", "Lphysx/physics/PxScene;", "getPxScene", "()Lphysx/physics/PxScene;", "raycastResult", "Lphysx/physics/PxRaycastBuffer10;", "sweepResult", "Lphysx/physics/PxSweepBuffer10;", "addActor", "", "actor", "addArticulation", "articulation", "Lde/fabmax/kool/physics/articulations/Articulation;", "fetchAsyncStepResults", "getActor", "pxActor", "raycast", "ray", "Lde/fabmax/kool/math/Ray;", "maxDistance", "", "result", "Lde/fabmax/kool/physics/HitResult;", "release", "removeActor", "removeArticulation", "singleStepAsync", "timeStep", "sweepTest", "testGeometry", "Lde/fabmax/kool/physics/geometry/CollisionGeometry;", "geometryPose", "Lde/fabmax/kool/math/Mat4f;", "testDirection", "distance", "SimEventCallback", "kool-physics"})
@SourceDebugExtension(value={"SMAP\nPhysicsWorld.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PhysicsWorld.kt\nde/fabmax/kool/physics/PhysicsWorld\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,253:1\n1#2:254\n1855#3,2:255\n1855#3,2:257\n*S KotlinDebug\n*F\n+ 1 PhysicsWorld.kt\nde/fabmax/kool/physics/PhysicsWorld\n*L\n105#1:255,2\n111#1:257,2\n*E\n"})
public final class PhysicsWorld
extends CommonPhysicsWorld
implements Releasable {
    private final boolean isContinuousCollisionDetection;
    @NotNull
    private final PxScene pxScene;
    @NotNull
    private final PxRaycastBuffer10 raycastResult;
    @NotNull
    private final PxSweepBuffer10 sweepResult;
    @NotNull
    private final PxVec3 bufPxGravity;
    @NotNull
    private final MutableVec3f bufGravity;
    private int mutActiveActors;
    @NotNull
    private final Map<PxActor, RigidActor> pxActors;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PhysicsWorld(@Nullable Scene scene, boolean isContinuousCollisionDetection) {
        block7: {
            this.isContinuousCollisionDetection = isContinuousCollisionDetection;
            this.raycastResult = new PxRaycastBuffer10();
            this.sweepResult = new PxSweepBuffer10();
            this.bufPxGravity = PhysXExtensionsKt.toPxVec3(new Vec3f(0.0f, -9.81f, 0.0f), new PxVec3());
            this.bufGravity = new MutableVec3f();
            this.pxActors = new LinkedHashMap();
            Physics.INSTANCE.checkIsLoaded();
            AutoCloseable autoCloseable = (AutoCloseable)MemoryStack.stackPush();
            Throwable throwable = null;
            try {
                MemoryStack mem = (MemoryStack)autoCloseable;
                boolean bl = false;
                PxSceneDesc sceneDesc = PxSceneDesc.createAt((Object)mem, MemoryStack::nmalloc, (PxTolerancesScale)Physics.INSTANCE.getPhysics().getTolerancesScale());
                sceneDesc.setGravity(this.bufPxGravity);
                sceneDesc.setCpuDispatcher((PxCpuDispatcher)Physics.INSTANCE.getDefaultCpuDispatcher());
                sceneDesc.setFilterShader(PxTopLevelFunctions.DefaultFilterShader());
                sceneDesc.setSimulationEventCallback((PxSimulationEventCallback)new SimEventCallback());
                sceneDesc.getFlags().raise(PxSceneFlagEnum.eENABLE_ACTIVE_ACTORS);
                if (this.isContinuousCollisionDetection) {
                    sceneDesc.getFlags().raise(PxSceneFlagEnum.eENABLE_CCD);
                }
                PxScene pxScene = Physics.INSTANCE.getPhysics().createScene(sceneDesc);
                Intrinsics.checkNotNullExpressionValue((Object)pxScene, (String)"Physics.physics.createScene(sceneDesc)");
                this.pxScene = pxScene;
                mem = Unit.INSTANCE;
            }
            catch (Throwable mem) {
                throwable = mem;
                throw mem;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
            Scene scene2 = scene;
            if (scene2 == null) break block7;
            Scene it = scene2;
            boolean bl = false;
            this.registerHandlers(it);
        }
    }

    public /* synthetic */ PhysicsWorld(Scene scene, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            scene = null;
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        this(scene, bl);
    }

    public final boolean isContinuousCollisionDetection() {
        return this.isContinuousCollisionDetection;
    }

    @NotNull
    public final PxScene getPxScene() {
        return this.pxScene;
    }

    @NotNull
    public final Vec3f getGravity() {
        PxVec3 pxVec3 = this.pxScene.getGravity();
        Intrinsics.checkNotNullExpressionValue((Object)pxVec3, (String)"pxScene.gravity");
        return (Vec3f)PhysXExtensionsKt.toVec3f(pxVec3, this.bufGravity);
    }

    public final void setGravity(@NotNull Vec3f value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.pxScene.setGravity(PhysXExtensionsKt.toPxVec3(value, this.bufPxGravity));
    }

    public final int getActiveActors() {
        return this.mutActiveActors;
    }

    @Override
    public void singleStepAsync(float timeStep) {
        super.singleStepAsync(timeStep);
        this.pxScene.simulate(timeStep);
    }

    @Override
    public void fetchAsyncStepResults() {
        this.pxScene.fetchResults(true);
        int n = this.getActors().size();
        for (int i = 0; i < n; ++i) {
            this.getActors().get(i).setActive$kool_physics(false);
        }
        Vector_PxActorPtr activeActors = SupportFunctions.PxScene_getActiveActors((PxScene)this.pxScene);
        this.mutActiveActors = activeActors.size();
        int n2 = this.mutActiveActors;
        for (int i = 0; i < n2; ++i) {
            RigidActor rigidActor = this.pxActors.get(activeActors.at(i));
            if (rigidActor == null) continue;
            rigidActor.setActive$kool_physics(true);
        }
        super.fetchAsyncStepResults();
    }

    @Nullable
    public final RigidActor getActor(@NotNull PxActor pxActor) {
        Intrinsics.checkNotNullParameter((Object)pxActor, (String)"pxActor");
        return this.pxActors.get(pxActor);
    }

    @Override
    public void addActor(@NotNull RigidActor actor) {
        Intrinsics.checkNotNullParameter((Object)actor, (String)"actor");
        super.addActor(actor);
        this.pxScene.addActor((PxActor)actor.getPxRigidActor());
        this.pxActors.put((PxActor)actor.getPxRigidActor(), actor);
        PxRigidActor pxActor = actor.getPxRigidActor();
        if (this.isContinuousCollisionDetection && pxActor instanceof PxRigidBody) {
            ((PxRigidBody)pxActor).setRigidBodyFlag(PxRigidBodyFlagEnum.eENABLE_CCD, true);
            actor.setSimulationFilterData(FilterDataKt.FilterData((Function1<? super FilterDataBuilder, Unit>)((Function1)new Function1<FilterDataBuilder, Unit>(actor){
                final /* synthetic */ RigidActor $actor;
                {
                    this.$actor = $actor;
                    super(1);
                }

                public final void invoke(@NotNull FilterDataBuilder $this$FilterData) {
                    Intrinsics.checkNotNullParameter((Object)$this$FilterData, (String)"$this$FilterData");
                    $this$FilterData.set(this.$actor.getSimulationFilterData());
                    $this$FilterData.setWord2(PxPairFlagEnum.eDETECT_CCD_CONTACT.value);
                }
            })));
        }
    }

    @Override
    public void removeActor(@NotNull RigidActor actor) {
        Intrinsics.checkNotNullParameter((Object)actor, (String)"actor");
        super.removeActor(actor);
        this.pxScene.removeActor((PxActor)actor.getPxRigidActor());
        this.pxActors.remove(actor.getPxRigidActor());
    }

    @Override
    public void addArticulation(@NotNull Articulation articulation) {
        Intrinsics.checkNotNullParameter((Object)articulation, (String)"articulation");
        super.addArticulation(articulation);
        Iterable $this$forEach$iv = articulation.getLinks();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ArticulationLink it = (ArticulationLink)element$iv;
            boolean bl = false;
            this.pxActors.put((PxActor)it.getPxLink(), it);
        }
        this.pxScene.addArticulation(articulation.getPxArticulation());
    }

    @Override
    public void removeArticulation(@NotNull Articulation articulation) {
        Intrinsics.checkNotNullParameter((Object)articulation, (String)"articulation");
        super.removeArticulation(articulation);
        Iterable $this$forEach$iv = articulation.getLinks();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ArticulationLink it = (ArticulationLink)element$iv;
            boolean bl = false;
            this.pxActors.remove(it.getPxLink());
        }
        this.pxScene.removeArticulation(articulation.getPxArticulation());
    }

    @Override
    public void release() {
        super.release();
        this.pxScene.release();
        this.bufPxGravity.destroy();
        this.raycastResult.destroy();
        this.sweepResult.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean raycast(@NotNull Ray ray, float maxDistance, @NotNull HitResult result) {
        Intrinsics.checkNotNullParameter((Object)ray, (String)"ray");
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        result.clear();
        AutoCloseable autoCloseable = (AutoCloseable)MemoryStack.stackPush();
        Throwable throwable = null;
        try {
            MemoryStack mem = (MemoryStack)autoCloseable;
            boolean bl = false;
            PxRaycastBuffer10 pxRaycastBuffer10 = this.raycastResult;
            synchronized (pxRaycastBuffer10) {
                boolean bl2 = false;
                Vec3f vec3f = (Vec3f)ray.getOrigin();
                Intrinsics.checkNotNullExpressionValue((Object)mem, (String)"mem");
                PxVec3 pxVec3 = PhysXExtensionsKt.createPxVec3(mem);
                Intrinsics.checkNotNullExpressionValue((Object)pxVec3, (String)"mem.createPxVec3()");
                PxVec3 ori = PhysXExtensionsKt.toPxVec3(vec3f, pxVec3);
                Vec3f vec3f2 = (Vec3f)ray.getDirection();
                PxVec3 pxVec32 = PhysXExtensionsKt.createPxVec3(mem);
                Intrinsics.checkNotNullExpressionValue((Object)pxVec32, (String)"mem.createPxVec3()");
                PxVec3 dir = PhysXExtensionsKt.toPxVec3(vec3f2, pxVec32);
                if (this.pxScene.raycast(ori, dir, maxDistance, (PxRaycastCallback)this.raycastResult)) {
                    float minDist = maxDistance;
                    PxRaycastHit nearestHit = null;
                    RigidActor nearestActor = null;
                    int n = this.raycastResult.getNbAnyHits();
                    for (int i = 0; i < n; ++i) {
                        PxRaycastHit hit = this.raycastResult.getAnyHit(i);
                        RigidActor actor = this.pxActors.get(hit.getActor());
                        if (actor == null || !(hit.getDistance() < minDist)) continue;
                        ((Collection)result.getHitActors()).add(actor);
                        minDist = hit.getDistance();
                        nearestHit = hit;
                        nearestActor = actor;
                    }
                    if (nearestHit != null) {
                        result.setNearestActor(nearestActor);
                        result.setHitDistance(minDist);
                        PxVec3 pxVec33 = nearestHit.getPosition();
                        Intrinsics.checkNotNullExpressionValue((Object)pxVec33, (String)"nearestHit.position");
                        PhysXExtensionsKt.toVec3f(pxVec33, result.getHitPosition());
                        PxVec3 pxVec34 = nearestHit.getNormal();
                        Intrinsics.checkNotNullExpressionValue((Object)pxVec34, (String)"nearestHit.normal");
                        PhysXExtensionsKt.toVec3f(pxVec34, result.getHitNormal());
                    }
                }
                Unit unit = Unit.INSTANCE;
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return result.isHit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean sweepTest(@NotNull CollisionGeometry testGeometry, @NotNull Mat4f geometryPose, @NotNull Vec3f testDirection, float distance, @NotNull HitResult result) {
        Intrinsics.checkNotNullParameter((Object)testGeometry, (String)"testGeometry");
        Intrinsics.checkNotNullParameter((Object)geometryPose, (String)"geometryPose");
        Intrinsics.checkNotNullParameter((Object)testDirection, (String)"testDirection");
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        result.clear();
        AutoCloseable autoCloseable = (AutoCloseable)MemoryStack.stackPush();
        Throwable throwable = null;
        try {
            MemoryStack mem = (MemoryStack)autoCloseable;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)mem, (String)"mem");
            PxTransform pxTransform = PhysXExtensionsKt.createPxTransform(mem);
            Intrinsics.checkNotNullExpressionValue((Object)pxTransform, (String)"mem.createPxTransform()");
            PxTransform sweepPose = PhysXExtensionsKt.toPxTransform(geometryPose, pxTransform);
            PxVec3 pxVec3 = PhysXExtensionsKt.createPxVec3(mem);
            Intrinsics.checkNotNullExpressionValue((Object)pxVec3, (String)"mem.createPxVec3()");
            PxVec3 sweepDir = PhysXExtensionsKt.toPxVec3(testDirection, pxVec3);
            if (this.pxScene.sweep(testGeometry.getPxGeometry(), sweepPose, sweepDir, distance, (PxSweepCallback)this.sweepResult)) {
                float minDist = distance;
                PxSweepHit nearestHit = null;
                RigidActor nearestActor = null;
                int n = this.sweepResult.getNbAnyHits();
                for (int i = 0; i < n; ++i) {
                    PxSweepHit hit = this.sweepResult.getAnyHit(i);
                    RigidActor actor = this.pxActors.get(hit.getActor());
                    if (actor == null || !(hit.getDistance() < minDist)) continue;
                    ((Collection)result.getHitActors()).add(actor);
                    minDist = hit.getDistance();
                    nearestHit = hit;
                    nearestActor = actor;
                }
                if (nearestHit != null) {
                    result.setNearestActor(nearestActor);
                    result.setHitDistance(minDist);
                    PxVec3 pxVec32 = nearestHit.getPosition();
                    Intrinsics.checkNotNullExpressionValue((Object)pxVec32, (String)"nearestHit.position");
                    PhysXExtensionsKt.toVec3f(pxVec32, result.getHitPosition());
                    PxVec3 pxVec33 = nearestHit.getNormal();
                    Intrinsics.checkNotNullExpressionValue((Object)pxVec33, (String)"nearestHit.normal");
                    PhysXExtensionsKt.toVec3f(pxVec33, result.getHitNormal());
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return result.isHit();
    }

    public PhysicsWorld() {
        this(null, false, 3, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000eH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0012"}, d2={"Lde/fabmax/kool/physics/PhysicsWorld$SimEventCallback;", "Lphysx/physics/PxSimulationEventCallbackImpl;", "(Lde/fabmax/kool/physics/PhysicsWorld;)V", "contacts", "Lphysx/support/Vector_PxContactPairPoint;", "getContacts", "()Lphysx/support/Vector_PxContactPairPoint;", "onContact", "", "pairHeader", "Lphysx/physics/PxContactPairHeader;", "pairs", "Lphysx/physics/PxContactPair;", "nbPairs", "", "onTrigger", "Lphysx/physics/PxTriggerPair;", "count", "kool-physics"})
    @SourceDebugExtension(value={"SMAP\nPhysicsWorld.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PhysicsWorld.kt\nde/fabmax/kool/physics/PhysicsWorld$SimEventCallback\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Log.kt\nde/fabmax/kool/util/LogKt\n+ 5 Log.kt\nde/fabmax/kool/util/Log\n*L\n1#1,253:1\n361#2,7:254\n1855#3,2:261\n1855#3,2:263\n35#4,7:265\n34#4,7:276\n16#5,4:272\n16#5,4:283\n*S KotlinDebug\n*F\n+ 1 PhysicsWorld.kt\nde/fabmax/kool/physics/PhysicsWorld$SimEventCallback\n*L\n200#1:254,7\n204#1:261,2\n209#1:263,2\n215#1:265,7\n225#1:276,7\n215#1:272,4\n225#1:283,4\n*E\n"})
    private final class SimEventCallback
    extends PxSimulationEventCallbackImpl {
        @NotNull
        private final Vector_PxContactPairPoint contacts = new Vector_PxContactPairPoint(64);

        @NotNull
        public final Vector_PxContactPairPoint getContacts() {
            return this.contacts;
        }

        /*
         * WARNING - void declaration
         */
        public void onTrigger(@NotNull PxTriggerPair pairs, int count) {
            Intrinsics.checkNotNullParameter((Object)pairs, (String)"pairs");
            for (int i = 0; i < count; ++i) {
                void this_$iv$iv$iv;
                Object $this$forEach$iv;
                PxTriggerPair pair = PxTriggerPair.arrayGet((long)pairs.getAddress(), (int)i);
                boolean isEnter = pair.getStatus() == PxPairFlagEnum.eNOTIFY_TOUCH_FOUND;
                RigidActor trigger = (RigidActor)PhysicsWorld.this.pxActors.get(pair.getTriggerActor());
                RigidActor actor = (RigidActor)PhysicsWorld.this.pxActors.get(pair.getOtherActor());
                if (trigger != null && actor != null) {
                    TriggerListener it;
                    boolean $i$f$forEach2;
                    Integer n;
                    CommonPhysicsWorld.TriggerListenerContext triggerListenerContext;
                    if (PhysicsWorld.this.getTriggerListeners().get(trigger) == null) continue;
                    CommonPhysicsWorld.TriggerListenerContext $this$onTrigger_u24lambda_u243 = triggerListenerContext;
                    boolean bl = false;
                    Map<RigidActor, Integer> $this$getOrPut$iv = $this$onTrigger_u24lambda_u243.getActorEnterCounts();
                    boolean $i$f$getOrPut = false;
                    Object value$iv = $this$getOrPut$iv.get(actor);
                    if (value$iv == null) {
                        boolean bl2 = false;
                        Integer answer$iv = 0;
                        $this$getOrPut$iv.put(actor, answer$iv);
                        n = answer$iv;
                    } else {
                        n = value$iv;
                    }
                    int cnt = ((Number)n).intValue();
                    if (isEnter) {
                        if (++cnt == 1) {
                            $this$forEach$iv = $this$onTrigger_u24lambda_u243.getListeners();
                            $i$f$forEach2 = false;
                            value$iv = $this$forEach$iv.iterator();
                            while (value$iv.hasNext()) {
                                Object element$iv = value$iv.next();
                                it = (TriggerListener)element$iv;
                                boolean bl3 = false;
                                it.onActorEntered(trigger, actor);
                            }
                        }
                    } else if (--cnt == 0) {
                        $this$forEach$iv = $this$onTrigger_u24lambda_u243.getListeners();
                        $i$f$forEach2 = false;
                        value$iv = $this$forEach$iv.iterator();
                        while (value$iv.hasNext()) {
                            Object element$iv = value$iv.next();
                            it = (TriggerListener)element$iv;
                            boolean bl4 = false;
                            it.onActorExited(trigger, actor);
                        }
                    }
                    Integer $i$f$forEach2 = cnt;
                    $this$onTrigger_u24lambda_u243.getActorEnterCounts().put(actor, $i$f$forEach2);
                    continue;
                }
                SimEventCallback $this$logE$iv = this;
                boolean $i$f$logE = false;
                String tag$iv$iv = Reflection.getOrCreateKotlinClass(((Object)((Object)$this$logE$iv)).getClass()).getSimpleName();
                boolean $i$f$logE2 = false;
                $this$forEach$iv = Log.INSTANCE;
                Log.Level level$iv$iv$iv = Log.Level.ERROR;
                boolean $i$f$log = false;
                if (level$iv$iv$iv.getLevel() < this_$iv$iv$iv.getLevel().getLevel()) continue;
                String string = tag$iv$iv;
                Log.Level level = level$iv$iv$iv;
                Function3 function3 = this_$iv$iv$iv.getPrinter();
                boolean bl = false;
                String string2 = "actor reference not found";
                function3.invoke((Object)level, (Object)string, (Object)string2);
            }
        }

        /*
         * WARNING - void declaration
         */
        public void onContact(@NotNull PxContactPairHeader pairHeader, @NotNull PxContactPair pairs, int nbPairs) {
            Intrinsics.checkNotNullParameter((Object)pairHeader, (String)"pairHeader");
            Intrinsics.checkNotNullParameter((Object)pairs, (String)"pairs");
            RigidActor actorA = (RigidActor)PhysicsWorld.this.pxActors.get(pairHeader.getActors(0));
            RigidActor actorB = (RigidActor)PhysicsWorld.this.pxActors.get(pairHeader.getActors(1));
            if (actorA == null || actorB == null) {
                void this_$iv$iv$iv;
                SimEventCallback $this$logW$iv = this;
                boolean $i$f$logW = false;
                String tag$iv$iv = Reflection.getOrCreateKotlinClass(((Object)((Object)$this$logW$iv)).getClass()).getSimpleName();
                boolean $i$f$logW2 = false;
                Log log = Log.INSTANCE;
                Log.Level level$iv$iv$iv = Log.Level.WARN;
                boolean $i$f$log = false;
                if (level$iv$iv$iv.getLevel() >= this_$iv$iv$iv.getLevel().getLevel()) {
                    String string = tag$iv$iv;
                    Log.Level level = level$iv$iv$iv;
                    Function3 function3 = this_$iv$iv$iv.getPrinter();
                    boolean bl = false;
                    String string2 = "onContact: actor reference not found";
                    function3.invoke((Object)level, (Object)string, (Object)string2);
                }
                return;
            }
            for (int i = 0; i < nbPairs; ++i) {
                PxContactPair pair = PxContactPair.arrayGet((long)pairs.getAddress(), (int)i);
                PxPairFlags evts = pair.getEvents();
                if (evts.isSet(PxPairFlagEnum.eNOTIFY_TOUCH_FOUND)) {
                    List contactPoints = null;
                    int pxContactPoints = pair.extractContacts(this.contacts.data(), 64);
                    if (pxContactPoints > 0) {
                        contactPoints = new ArrayList();
                        for (int iPt = 0; iPt < pxContactPoints; ++iPt) {
                            PxContactPairPoint contact = this.contacts.at(iPt);
                            Collection collection = contactPoints;
                            PxVec3 pxVec3 = contact.getPosition();
                            Intrinsics.checkNotNullExpressionValue((Object)pxVec3, (String)"contact.position");
                            Vec3f vec3f = (Vec3f)PhysXExtensionsKt.toVec3f$default(pxVec3, null, 1, null);
                            PxVec3 pxVec32 = contact.getNormal();
                            Intrinsics.checkNotNullExpressionValue((Object)pxVec32, (String)"contact.normal");
                            Vec3f vec3f2 = (Vec3f)PhysXExtensionsKt.toVec3f$default(pxVec32, null, 1, null);
                            PxVec3 pxVec33 = contact.getImpulse();
                            Intrinsics.checkNotNullExpressionValue((Object)pxVec33, (String)"contact.impulse");
                            collection.add(new ContactPoint(vec3f, vec3f2, (Vec3f)PhysXExtensionsKt.toVec3f$default(pxVec33, null, 1, null), contact.getSeparation()));
                        }
                    } else {
                        contactPoints = null;
                    }
                    PhysicsWorld.this.fireOnTouchFound(actorA, actorB, contactPoints);
                    continue;
                }
                if (!evts.isSet(PxPairFlagEnum.eNOTIFY_TOUCH_LOST)) continue;
                PhysicsWorld.this.fireOnTouchLost(actorA, actorB);
            }
        }
    }
}

