/*
 * Decompiled with CFR 0.152.
 */
package de.fabmax.kool.physics;

import de.fabmax.kool.KoolContext;
import de.fabmax.kool.physics.CommonPhysicsWorld;
import de.fabmax.kool.util.PerfTimer;
import de.fabmax.kool.util.Time;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H$J\u0016\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0006R\u001e\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0006R\u001a\u0010\u0010\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0006\"\u0004\b\u0012\u0010\b\u00a8\u0006\u0019"}, d2={"Lde/fabmax/kool/physics/PhysicsStepper;", "", "()V", "maxTimeStepPerFrame", "", "getMaxTimeStepPerFrame", "()F", "setMaxTimeStepPerFrame", "(F)V", "perf", "Lde/fabmax/kool/util/PerfTimer;", "<set-?>", "perfCpuTime", "getPerfCpuTime", "perfTimeFactor", "getPerfTimeFactor", "simTimeFactor", "getSimTimeFactor", "setSimTimeFactor", "doSimSteps", "world", "Lde/fabmax/kool/physics/CommonPhysicsWorld;", "ctx", "Lde/fabmax/kool/KoolContext;", "stepSimulation", "kool-physics"})
public abstract class PhysicsStepper {
    private float simTimeFactor = 1.0f;
    private float maxTimeStepPerFrame = 0.1f;
    @NotNull
    private final PerfTimer perf = new PerfTimer();
    private float perfCpuTime;
    private float perfTimeFactor = 1.0f;

    public final float getSimTimeFactor() {
        return this.simTimeFactor;
    }

    public final void setSimTimeFactor(float f) {
        this.simTimeFactor = f;
    }

    public final float getMaxTimeStepPerFrame() {
        return this.maxTimeStepPerFrame;
    }

    public final void setMaxTimeStepPerFrame(float f) {
        this.maxTimeStepPerFrame = f;
    }

    public final float getPerfCpuTime() {
        return this.perfCpuTime;
    }

    public final float getPerfTimeFactor() {
        return this.perfTimeFactor;
    }

    public final float stepSimulation(@NotNull CommonPhysicsWorld world, @NotNull KoolContext ctx) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        this.perf.reset();
        if (this.simTimeFactor > 0.0f) {
            float timeAdvance = this.doSimSteps(world, ctx);
            float ms = (float)this.perf.takeMs();
            this.perfCpuTime = this.perfCpuTime * 0.8f + ms * 0.2f;
            this.perfTimeFactor = this.perfTimeFactor * 0.9f + timeAdvance / (Time.INSTANCE.getDeltaT() * this.simTimeFactor) * 0.1f;
            return timeAdvance;
        }
        this.perfCpuTime = 0.0f;
        this.perfTimeFactor = 0.0f;
        return 0.0f;
    }

    protected abstract float doSimSteps(@NotNull CommonPhysicsWorld var1, @NotNull KoolContext var2);
}

