/*
 * Decompiled with CFR 0.152.
 */
package de.fabmax.kool.physics;

import de.fabmax.kool.KoolContext;
import de.fabmax.kool.physics.ConstantPhysicsStepperSync;
import de.fabmax.kool.physics.ContactListener;
import de.fabmax.kool.physics.ContactPoint;
import de.fabmax.kool.physics.Material;
import de.fabmax.kool.physics.PhysicsStepper;
import de.fabmax.kool.physics.Releasable;
import de.fabmax.kool.physics.RigidActor;
import de.fabmax.kool.physics.RigidDynamic;
import de.fabmax.kool.physics.RigidStatic;
import de.fabmax.kool.physics.Shape;
import de.fabmax.kool.physics.TriggerListener;
import de.fabmax.kool.physics.articulations.Articulation;
import de.fabmax.kool.physics.geometry.PlaneGeometry;
import de.fabmax.kool.scene.Scene;
import de.fabmax.kool.util.Log;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u000b\b&\u0018\u00002\u00020\u0001:\u0001\\B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u00109\u001a\u00020\u001b2\u0006\u0010:\u001a\u00020\u0005H\u0016J\u0010\u0010;\u001a\u00020\u001b2\u0006\u0010<\u001a\u00020\tH\u0016J\u0006\u0010=\u001a\u00020>J\u0010\u0010?\u001a\u00020\u001b2\b\b\u0002\u0010@\u001a\u00020\u0010J\b\u0010A\u001a\u00020\u001bH\u0016J(\u0010B\u001a\u00020\u001b2\u0006\u0010C\u001a\u00020\u00052\u0006\u0010D\u001a\u00020\u00052\u000e\u0010E\u001a\n\u0012\u0004\u0012\u00020F\u0018\u00010\u0004H\u0004J\u0018\u0010G\u001a\u00020\u001b2\u0006\u0010C\u001a\u00020\u00052\u0006\u0010D\u001a\u00020\u0005H\u0004J \u0010H\u001a\u00020\u00102\u0006\u0010!\u001a\u00020\"2\u0006\u0010I\u001a\u00020\"2\u0006\u0010J\u001a\u00020\u001aH\u0002J\u0010\u0010\u0018\u001a\u00020\u001b2\u0006\u0010K\u001a\u00020\u001aH\u0014J\u0010\u0010\u001d\u001a\u00020\u001b2\u0006\u0010K\u001a\u00020\u001aH\u0014J\u000e\u0010L\u001a\u00020\u001b2\u0006\u0010M\u001a\u00020\rJ\u0010\u0010N\u001a\u00020\u001b2\u0006\u0010O\u001a\u00020-H\u0016J\u0016\u0010P\u001a\u00020\u001b2\u0006\u0010Q\u001a\u00020\u00052\u0006\u0010M\u001a\u00020RJ\b\u0010S\u001a\u00020\u001bH\u0016J\u0010\u0010T\u001a\u00020\u001b2\u0006\u0010:\u001a\u00020\u0005H\u0016J\u0010\u0010U\u001a\u00020\u001b2\u0006\u0010<\u001a\u00020\tH\u0016J\u0010\u0010V\u001a\u00020\u001b2\u0006\u0010K\u001a\u00020\u001aH\u0016J\u000e\u0010W\u001a\u00020\u001b2\u0006\u0010K\u001a\u00020\u001aJ\u000e\u0010X\u001a\u00020\u001b2\u0006\u0010M\u001a\u00020\rJ\b\u0010Y\u001a\u00020\u001bH\u0016J\u000e\u0010Z\u001a\u00020\u001b2\u0006\u0010M\u001a\u00020RJ\u0006\u0010[\u001a\u00020\u001bR\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u00048F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0007R\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0007R\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0007R\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\t0\fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0007R#\u0010\u0018\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001b0\u00190\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0007R#\u0010\u001d\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001b0\u00190\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0007R\u001a\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\u001b0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010!\u001a\u00020\"X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u001a\u0010'\u001a\u00020\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\u0010\u0010,\u001a\u0004\u0018\u00010-X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010.\u001a\u00020/X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u00101\"\u0004\b2\u00103R \u00104\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020605X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u00108\u00a8\u0006]"}, d2={"Lde/fabmax/kool/physics/CommonPhysicsWorld;", "Lde/fabmax/kool/physics/Releasable;", "()V", "actors", "", "Lde/fabmax/kool/physics/RigidActor;", "getActors", "()Ljava/util/List;", "articulations", "Lde/fabmax/kool/physics/articulations/Articulation;", "getArticulations", "contactListeners", "", "Lde/fabmax/kool/physics/ContactListener;", "getContactListeners", "isStepInProgress", "", "()Z", "setStepInProgress", "(Z)V", "mutActors", "getMutActors", "mutArticulations", "getMutArticulations", "onAdvancePhysics", "Lkotlin/Function1;", "", "", "getOnAdvancePhysics", "onPhysicsUpdate", "getOnPhysicsUpdate", "onRenderSceneHook", "Lde/fabmax/kool/KoolContext;", "physicsTime", "", "getPhysicsTime", "()D", "setPhysicsTime", "(D)V", "prevStepTime", "getPrevStepTime", "()F", "setPrevStepTime", "(F)V", "registeredAtScene", "Lde/fabmax/kool/scene/Scene;", "simStepper", "Lde/fabmax/kool/physics/PhysicsStepper;", "getSimStepper", "()Lde/fabmax/kool/physics/PhysicsStepper;", "setSimStepper", "(Lde/fabmax/kool/physics/PhysicsStepper;)V", "triggerListeners", "", "Lde/fabmax/kool/physics/CommonPhysicsWorld$TriggerListenerContext;", "getTriggerListeners", "()Ljava/util/Map;", "addActor", "actor", "addArticulation", "articulation", "addDefaultGroundPlane", "Lde/fabmax/kool/physics/RigidStatic;", "clear", "releaseActors", "fetchAsyncStepResults", "fireOnTouchFound", "a", "b", "contactPoints", "Lde/fabmax/kool/physics/ContactPoint;", "fireOnTouchLost", "isContinueStep", "physicsTimeDesired", "step", "timeStep", "registerContactListener", "listener", "registerHandlers", "scene", "registerTriggerListener", "trigger", "Lde/fabmax/kool/physics/TriggerListener;", "release", "removeActor", "removeArticulation", "singleStepAsync", "singleStepSync", "unregisterContactListener", "unregisterHandlers", "unregisterTriggerListener", "wakeUpAll", "TriggerListenerContext", "kool-physics"})
@SourceDebugExtension(value={"SMAP\nPhysicsWorld.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PhysicsWorld.kt\nde/fabmax/kool/physics/CommonPhysicsWorld\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Log.kt\nde/fabmax/kool/util/LogKt\n+ 4 Log.kt\nde/fabmax/kool/util/Log\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 6 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,198:1\n1#2:199\n34#3,7:200\n16#4,4:207\n361#5,7:211\n1855#6,2:218\n1855#6,2:220\n1855#6,2:222\n*S KotlinDebug\n*F\n+ 1 PhysicsWorld.kt\nde/fabmax/kool/physics/CommonPhysicsWorld\n*L\n58#1:200,7\n58#1:207,4\n60#1:211,7\n64#1:218,2\n113#1:220,2\n118#1:222,2\n*E\n"})
public abstract class CommonPhysicsWorld
implements Releasable {
    private double physicsTime;
    @NotNull
    private PhysicsStepper simStepper = new ConstantPhysicsStepperSync(0.0f, 1, null);
    private boolean isStepInProgress;
    private float prevStepTime;
    @NotNull
    private final List<Function1<Float, Unit>> onAdvancePhysics = new ArrayList();
    @NotNull
    private final List<Function1<Float, Unit>> onPhysicsUpdate = new ArrayList();
    @NotNull
    private final List<RigidActor> mutActors = new ArrayList();
    @NotNull
    private final List<Articulation> mutArticulations = new ArrayList();
    @NotNull
    private final Map<RigidActor, TriggerListenerContext> triggerListeners = new LinkedHashMap();
    @NotNull
    private final List<ContactListener> contactListeners = new ArrayList();
    @Nullable
    private Scene registeredAtScene;
    @NotNull
    private final Function1<KoolContext, Unit> onRenderSceneHook = (Function1)new Function1<KoolContext, Unit>(this){
        final /* synthetic */ CommonPhysicsWorld this$0;
        {
            this.this$0 = $receiver;
            super(1);
        }

        public final void invoke(@NotNull KoolContext ctx) {
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            CommonPhysicsWorld commonPhysicsWorld = this.this$0;
            commonPhysicsWorld.setPhysicsTime(commonPhysicsWorld.getPhysicsTime() + (double)this.this$0.getSimStepper().stepSimulation(this.this$0, ctx));
        }
    };

    public final double getPhysicsTime() {
        return this.physicsTime;
    }

    public final void setPhysicsTime(double d) {
        this.physicsTime = d;
    }

    @NotNull
    public final PhysicsStepper getSimStepper() {
        return this.simStepper;
    }

    public final void setSimStepper(@NotNull PhysicsStepper physicsStepper) {
        Intrinsics.checkNotNullParameter((Object)physicsStepper, (String)"<set-?>");
        this.simStepper = physicsStepper;
    }

    public final boolean isStepInProgress() {
        return this.isStepInProgress;
    }

    public final void setStepInProgress(boolean bl) {
        this.isStepInProgress = bl;
    }

    public final float getPrevStepTime() {
        return this.prevStepTime;
    }

    public final void setPrevStepTime(float f) {
        this.prevStepTime = f;
    }

    @NotNull
    public final List<Function1<Float, Unit>> getOnAdvancePhysics() {
        return this.onAdvancePhysics;
    }

    @NotNull
    public final List<Function1<Float, Unit>> getOnPhysicsUpdate() {
        return this.onPhysicsUpdate;
    }

    @NotNull
    protected final List<RigidActor> getMutActors() {
        return this.mutActors;
    }

    @NotNull
    public final List<RigidActor> getActors() {
        return this.mutActors;
    }

    @NotNull
    protected final List<Articulation> getMutArticulations() {
        return this.mutArticulations;
    }

    @NotNull
    public final List<Articulation> getArticulations() {
        return this.mutArticulations;
    }

    @NotNull
    protected final Map<RigidActor, TriggerListenerContext> getTriggerListeners() {
        return this.triggerListeners;
    }

    @NotNull
    protected final List<ContactListener> getContactListeners() {
        return this.contactListeners;
    }

    public void registerHandlers(@NotNull Scene scene) {
        Intrinsics.checkNotNullParameter((Object)scene, (String)"scene");
        this.unregisterHandlers();
        this.registeredAtScene = scene;
        ((Collection)scene.getOnRenderScene()).add(this.onRenderSceneHook);
    }

    public void unregisterHandlers() {
        block0: {
            Scene scene = this.registeredAtScene;
            if (scene == null) break block0;
            Scene it = scene;
            boolean bl = false;
            ((Collection)it.getOnRenderScene()).remove(this.onRenderSceneHook);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void registerTriggerListener(@NotNull RigidActor trigger, @NotNull TriggerListener listener) {
        TriggerListenerContext triggerListenerContext;
        Intrinsics.checkNotNullParameter((Object)trigger, (String)"trigger");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        if (!trigger.isTrigger()) {
            void this_$iv$iv$iv;
            CommonPhysicsWorld $this$logW$iv = this;
            boolean $i$f$logW = false;
            String tag$iv$iv = Reflection.getOrCreateKotlinClass($this$logW$iv.getClass()).getSimpleName();
            boolean $i$f$logW2 = false;
            Log log = Log.INSTANCE;
            Log.Level level$iv$iv$iv = Log.Level.WARN;
            boolean $i$f$log = false;
            if (level$iv$iv$iv.getLevel() >= this_$iv$iv$iv.getLevel().getLevel()) {
                String string = tag$iv$iv;
                Log.Level level = level$iv$iv$iv;
                Function3 function3 = this_$iv$iv$iv.getPrinter();
                boolean bl = false;
                String string2 = "Given trigger actor is not a trigger (isTrigger == false)";
                function3.invoke((Object)level, (Object)string, (Object)string2);
            }
        }
        Map<RigidActor, TriggerListenerContext> $this$getOrPut$iv = this.triggerListeners;
        boolean $i$f$getOrPut = false;
        TriggerListenerContext value$iv = $this$getOrPut$iv.get(trigger);
        if (value$iv == null) {
            boolean bl = false;
            TriggerListenerContext answer$iv = new TriggerListenerContext();
            $this$getOrPut$iv.put(trigger, answer$iv);
            triggerListenerContext = answer$iv;
        } else {
            triggerListenerContext = value$iv;
        }
        ((Collection)triggerListenerContext.getListeners()).add(listener);
    }

    public final void unregisterTriggerListener(@NotNull TriggerListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        Iterable $this$forEach$iv = this.triggerListeners.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TriggerListenerContext it = (TriggerListenerContext)element$iv;
            boolean bl = false;
            ((Collection)it.getListeners()).remove(listener);
        }
        CollectionsKt.removeAll((Iterable)this.triggerListeners.keySet(), (Function1)((Function1)new Function1<RigidActor, Boolean>(this){
            final /* synthetic */ CommonPhysicsWorld this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull RigidActor k) {
                Intrinsics.checkNotNullParameter((Object)k, (String)"k");
                Object object = this.this$0.getTriggerListeners().get(k);
                return object != null && (object = ((TriggerListenerContext)object).getListeners()) != null ? object.isEmpty() : false;
            }
        }));
    }

    public final void registerContactListener(@NotNull ContactListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        ((Collection)this.contactListeners).add(listener);
    }

    public final void unregisterContactListener(@NotNull ContactListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        ((Collection)this.contactListeners).remove(listener);
    }

    protected final void fireOnTouchFound(@NotNull RigidActor a, @NotNull RigidActor b, @Nullable List<ContactPoint> contactPoints) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        int n = this.contactListeners.size();
        for (int i = 0; i < n; ++i) {
            this.contactListeners.get(i).onTouchFound(a, b, contactPoints);
        }
    }

    protected final void fireOnTouchLost(@NotNull RigidActor a, @NotNull RigidActor b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        int n = this.contactListeners.size();
        for (int i = 0; i < n; ++i) {
            this.contactListeners.get(i).onTouchLost(a, b);
        }
    }

    @Override
    public void release() {
        if (this.isStepInProgress) {
            this.fetchAsyncStepResults();
        }
        this.unregisterHandlers();
        this.clear(true);
    }

    public void addActor(@NotNull RigidActor actor) {
        Intrinsics.checkNotNullParameter((Object)actor, (String)"actor");
        ((Collection)this.mutActors).add(actor);
    }

    public void removeActor(@NotNull RigidActor actor) {
        Intrinsics.checkNotNullParameter((Object)actor, (String)"actor");
        ((Collection)this.mutActors).remove(actor);
    }

    public void addArticulation(@NotNull Articulation articulation) {
        Intrinsics.checkNotNullParameter((Object)articulation, (String)"articulation");
        ((Collection)this.mutArticulations).add(articulation);
    }

    public void removeArticulation(@NotNull Articulation articulation) {
        Intrinsics.checkNotNullParameter((Object)articulation, (String)"articulation");
        ((Collection)this.mutArticulations).remove(articulation);
    }

    public final void wakeUpAll() {
        Releasable it;
        Iterable $this$forEach$iv = this.getActors();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (RigidActor)element$iv;
            boolean bl = false;
            if (!(it instanceof RigidDynamic)) continue;
            ((RigidDynamic)it).wakeUp();
        }
        $this$forEach$iv = this.getArticulations();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Articulation)element$iv;
            boolean bl = false;
            ((Articulation)it).wakeUp();
        }
    }

    public final void clear(boolean releaseActors) {
        List list;
        List $this$clear_u24lambda_u246 = list = (List)new ArrayList();
        boolean bl = false;
        CollectionsKt.addAll((Collection)$this$clear_u24lambda_u246, (Iterable)this.getActors());
        List removeActors = list;
        for (int i = CollectionsKt.getLastIndex((List)removeActors); -1 < i; --i) {
            this.removeActor((RigidActor)removeActors.get(i));
            if (!releaseActors) continue;
            ((RigidActor)removeActors.get(i)).release();
        }
        List $this$clear_u24lambda_u247 = $this$clear_u24lambda_u246 = (List)new ArrayList();
        boolean bl2 = false;
        CollectionsKt.addAll((Collection)$this$clear_u24lambda_u247, (Iterable)this.getArticulations());
        List removeArticulations = $this$clear_u24lambda_u246;
        for (int i = CollectionsKt.getLastIndex((List)removeArticulations); -1 < i; --i) {
            this.removeArticulation((Articulation)removeArticulations.get(i));
            if (!releaseActors) continue;
            ((Articulation)removeArticulations.get(i)).release();
        }
        this.triggerListeners.clear();
    }

    public static /* synthetic */ void clear$default(CommonPhysicsWorld commonPhysicsWorld, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: clear");
        }
        if ((n & 1) != 0) {
            bl = true;
        }
        commonPhysicsWorld.clear(bl);
    }

    private final boolean isContinueStep(double physicsTime, double physicsTimeDesired, float step) {
        return physicsTimeDesired - physicsTime > (double)step * 0.5;
    }

    public final void singleStepSync(float timeStep) {
        this.singleStepAsync(timeStep);
        this.fetchAsyncStepResults();
    }

    public void singleStepAsync(float timeStep) {
        if (this.isStepInProgress) {
            throw new IllegalStateException("Previous simulation step not yet finished");
        }
        this.onAdvancePhysics(timeStep);
        this.isStepInProgress = true;
        this.prevStepTime = timeStep;
    }

    public void fetchAsyncStepResults() {
        this.isStepInProgress = false;
        this.onPhysicsUpdate(this.prevStepTime);
    }

    protected void onAdvancePhysics(float timeStep) {
        int n = this.onAdvancePhysics.size();
        for (int i = 0; i < n; ++i) {
            this.onAdvancePhysics.get(i).invoke((Object)Float.valueOf(timeStep));
        }
    }

    protected void onPhysicsUpdate(float timeStep) {
        int i;
        int n = this.mutActors.size();
        for (i = 0; i < n; ++i) {
            this.mutActors.get(i).onPhysicsUpdate$kool_physics(timeStep);
        }
        n = this.mutArticulations.size();
        for (i = 0; i < n; ++i) {
            this.mutArticulations.get(i).onPhysicsUpdate$kool_physics(timeStep);
        }
        n = this.onPhysicsUpdate.size();
        for (i = 0; i < n; ++i) {
            this.onPhysicsUpdate.get(i).invoke((Object)Float.valueOf(timeStep));
        }
    }

    @NotNull
    public final RigidStatic addDefaultGroundPlane() {
        RigidStatic groundPlane = new RigidStatic(null, 1, null);
        Shape shape = new Shape(new PlaneGeometry(), new Material(0.5f, 0.5f, 0.2f), null, null, null, 28, null);
        groundPlane.attachShape(shape);
        groundPlane.setRotation(0.0f, 0.0f, 90.0f);
        this.addActor(groundPlane);
        return groundPlane;
    }

    @Override
    public void dispose(@NotNull KoolContext ctx) {
        Releasable.DefaultImpls.dispose(this, ctx);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lde/fabmax/kool/physics/CommonPhysicsWorld$TriggerListenerContext;", "", "()V", "actorEnterCounts", "", "Lde/fabmax/kool/physics/RigidActor;", "", "getActorEnterCounts", "()Ljava/util/Map;", "listeners", "", "Lde/fabmax/kool/physics/TriggerListener;", "getListeners", "()Ljava/util/List;", "kool-physics"})
    protected static final class TriggerListenerContext {
        @NotNull
        private final List<TriggerListener> listeners = new ArrayList();
        @NotNull
        private final Map<RigidActor, Integer> actorEnterCounts = new LinkedHashMap();

        @NotNull
        public final List<TriggerListener> getListeners() {
            return this.listeners;
        }

        @NotNull
        public final Map<RigidActor, Integer> getActorEnterCounts() {
            return this.actorEnterCounts;
        }
    }
}

