/*
 * Decompiled with CFR 0.152.
 */
package de.fabmax.kool.physics.vehicle;

import de.fabmax.kool.math.Vec3f;
import de.fabmax.kool.physics.FilterData;
import de.fabmax.kool.physics.FilterDataBuilder;
import de.fabmax.kool.physics.FilterDataKt;
import de.fabmax.kool.physics.Material;
import de.fabmax.kool.physics.Material_desktopKt;
import de.fabmax.kool.physics.Shape;
import de.fabmax.kool.physics.geometry.CollisionGeometry;
import de.fabmax.kool.physics.geometry.CollisionGeometry_desktopKt;
import de.fabmax.kool.physics.geometry.ConvexMesh;
import de.fabmax.kool.physics.geometry.ConvexMeshGeometry;
import de.fabmax.kool.physics.geometry.ConvexMesh_desktopKt;
import de.fabmax.kool.physics.geometry.CylinderGeometry;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0011\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005J\u000e\u0010\u0007\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000fJ\u0016\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0017R\u001b\u0010\u001a\u001a\u00020\u001b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001e\u0010\u001f\u001a\u0004\b\u001c\u0010\u001dR\u000e\u0010 \u001a\u00020\u000fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u000fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u000fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u000fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u000fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u000fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u000fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\u000fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\u000fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020\u000fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020\u000fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020\u000fX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lde/fabmax/kool/physics/vehicle/VehicleUtils;", "", "<init>", "()V", "setupDrivableSurface", "Lde/fabmax/kool/physics/FilterDataBuilder;", "queryFilterData", "setupNonDrivableSurface", "defaultChassisShape", "Lde/fabmax/kool/physics/Shape;", "boxSize", "Lde/fabmax/kool/math/Vec3f;", "geometry", "Lde/fabmax/kool/physics/geometry/CollisionGeometry;", "contactFlags", "", "defaultWheelShape", "radius", "", "width", "defaultChassisMaterial", "Lde/fabmax/kool/physics/Material;", "getDefaultChassisMaterial", "()Lde/fabmax/kool/physics/Material;", "defaultWheelMaterial", "getDefaultWheelMaterial", "defaultWheelMesh", "Lde/fabmax/kool/physics/geometry/ConvexMesh;", "getDefaultWheelMesh", "()Lde/fabmax/kool/physics/geometry/ConvexMesh;", "defaultWheelMesh$delegate", "Lkotlin/Lazy;", "SURFACE_FLAG_DRIVABLE", "SURFACE_FLAG_NON_DRIVABLE", "COLLISION_FLAG_GROUND", "COLLISION_FLAG_WHEEL", "COLLISION_FLAG_CHASSIS", "COLLISION_FLAG_OBSTACLE", "COLLISION_FLAG_DRIVABLE_OBSTACLE", "COLLISION_FLAG_GROUND_AGAINST", "COLLISION_FLAG_WHEEL_AGAINST", "COLLISION_FLAG_CHASSIS_AGAINST", "COLLISION_FLAG_OBSTACLE_AGAINST", "COLLISION_FLAG_DRIVABLE_OBSTACLE_AGAINST", "kool-physics"})
public final class VehicleUtils {
    @NotNull
    public static final VehicleUtils INSTANCE = new VehicleUtils();
    @NotNull
    private static final Material defaultChassisMaterial = Material_desktopKt.Material(0.5f, 0.5f, 0.5f);
    @NotNull
    private static final Material defaultWheelMaterial = Material_desktopKt.Material(0.5f, 0.5f, 0.5f);
    @NotNull
    private static final Lazy defaultWheelMesh$delegate = LazyKt.lazy(VehicleUtils::defaultWheelMesh_delegate$lambda$3);
    public static final int SURFACE_FLAG_DRIVABLE = -65536;
    public static final int SURFACE_FLAG_NON_DRIVABLE = 65535;
    public static final int COLLISION_FLAG_GROUND = 1;
    public static final int COLLISION_FLAG_WHEEL = 2;
    public static final int COLLISION_FLAG_CHASSIS = 4;
    public static final int COLLISION_FLAG_OBSTACLE = 8;
    public static final int COLLISION_FLAG_DRIVABLE_OBSTACLE = 16;
    public static final int COLLISION_FLAG_GROUND_AGAINST = 28;
    public static final int COLLISION_FLAG_WHEEL_AGAINST = 14;
    public static final int COLLISION_FLAG_CHASSIS_AGAINST = 31;
    public static final int COLLISION_FLAG_OBSTACLE_AGAINST = 31;
    public static final int COLLISION_FLAG_DRIVABLE_OBSTACLE_AGAINST = 29;

    private VehicleUtils() {
    }

    @NotNull
    public final FilterDataBuilder setupDrivableSurface(@NotNull FilterDataBuilder queryFilterData) {
        Intrinsics.checkNotNullParameter((Object)queryFilterData, (String)"queryFilterData");
        queryFilterData.setWord3(-65536);
        return queryFilterData;
    }

    @NotNull
    public final FilterDataBuilder setupNonDrivableSurface(@NotNull FilterDataBuilder queryFilterData) {
        Intrinsics.checkNotNullParameter((Object)queryFilterData, (String)"queryFilterData");
        queryFilterData.setWord3(65535);
        return queryFilterData;
    }

    @NotNull
    public final Shape defaultChassisShape(@NotNull Vec3f boxSize) {
        Intrinsics.checkNotNullParameter((Object)boxSize, (String)"boxSize");
        return VehicleUtils.defaultChassisShape$default(this, CollisionGeometry_desktopKt.BoxGeometry(boxSize), 0, 2, null);
    }

    @NotNull
    public final Shape defaultChassisShape(@NotNull CollisionGeometry geometry, int contactFlags) {
        Intrinsics.checkNotNullParameter((Object)geometry, (String)"geometry");
        FilterData simFilterData = new FilterData(4, 31, contactFlags, 0, 8, null);
        FilterData qryFilterData = FilterDataKt.FilterData((Function1<? super FilterDataBuilder, Unit>)((Function1)VehicleUtils::defaultChassisShape$lambda$0));
        return new Shape(geometry, defaultChassisMaterial, null, simFilterData, qryFilterData, 4, null);
    }

    public static /* synthetic */ Shape defaultChassisShape$default(VehicleUtils vehicleUtils, CollisionGeometry collisionGeometry, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return vehicleUtils.defaultChassisShape(collisionGeometry, n);
    }

    @NotNull
    public final Shape defaultWheelShape(float radius, float width) {
        ConvexMesh mesh = this.getDefaultWheelMesh();
        ConvexMeshGeometry geom = CollisionGeometry_desktopKt.ConvexMeshGeometry(mesh, new Vec3f(width, radius, radius));
        FilterData simFilterData = new FilterData(2, 14, 0, 0, 12, null);
        FilterData qryFilterData = FilterDataKt.FilterData((Function1<? super FilterDataBuilder, Unit>)((Function1)VehicleUtils::defaultWheelShape$lambda$1));
        return new Shape(geom, defaultWheelMaterial, null, simFilterData, qryFilterData, 4, null);
    }

    @NotNull
    public final Material getDefaultChassisMaterial() {
        return defaultChassisMaterial;
    }

    @NotNull
    public final Material getDefaultWheelMaterial() {
        return defaultWheelMaterial;
    }

    @NotNull
    public final ConvexMesh getDefaultWheelMesh() {
        Lazy lazy = defaultWheelMesh$delegate;
        return (ConvexMesh)((Object)lazy.getValue());
    }

    private static final Unit defaultChassisShape$lambda$0(FilterDataBuilder $this$FilterData) {
        Intrinsics.checkNotNullParameter((Object)$this$FilterData, (String)"$this$FilterData");
        INSTANCE.setupNonDrivableSurface($this$FilterData);
        return Unit.INSTANCE;
    }

    private static final Unit defaultWheelShape$lambda$1(FilterDataBuilder $this$FilterData) {
        Intrinsics.checkNotNullParameter((Object)$this$FilterData, (String)"$this$FilterData");
        INSTANCE.setupNonDrivableSurface($this$FilterData);
        return Unit.INSTANCE;
    }

    private static final ConvexMesh defaultWheelMesh_delegate$lambda$3() {
        ConvexMesh convexMesh;
        ConvexMesh $this$defaultWheelMesh_delegate_u24lambda_u243_u24lambda_u242 = convexMesh = ConvexMesh_desktopKt.ConvexMesh(CylinderGeometry.Companion.convexMeshPoints$default(CylinderGeometry.Companion, 1.0f, 1.0f, 0, 4, null));
        boolean bl = false;
        $this$defaultWheelMesh_delegate_u24lambda_u243_u24lambda_u242.setReleaseWithGeometry(false);
        return convexMesh;
    }
}

