/*
 * Decompiled with CFR 0.152.
 */
package de.fabmax.kool.physics.joints;

import de.fabmax.kool.math.PoseF;
import de.fabmax.kool.math.PoseKt;
import de.fabmax.kool.physics.joints.Joint;
import de.fabmax.kool.util.BaseReleasable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import physx.physics.PxConstraintFlagEnum;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\b&\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018H\u0016J\b\u0010\u001a\u001a\u00020\u0016H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0005\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\rR$\u0010\u000f\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\r\"\u0004\b\u0010\u0010\u0011R$\u0010\u0012\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\r\"\u0004\b\u0014\u0010\u0011\u00a8\u0006\u001b"}, d2={"Lde/fabmax/kool/physics/joints/JointImpl;", "Lde/fabmax/kool/util/BaseReleasable;", "Lde/fabmax/kool/physics/joints/Joint;", "frameA", "Lde/fabmax/kool/math/PoseF;", "frameB", "<init>", "(Lde/fabmax/kool/math/PoseF;Lde/fabmax/kool/math/PoseF;)V", "getFrameA", "()Lde/fabmax/kool/math/PoseF;", "getFrameB", "isBroken", "", "()Z", "value", "isChildCollisionEnabled", "setChildCollisionEnabled", "(Z)V", "debugVisualize", "getDebugVisualize", "setDebugVisualize", "enableBreakage", "", "breakForce", "", "breakTorque", "release", "kool-physics"})
public abstract class JointImpl
extends BaseReleasable
implements Joint {
    @NotNull
    private final PoseF frameA;
    @NotNull
    private final PoseF frameB;
    private boolean isChildCollisionEnabled;
    private boolean debugVisualize;

    public JointImpl(@NotNull PoseF frameA, @NotNull PoseF frameB) {
        Intrinsics.checkNotNullParameter((Object)frameA, (String)"frameA");
        Intrinsics.checkNotNullParameter((Object)frameB, (String)"frameB");
        this.frameA = PoseKt.PoseF((PoseF)frameA);
        this.frameB = PoseKt.PoseF((PoseF)frameB);
    }

    @Override
    @NotNull
    public PoseF getFrameA() {
        return this.frameA;
    }

    @Override
    @NotNull
    public PoseF getFrameB() {
        return this.frameB;
    }

    @Override
    public boolean isBroken() {
        return this.getJoint().getConstraintFlags().isSet(PxConstraintFlagEnum.eBROKEN);
    }

    @Override
    public boolean isChildCollisionEnabled() {
        return this.isChildCollisionEnabled;
    }

    @Override
    public void setChildCollisionEnabled(boolean value) {
        this.isChildCollisionEnabled = value;
        if (value) {
            this.getJoint().setConstraintFlag(PxConstraintFlagEnum.eCOLLISION_ENABLED, true);
        } else {
            this.getJoint().setConstraintFlag(PxConstraintFlagEnum.eCOLLISION_ENABLED, false);
        }
    }

    @Override
    public boolean getDebugVisualize() {
        return this.debugVisualize;
    }

    @Override
    public void setDebugVisualize(boolean value) {
        this.debugVisualize = value;
        if (value) {
            this.getJoint().setConstraintFlag(PxConstraintFlagEnum.eVISUALIZATION, true);
        } else {
            this.getJoint().setConstraintFlag(PxConstraintFlagEnum.eVISUALIZATION, false);
        }
    }

    @Override
    public void enableBreakage(float breakForce, float breakTorque) {
        this.getJoint().setBreakForce(breakForce, breakTorque);
    }

    public void release() {
        super.release();
        this.getJoint().release();
    }

    @Override
    public void disableBreakage() {
        Joint.DefaultImpls.disableBreakage(this);
    }
}

