/*
 * Decompiled with CFR 0.152.
 */
package de.fabmax.kool.physics.joints;

import de.fabmax.kool.math.AngleF;
import de.fabmax.kool.math.AngleKt;
import de.fabmax.kool.math.MutableVec3f;
import de.fabmax.kool.math.PoseF;
import de.fabmax.kool.math.Vec3f;
import de.fabmax.kool.physics.PhysXExtensionsKt;
import de.fabmax.kool.physics.PhysicsImpl;
import de.fabmax.kool.physics.RigidActor;
import de.fabmax.kool.physics.joints.D6Joint;
import de.fabmax.kool.physics.joints.D6JointDrive;
import de.fabmax.kool.physics.joints.D6JointMotion;
import de.fabmax.kool.physics.joints.JointImpl;
import de.fabmax.kool.physics.joints.LimitBehavior;
import de.fabmax.kool.util.Log;
import de.fabmax.kool.util.LogPrinter;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.system.MemoryStack;
import physx.PxTopLevelFunctions;
import physx.common.PxTransform;
import physx.common.PxVec3;
import physx.extensions.PxD6AxisEnum;
import physx.extensions.PxD6DriveEnum;
import physx.extensions.PxD6Joint;
import physx.extensions.PxD6JointDrive;
import physx.extensions.PxD6MotionEnum;
import physx.extensions.PxJointAngularLimitPair;
import physx.extensions.PxJointLimitPyramid;
import physx.extensions.PxJointLinearLimit;
import physx.extensions.PxJointLinearLimitPair;
import physx.extensions.PxSpring;
import physx.physics.PxPhysics;
import physx.physics.PxRigidActor;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0019\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 a2\u00020\u00012\u00020\u0002:\u0001aB)\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0018\u00104\u001a\u0002052\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u00020\u0019H\u0016J \u00109\u001a\u0002052\u0006\u0010:\u001a\u0002072\u0006\u0010;\u001a\u0002072\u0006\u00108\u001a\u00020\u0019H\u0016J \u0010<\u001a\u0002052\u0006\u0010:\u001a\u0002072\u0006\u0010;\u001a\u0002072\u0006\u00108\u001a\u00020\u0019H\u0016J \u0010=\u001a\u0002052\u0006\u0010:\u001a\u0002072\u0006\u0010;\u001a\u0002072\u0006\u00108\u001a\u00020\u0019H\u0016J'\u0010>\u001a\u0002052\u0006\u0010:\u001a\u00020\u00132\u0006\u0010;\u001a\u00020\u00132\u0006\u00108\u001a\u00020\u0019H\u0016\u00a2\u0006\u0004\b?\u0010@J'\u0010A\u001a\u0002052\u0006\u0010:\u001a\u00020\u00132\u0006\u0010;\u001a\u00020\u00132\u0006\u00108\u001a\u00020\u0019H\u0016\u00a2\u0006\u0004\bB\u0010@J'\u0010C\u001a\u0002052\u0006\u0010:\u001a\u00020\u00132\u0006\u0010;\u001a\u00020\u00132\u0006\u00108\u001a\u00020\u0019H\u0016\u00a2\u0006\u0004\bD\u0010@J\b\u0010E\u001a\u000205H\u0016J\b\u0010F\u001a\u000205H\u0016J\b\u0010G\u001a\u000205H\u0016J\b\u0010H\u001a\u000205H\u0016J\b\u0010I\u001a\u000205H\u0016J\b\u0010J\u001a\u000205H\u0016J\b\u0010K\u001a\u000205H\u0016J\u0010\u0010L\u001a\u0002052\u0006\u00108\u001a\u00020\u0019H\u0002J\u0010\u0010M\u001a\u0002052\u0006\u0010N\u001a\u00020\u0007H\u0016J\u0010\u0010O\u001a\u0002052\u0006\u0010P\u001a\u00020QH\u0016J\u0010\u0010R\u001a\u0002052\u0006\u0010P\u001a\u00020QH\u0016J\u0010\u0010S\u001a\u0002052\u0006\u0010P\u001a\u00020QH\u0016J\u0010\u0010T\u001a\u0002052\u0006\u0010P\u001a\u00020QH\u0016J\u0010\u0010U\u001a\u0002052\u0006\u0010P\u001a\u00020QH\u0016J\u0010\u0010V\u001a\u0002052\u0006\u0010P\u001a\u00020QH\u0016J\b\u0010W\u001a\u000205H\u0016J\b\u0010X\u001a\u000205H\u0016J\b\u0010Y\u001a\u000205H\u0016J\b\u0010Z\u001a\u000205H\u0016J\b\u0010[\u001a\u000205H\u0016J\b\u0010\\\u001a\u000205H\u0016J\u0018\u0010]\u001a\u0002052\u0006\u0010^\u001a\u00020_2\u0006\u0010P\u001a\u00020QH\u0002J\b\u0010`\u001a\u00020\u0019H\u0002R\u0016\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0005\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0010\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0014R\u0010\u0010\u0015\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0014R\u0010\u0010\u0016\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0014R\u0010\u0010\u0017\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0014R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010 \u001a\u00020\u001f2\u0006\u0010\u001e\u001a\u00020\u001f8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R$\u0010%\u001a\u00020\u001f2\u0006\u0010\u001e\u001a\u00020\u001f8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b&\u0010\"\"\u0004\b'\u0010$R$\u0010(\u001a\u00020\u001f2\u0006\u0010\u001e\u001a\u00020\u001f8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b)\u0010\"\"\u0004\b*\u0010$R$\u0010+\u001a\u00020\u001f2\u0006\u0010\u001e\u001a\u00020\u001f8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b,\u0010\"\"\u0004\b-\u0010$R$\u0010.\u001a\u00020\u001f2\u0006\u0010\u001e\u001a\u00020\u001f8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b/\u0010\"\"\u0004\b0\u0010$R$\u00101\u001a\u00020\u001f2\u0006\u0010\u001e\u001a\u00020\u001f8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b2\u0010\"\"\u0004\b3\u0010$\u00a8\u0006b"}, d2={"Lde/fabmax/kool/physics/joints/D6JointImpl;", "Lde/fabmax/kool/physics/joints/JointImpl;", "Lde/fabmax/kool/physics/joints/D6Joint;", "bodyA", "Lde/fabmax/kool/physics/RigidActor;", "bodyB", "frameA", "Lde/fabmax/kool/math/PoseF;", "frameB", "<init>", "(Lde/fabmax/kool/physics/RigidActor;Lde/fabmax/kool/physics/RigidActor;Lde/fabmax/kool/math/PoseF;Lde/fabmax/kool/math/PoseF;)V", "getBodyA", "()Lde/fabmax/kool/physics/RigidActor;", "getBodyB", "joint", "Lphysx/extensions/PxD6Joint;", "getJoint", "()Lphysx/extensions/PxD6Joint;", "yAngularLimitMin", "Lde/fabmax/kool/math/AngleF;", "F", "yAngularLimitMax", "zAngularLimitMin", "zAngularLimitMax", "limitBehaviorAngularY", "Lde/fabmax/kool/physics/joints/LimitBehavior;", "limitBehaviorAngularZ", "targetDriveVelLinear", "Lde/fabmax/kool/math/MutableVec3f;", "targetDriveVelAngular", "value", "Lde/fabmax/kool/physics/joints/D6JointMotion;", "linearMotionX", "getLinearMotionX", "()Lde/fabmax/kool/physics/joints/D6JointMotion;", "setLinearMotionX", "(Lde/fabmax/kool/physics/joints/D6JointMotion;)V", "linearMotionY", "getLinearMotionY", "setLinearMotionY", "linearMotionZ", "getLinearMotionZ", "setLinearMotionZ", "angularMotionX", "getAngularMotionX", "setAngularMotionX", "angularMotionY", "getAngularMotionY", "setAngularMotionY", "angularMotionZ", "getAngularMotionZ", "setAngularMotionZ", "enableDistanceLimit", "", "extend", "", "limitBehavior", "enableLinearLimitX", "lowerLimit", "upperLimit", "enableLinearLimitY", "enableLinearLimitZ", "enableAngularLimitX", "enableAngularLimitX-YB5ZWDQ", "(FFLde/fabmax/kool/physics/joints/LimitBehavior;)V", "enableAngularLimitY", "enableAngularLimitY-YB5ZWDQ", "enableAngularLimitZ", "enableAngularLimitZ-YB5ZWDQ", "disableDistanceLimit", "disableLinearLimitX", "disableLinearLimitY", "disableLinearLimitZ", "disableAngularLimitX", "disableAngularLimitY", "disableAngularLimitZ", "updateAngularLimitYZ", "setDriveTargetPose", "target", "enableLinearDriveX", "drive", "Lde/fabmax/kool/physics/joints/D6JointDrive;", "enableLinearDriveY", "enableLinearDriveZ", "enableAngularDriveX", "enableAngularDriveY", "enableAngularDriveZ", "disableLinearDriveX", "disableLinearDriveY", "disableLinearDriveZ", "disableAngularDriveX", "disableAngularDriveY", "disableAngularDriveZ", "setDrive", "index", "Lphysx/extensions/PxD6DriveEnum;", "getLimitBehaviorAngularYZ", "Companion", "kool-physics"})
@SourceDebugExtension(value={"SMAP\nD6Joint.desktop.kt\nKotlin\n*S Kotlin\n*F\n+ 1 D6Joint.desktop.kt\nde/fabmax/kool/physics/joints/D6JointImpl\n+ 2 LwjglExtensions.kt\nde/fabmax/kool/util/LwjglExtensionsKt\n+ 3 Log.kt\nde/fabmax/kool/util/LogKt\n+ 4 Log.kt\nde/fabmax/kool/util/Log\n*L\n1#1,316:1\n17#2,8:317\n17#2,8:325\n17#2,8:333\n17#2,8:341\n17#2,8:349\n17#2,8:379\n17#2,8:387\n17#2,8:395\n17#2,8:403\n17#2,8:411\n17#2,8:419\n17#2,8:427\n17#2,8:435\n40#3,7:357\n40#3,7:368\n18#4,4:364\n18#4,4:375\n*S KotlinDebug\n*F\n+ 1 D6Joint.desktop.kt\nde/fabmax/kool/physics/joints/D6JointImpl\n*L\n67#1:317,8\n77#1:325,8\n88#1:333,8\n99#1:341,8\n110#1:349,8\n143#1:379,8\n151#1:387,8\n160#1:395,8\n170#1:403,8\n179#1:411,8\n202#1:419,8\n215#1:427,8\n281#1:435,8\n127#1:357,7\n138#1:368,7\n127#1:364,4\n138#1:375,4\n*E\n"})
public final class D6JointImpl
extends JointImpl
implements D6Joint {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final RigidActor bodyA;
    @NotNull
    private final RigidActor bodyB;
    @NotNull
    private final PxD6Joint joint;
    private float yAngularLimitMin;
    private float yAngularLimitMax;
    private float zAngularLimitMin;
    private float zAngularLimitMax;
    @Nullable
    private LimitBehavior limitBehaviorAngularY;
    @Nullable
    private LimitBehavior limitBehaviorAngularZ;
    @NotNull
    private final MutableVec3f targetDriveVelLinear;
    @NotNull
    private final MutableVec3f targetDriveVelAngular;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public D6JointImpl(@Nullable RigidActor bodyA, @NotNull RigidActor bodyB, @NotNull PoseF frameA, @NotNull PoseF frameB) {
        Intrinsics.checkNotNullParameter((Object)bodyB, (String)"bodyB");
        Intrinsics.checkNotNullParameter((Object)frameA, (String)"frameA");
        Intrinsics.checkNotNullParameter((Object)frameB, (String)"frameB");
        super(frameA, frameB);
        this.bodyA = bodyA;
        this.bodyB = bodyB;
        this.yAngularLimitMin = AngleKt.getRad((float)0.0f);
        this.yAngularLimitMax = AngleKt.getRad((float)0.0f);
        this.zAngularLimitMin = AngleKt.getRad((float)0.0f);
        this.zAngularLimitMax = AngleKt.getRad((float)0.0f);
        this.targetDriveVelLinear = new MutableVec3f();
        this.targetDriveVelAngular = new MutableVec3f();
        AutoCloseable autoCloseable = (AutoCloseable)MemoryStack.stackPush();
        Throwable throwable = null;
        try {
            MemoryStack mem = (MemoryStack)autoCloseable;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)mem);
            PxTransform pxTransform = PhysXExtensionsKt.createPxTransform(mem);
            Intrinsics.checkNotNullExpressionValue((Object)pxTransform, (String)"createPxTransform(...)");
            PxTransform frmA = PhysXExtensionsKt.toPxTransform(frameA, pxTransform);
            PxTransform pxTransform2 = PhysXExtensionsKt.createPxTransform(mem);
            Intrinsics.checkNotNullExpressionValue((Object)pxTransform2, (String)"createPxTransform(...)");
            PxTransform frmB = PhysXExtensionsKt.toPxTransform(frameB, pxTransform2);
            RigidActor rigidActor = this.getBodyA();
            PxD6Joint pxD6Joint = PxTopLevelFunctions.D6JointCreate((PxPhysics)PhysicsImpl.INSTANCE.getPhysics(), (PxRigidActor)(rigidActor != null ? rigidActor.getHolder() : null), (PxTransform)frmA, (PxRigidActor)this.getBodyB().getHolder(), (PxTransform)frmB);
            Intrinsics.checkNotNullExpressionValue((Object)pxD6Joint, (String)"D6JointCreate(...)");
            this.joint = pxD6Joint;
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    @Override
    @Nullable
    public RigidActor getBodyA() {
        return this.bodyA;
    }

    @Override
    @NotNull
    public RigidActor getBodyB() {
        return this.bodyB;
    }

    @NotNull
    public PxD6Joint getJoint() {
        return this.joint;
    }

    @Override
    @NotNull
    public D6JointMotion getLinearMotionX() {
        PxD6MotionEnum pxD6MotionEnum = this.getJoint().getMotion(PxD6AxisEnum.eX);
        Intrinsics.checkNotNullExpressionValue((Object)pxD6MotionEnum, (String)"getMotion(...)");
        return D6JointImpl.Companion.toD6JointMotion(pxD6MotionEnum);
    }

    @Override
    public void setLinearMotionX(@NotNull D6JointMotion value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        this.getJoint().setMotion(PxD6AxisEnum.eX, D6JointImpl.Companion.toPxD6MotionEnum(value));
    }

    @Override
    @NotNull
    public D6JointMotion getLinearMotionY() {
        PxD6MotionEnum pxD6MotionEnum = this.getJoint().getMotion(PxD6AxisEnum.eY);
        Intrinsics.checkNotNullExpressionValue((Object)pxD6MotionEnum, (String)"getMotion(...)");
        return D6JointImpl.Companion.toD6JointMotion(pxD6MotionEnum);
    }

    @Override
    public void setLinearMotionY(@NotNull D6JointMotion value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        this.getJoint().setMotion(PxD6AxisEnum.eY, D6JointImpl.Companion.toPxD6MotionEnum(value));
    }

    @Override
    @NotNull
    public D6JointMotion getLinearMotionZ() {
        PxD6MotionEnum pxD6MotionEnum = this.getJoint().getMotion(PxD6AxisEnum.eZ);
        Intrinsics.checkNotNullExpressionValue((Object)pxD6MotionEnum, (String)"getMotion(...)");
        return D6JointImpl.Companion.toD6JointMotion(pxD6MotionEnum);
    }

    @Override
    public void setLinearMotionZ(@NotNull D6JointMotion value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        this.getJoint().setMotion(PxD6AxisEnum.eZ, D6JointImpl.Companion.toPxD6MotionEnum(value));
    }

    @Override
    @NotNull
    public D6JointMotion getAngularMotionX() {
        PxD6MotionEnum pxD6MotionEnum = this.getJoint().getMotion(PxD6AxisEnum.eTWIST);
        Intrinsics.checkNotNullExpressionValue((Object)pxD6MotionEnum, (String)"getMotion(...)");
        return D6JointImpl.Companion.toD6JointMotion(pxD6MotionEnum);
    }

    @Override
    public void setAngularMotionX(@NotNull D6JointMotion value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        this.getJoint().setMotion(PxD6AxisEnum.eTWIST, D6JointImpl.Companion.toPxD6MotionEnum(value));
    }

    @Override
    @NotNull
    public D6JointMotion getAngularMotionY() {
        PxD6MotionEnum pxD6MotionEnum = this.getJoint().getMotion(PxD6AxisEnum.eSWING1);
        Intrinsics.checkNotNullExpressionValue((Object)pxD6MotionEnum, (String)"getMotion(...)");
        return D6JointImpl.Companion.toD6JointMotion(pxD6MotionEnum);
    }

    @Override
    public void setAngularMotionY(@NotNull D6JointMotion value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        this.getJoint().setMotion(PxD6AxisEnum.eSWING1, D6JointImpl.Companion.toPxD6MotionEnum(value));
    }

    @Override
    @NotNull
    public D6JointMotion getAngularMotionZ() {
        PxD6MotionEnum pxD6MotionEnum = this.getJoint().getMotion(PxD6AxisEnum.eSWING2);
        Intrinsics.checkNotNullExpressionValue((Object)pxD6MotionEnum, (String)"getMotion(...)");
        return D6JointImpl.Companion.toD6JointMotion(pxD6MotionEnum);
    }

    @Override
    public void setAngularMotionZ(@NotNull D6JointMotion value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        this.getJoint().setMotion(PxD6AxisEnum.eSWING2, D6JointImpl.Companion.toPxD6MotionEnum(value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enableDistanceLimit(float extend, @NotNull LimitBehavior limitBehavior) {
        Intrinsics.checkNotNullParameter((Object)limitBehavior, (String)"limitBehavior");
        Object parent$iv = null;
        boolean $i$f$memStack = false;
        MemoryStack memoryStack = MemoryStack.stackPush();
        Intrinsics.checkNotNullExpressionValue((Object)memoryStack, (String)"stackPush(...)");
        try (MemoryStack stack$iv = memoryStack;){
            MemoryStack $this$enableDistanceLimit_u24lambda_u241 = stack$iv;
            boolean bl = false;
            PxSpring spring = PxSpring.createAt((Object)$this$enableDistanceLimit_u24lambda_u241, MemoryStack::nmalloc, (float)limitBehavior.getStiffness(), (float)limitBehavior.getDamping());
            PxJointLinearLimit limit = PxJointLinearLimit.createAt((Object)$this$enableDistanceLimit_u24lambda_u241, MemoryStack::nmalloc, (float)extend, (PxSpring)spring);
            limit.setRestitution(limitBehavior.getRestitution());
            limit.setBounceThreshold(limitBehavior.getBounceThreshold());
            this.getJoint().setDistanceLimit(limit);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enableLinearLimitX(float lowerLimit, float upperLimit, @NotNull LimitBehavior limitBehavior) {
        Intrinsics.checkNotNullParameter((Object)limitBehavior, (String)"limitBehavior");
        Object parent$iv = null;
        boolean $i$f$memStack = false;
        MemoryStack memoryStack = MemoryStack.stackPush();
        Intrinsics.checkNotNullExpressionValue((Object)memoryStack, (String)"stackPush(...)");
        try (MemoryStack stack$iv = memoryStack;){
            MemoryStack $this$enableLinearLimitX_u24lambda_u242 = stack$iv;
            boolean bl = false;
            PxSpring spring = PxSpring.createAt((Object)$this$enableLinearLimitX_u24lambda_u242, MemoryStack::nmalloc, (float)limitBehavior.getStiffness(), (float)limitBehavior.getDamping());
            PxJointLinearLimitPair limit = PxJointLinearLimitPair.createAt((Object)$this$enableLinearLimitX_u24lambda_u242, MemoryStack::nmalloc, (float)lowerLimit, (float)upperLimit, (PxSpring)spring);
            limit.setRestitution(limitBehavior.getRestitution());
            limit.setBounceThreshold(limitBehavior.getBounceThreshold());
            this.getJoint().setLinearLimit(PxD6AxisEnum.eX, limit);
            this.setLinearMotionX(D6JointMotion.Limited);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enableLinearLimitY(float lowerLimit, float upperLimit, @NotNull LimitBehavior limitBehavior) {
        Intrinsics.checkNotNullParameter((Object)limitBehavior, (String)"limitBehavior");
        Object parent$iv = null;
        boolean $i$f$memStack = false;
        MemoryStack memoryStack = MemoryStack.stackPush();
        Intrinsics.checkNotNullExpressionValue((Object)memoryStack, (String)"stackPush(...)");
        try (MemoryStack stack$iv = memoryStack;){
            MemoryStack $this$enableLinearLimitY_u24lambda_u243 = stack$iv;
            boolean bl = false;
            PxSpring spring = PxSpring.createAt((Object)$this$enableLinearLimitY_u24lambda_u243, MemoryStack::nmalloc, (float)limitBehavior.getStiffness(), (float)limitBehavior.getDamping());
            PxJointLinearLimitPair limit = PxJointLinearLimitPair.createAt((Object)$this$enableLinearLimitY_u24lambda_u243, MemoryStack::nmalloc, (float)lowerLimit, (float)upperLimit, (PxSpring)spring);
            limit.setRestitution(limitBehavior.getRestitution());
            limit.setBounceThreshold(limitBehavior.getBounceThreshold());
            this.getJoint().setLinearLimit(PxD6AxisEnum.eY, limit);
            this.setLinearMotionY(D6JointMotion.Limited);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enableLinearLimitZ(float lowerLimit, float upperLimit, @NotNull LimitBehavior limitBehavior) {
        Intrinsics.checkNotNullParameter((Object)limitBehavior, (String)"limitBehavior");
        Object parent$iv = null;
        boolean $i$f$memStack = false;
        MemoryStack memoryStack = MemoryStack.stackPush();
        Intrinsics.checkNotNullExpressionValue((Object)memoryStack, (String)"stackPush(...)");
        try (MemoryStack stack$iv = memoryStack;){
            MemoryStack $this$enableLinearLimitZ_u24lambda_u244 = stack$iv;
            boolean bl = false;
            PxSpring spring = PxSpring.createAt((Object)$this$enableLinearLimitZ_u24lambda_u244, MemoryStack::nmalloc, (float)limitBehavior.getStiffness(), (float)limitBehavior.getDamping());
            PxJointLinearLimitPair limit = PxJointLinearLimitPair.createAt((Object)$this$enableLinearLimitZ_u24lambda_u244, MemoryStack::nmalloc, (float)lowerLimit, (float)upperLimit, (PxSpring)spring);
            limit.setRestitution(limitBehavior.getRestitution());
            limit.setBounceThreshold(limitBehavior.getBounceThreshold());
            this.getJoint().setLinearLimit(PxD6AxisEnum.eZ, limit);
            this.setLinearMotionZ(D6JointMotion.Limited);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enableAngularLimitX-YB5ZWDQ(float lowerLimit, float upperLimit, @NotNull LimitBehavior limitBehavior) {
        Intrinsics.checkNotNullParameter((Object)limitBehavior, (String)"limitBehavior");
        Object parent$iv = null;
        boolean $i$f$memStack = false;
        MemoryStack memoryStack = MemoryStack.stackPush();
        Intrinsics.checkNotNullExpressionValue((Object)memoryStack, (String)"stackPush(...)");
        try (MemoryStack stack$iv = memoryStack;){
            MemoryStack $this$enableAngularLimitX_YB5ZWDQ_u24lambda_u245 = stack$iv;
            boolean bl = false;
            PxSpring spring = PxSpring.createAt((Object)$this$enableAngularLimitX_YB5ZWDQ_u24lambda_u245, MemoryStack::nmalloc, (float)limitBehavior.getStiffness(), (float)limitBehavior.getDamping());
            PxJointAngularLimitPair limit = PxJointAngularLimitPair.createAt((Object)$this$enableAngularLimitX_YB5ZWDQ_u24lambda_u245, MemoryStack::nmalloc, (float)lowerLimit, (float)upperLimit, (PxSpring)spring);
            limit.setRestitution(limitBehavior.getRestitution());
            limit.setBounceThreshold(limitBehavior.getBounceThreshold());
            this.getJoint().setTwistLimit(limit);
            this.setAngularMotionX(D6JointMotion.Limited);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void enableAngularLimitY-YB5ZWDQ(float lowerLimit, float upperLimit, @NotNull LimitBehavior limitBehavior) {
        Intrinsics.checkNotNullParameter((Object)limitBehavior, (String)"limitBehavior");
        this.limitBehaviorAngularY = limitBehavior;
        this.yAngularLimitMin = lowerLimit;
        this.yAngularLimitMax = upperLimit;
        LimitBehavior mergedLimit = this.getLimitBehaviorAngularYZ();
        this.updateAngularLimitYZ(mergedLimit);
        if (!Intrinsics.areEqual((Object)mergedLimit, (Object)limitBehavior)) {
            void this_$iv$iv$iv;
            D6JointImpl $this$logW$iv = this;
            boolean $i$f$logW = false;
            String tag$iv$iv = Reflection.getOrCreateKotlinClass($this$logW$iv.getClass()).getSimpleName();
            boolean $i$f$logW2 = false;
            Log log = Log.INSTANCE;
            Log.Level level$iv$iv$iv = Log.Level.WARN;
            boolean $i$f$log = false;
            if (level$iv$iv$iv.getLevel() >= this_$iv$iv$iv.getLevel().getLevel()) {
                String string = tag$iv$iv;
                Log.Level level = level$iv$iv$iv;
                LogPrinter logPrinter = this_$iv$iv$iv.getPrinter();
                boolean bl = false;
                String string2 = "Conflicting limit behaviors for angular y and angular z limit, merged limit behavior: " + mergedLimit;
                logPrinter.print(level, string, string2);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void enableAngularLimitZ-YB5ZWDQ(float lowerLimit, float upperLimit, @NotNull LimitBehavior limitBehavior) {
        Intrinsics.checkNotNullParameter((Object)limitBehavior, (String)"limitBehavior");
        this.limitBehaviorAngularZ = limitBehavior;
        this.zAngularLimitMin = lowerLimit;
        this.zAngularLimitMax = upperLimit;
        LimitBehavior mergedLimit = this.getLimitBehaviorAngularYZ();
        this.updateAngularLimitYZ(mergedLimit);
        if (!Intrinsics.areEqual((Object)mergedLimit, (Object)limitBehavior)) {
            void this_$iv$iv$iv;
            D6JointImpl $this$logW$iv = this;
            boolean $i$f$logW = false;
            String tag$iv$iv = Reflection.getOrCreateKotlinClass($this$logW$iv.getClass()).getSimpleName();
            boolean $i$f$logW2 = false;
            Log log = Log.INSTANCE;
            Log.Level level$iv$iv$iv = Log.Level.WARN;
            boolean $i$f$log = false;
            if (level$iv$iv$iv.getLevel() >= this_$iv$iv$iv.getLevel().getLevel()) {
                String string = tag$iv$iv;
                Log.Level level = level$iv$iv$iv;
                LogPrinter logPrinter = this_$iv$iv$iv.getPrinter();
                boolean bl = false;
                String string2 = "Conflicting limit behaviors for angular y and angular z limit, merged limit behavior: " + mergedLimit;
                logPrinter.print(level, string, string2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disableDistanceLimit() {
        Object parent$iv = null;
        boolean $i$f$memStack = false;
        MemoryStack memoryStack = MemoryStack.stackPush();
        Intrinsics.checkNotNullExpressionValue((Object)memoryStack, (String)"stackPush(...)");
        try (MemoryStack stack$iv = memoryStack;){
            MemoryStack $this$disableDistanceLimit_u24lambda_u248 = stack$iv;
            boolean bl = false;
            PxSpring spring = PxSpring.createAt((Object)$this$disableDistanceLimit_u24lambda_u248, MemoryStack::nmalloc, (float)0.0f, (float)0.0f);
            PxJointLinearLimit limit = PxJointLinearLimit.createAt((Object)$this$disableDistanceLimit_u24lambda_u248, MemoryStack::nmalloc, (float)Float.MAX_VALUE, (PxSpring)spring);
            this.getJoint().setDistanceLimit(limit);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disableLinearLimitX() {
        Object parent$iv = null;
        boolean $i$f$memStack = false;
        MemoryStack memoryStack = MemoryStack.stackPush();
        Intrinsics.checkNotNullExpressionValue((Object)memoryStack, (String)"stackPush(...)");
        try (MemoryStack stack$iv = memoryStack;){
            MemoryStack $this$disableLinearLimitX_u24lambda_u249 = stack$iv;
            boolean bl = false;
            PxSpring spring = PxSpring.createAt((Object)$this$disableLinearLimitX_u24lambda_u249, MemoryStack::nmalloc, (float)0.0f, (float)0.0f);
            PxJointLinearLimitPair limit = PxJointLinearLimitPair.createAt((Object)$this$disableLinearLimitX_u24lambda_u249, MemoryStack::nmalloc, (float)0.0f, (float)Float.MAX_VALUE, (PxSpring)spring);
            this.getJoint().setLinearLimit(PxD6AxisEnum.eX, limit);
            this.setLinearMotionX(D6JointMotion.Free);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disableLinearLimitY() {
        Object parent$iv = null;
        boolean $i$f$memStack = false;
        MemoryStack memoryStack = MemoryStack.stackPush();
        Intrinsics.checkNotNullExpressionValue((Object)memoryStack, (String)"stackPush(...)");
        try (MemoryStack stack$iv = memoryStack;){
            MemoryStack $this$disableLinearLimitY_u24lambda_u2410 = stack$iv;
            boolean bl = false;
            PxSpring spring = PxSpring.createAt((Object)$this$disableLinearLimitY_u24lambda_u2410, MemoryStack::nmalloc, (float)0.0f, (float)0.0f);
            PxJointLinearLimitPair limit = PxJointLinearLimitPair.createAt((Object)$this$disableLinearLimitY_u24lambda_u2410, MemoryStack::nmalloc, (float)0.0f, (float)Float.MAX_VALUE, (PxSpring)spring);
            this.getJoint().setLinearLimit(PxD6AxisEnum.eY, limit);
            this.setLinearMotionY(D6JointMotion.Free);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disableLinearLimitZ() {
        Object parent$iv = null;
        boolean $i$f$memStack = false;
        MemoryStack memoryStack = MemoryStack.stackPush();
        Intrinsics.checkNotNullExpressionValue((Object)memoryStack, (String)"stackPush(...)");
        try (MemoryStack stack$iv = memoryStack;){
            MemoryStack $this$disableLinearLimitZ_u24lambda_u2411 = stack$iv;
            boolean bl = false;
            PxSpring spring = PxSpring.createAt((Object)$this$disableLinearLimitZ_u24lambda_u2411, MemoryStack::nmalloc, (float)0.0f, (float)0.0f);
            PxJointLinearLimitPair limit = PxJointLinearLimitPair.createAt((Object)$this$disableLinearLimitZ_u24lambda_u2411, MemoryStack::nmalloc, (float)0.0f, (float)Float.MAX_VALUE, (PxSpring)spring);
            this.getJoint().setLinearLimit(PxD6AxisEnum.eZ, limit);
            this.setLinearMotionZ(D6JointMotion.Free);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disableAngularLimitX() {
        Object parent$iv = null;
        boolean $i$f$memStack = false;
        MemoryStack memoryStack = MemoryStack.stackPush();
        Intrinsics.checkNotNullExpressionValue((Object)memoryStack, (String)"stackPush(...)");
        try (MemoryStack stack$iv = memoryStack;){
            MemoryStack $this$disableAngularLimitX_u24lambda_u2412 = stack$iv;
            boolean bl = false;
            PxSpring spring = PxSpring.createAt((Object)$this$disableAngularLimitX_u24lambda_u2412, MemoryStack::nmalloc, (float)0.0f, (float)0.0f);
            PxJointAngularLimitPair limit = PxJointAngularLimitPair.createAt((Object)$this$disableAngularLimitX_u24lambda_u2412, MemoryStack::nmalloc, (float)((float)Math.PI * -2), (float)((float)Math.PI * 2), (PxSpring)spring);
            this.getJoint().setTwistLimit(limit);
            this.setAngularMotionX(D6JointMotion.Free);
            Unit unit = Unit.INSTANCE;
        }
    }

    @Override
    public void disableAngularLimitY() {
        this.limitBehaviorAngularY = null;
        this.yAngularLimitMin = AngleF.unaryMinus-H2B9tyM((float)AngleKt.getRad((float)((float)Math.PI)));
        this.yAngularLimitMax = AngleKt.getRad((float)((float)Math.PI));
        this.updateAngularLimitYZ(this.getLimitBehaviorAngularYZ());
    }

    @Override
    public void disableAngularLimitZ() {
        this.limitBehaviorAngularZ = null;
        this.zAngularLimitMin = AngleF.unaryMinus-H2B9tyM((float)AngleKt.getRad((float)((float)Math.PI)));
        this.zAngularLimitMax = AngleKt.getRad((float)((float)Math.PI));
        this.updateAngularLimitYZ(this.getLimitBehaviorAngularYZ());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void updateAngularLimitYZ(LimitBehavior limitBehavior) {
        Object parent$iv = null;
        boolean $i$f$memStack = false;
        MemoryStack memoryStack = MemoryStack.stackPush();
        Intrinsics.checkNotNullExpressionValue((Object)memoryStack, (String)"stackPush(...)");
        try (MemoryStack stack$iv = memoryStack;){
            MemoryStack $this$updateAngularLimitYZ_u24lambda_u2413 = stack$iv;
            boolean bl = false;
            PxSpring spring = PxSpring.createAt((Object)$this$updateAngularLimitYZ_u24lambda_u2413, MemoryStack::nmalloc, (float)limitBehavior.getStiffness(), (float)limitBehavior.getDamping());
            PxJointLimitPyramid limit = PxJointLimitPyramid.createAt((Object)$this$updateAngularLimitYZ_u24lambda_u2413, MemoryStack::nmalloc, (float)this.yAngularLimitMin, (float)this.yAngularLimitMax, (float)this.zAngularLimitMin, (float)this.zAngularLimitMax, (PxSpring)spring);
            limit.setRestitution(limitBehavior.getRestitution());
            limit.setBounceThreshold(limitBehavior.getBounceThreshold());
            this.getJoint().setPyramidSwingLimit(limit);
            this.setAngularMotionZ(D6JointMotion.Limited);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDriveTargetPose(@NotNull PoseF target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Object parent$iv = null;
        boolean $i$f$memStack = false;
        MemoryStack memoryStack = MemoryStack.stackPush();
        Intrinsics.checkNotNullExpressionValue((Object)memoryStack, (String)"stackPush(...)");
        try (MemoryStack stack$iv = memoryStack;){
            MemoryStack $this$setDriveTargetPose_u24lambda_u2414 = stack$iv;
            boolean bl = false;
            PxD6Joint pxD6Joint = this.getJoint();
            PxTransform pxTransform = PhysXExtensionsKt.createPxTransform($this$setDriveTargetPose_u24lambda_u2414);
            Intrinsics.checkNotNullExpressionValue((Object)pxTransform, (String)"createPxTransform(...)");
            pxD6Joint.setDrivePosition(PhysXExtensionsKt.toPxTransform(target, pxTransform), true);
            Unit unit = Unit.INSTANCE;
        }
    }

    @Override
    public void enableLinearDriveX(@NotNull D6JointDrive drive) {
        Intrinsics.checkNotNullParameter((Object)drive, (String)"drive");
        this.targetDriveVelLinear.setX(drive.getTargetVelocity());
        this.setDrive(PxD6DriveEnum.eX, drive);
    }

    @Override
    public void enableLinearDriveY(@NotNull D6JointDrive drive) {
        Intrinsics.checkNotNullParameter((Object)drive, (String)"drive");
        this.targetDriveVelLinear.setY(drive.getTargetVelocity());
        this.setDrive(PxD6DriveEnum.eY, drive);
    }

    @Override
    public void enableLinearDriveZ(@NotNull D6JointDrive drive) {
        Intrinsics.checkNotNullParameter((Object)drive, (String)"drive");
        this.targetDriveVelLinear.setZ(drive.getTargetVelocity());
        this.setDrive(PxD6DriveEnum.eX, drive);
    }

    @Override
    public void enableAngularDriveX(@NotNull D6JointDrive drive) {
        Intrinsics.checkNotNullParameter((Object)drive, (String)"drive");
        this.targetDriveVelAngular.setX(drive.getTargetVelocity());
        this.setDrive(PxD6DriveEnum.eTWIST, drive);
    }

    @Override
    public void enableAngularDriveY(@NotNull D6JointDrive drive) {
        Intrinsics.checkNotNullParameter((Object)drive, (String)"drive");
        this.targetDriveVelAngular.setY(drive.getTargetVelocity());
        this.setDrive(PxD6DriveEnum.eSWING, drive);
    }

    @Override
    public void enableAngularDriveZ(@NotNull D6JointDrive drive) {
        Intrinsics.checkNotNullParameter((Object)drive, (String)"drive");
        this.targetDriveVelAngular.setZ(drive.getTargetVelocity());
        this.setDrive(PxD6DriveEnum.eSWING, drive);
    }

    @Override
    public void disableLinearDriveX() {
        this.targetDriveVelLinear.setX(0.0f);
        this.setDrive(PxD6DriveEnum.eX, new D6JointDrive(0.0f, 0.0f, 0.0f, 0.0f, false, 16, null));
    }

    @Override
    public void disableLinearDriveY() {
        this.targetDriveVelLinear.setY(0.0f);
        this.setDrive(PxD6DriveEnum.eY, new D6JointDrive(0.0f, 0.0f, 0.0f, 0.0f, false, 16, null));
    }

    @Override
    public void disableLinearDriveZ() {
        this.targetDriveVelLinear.setZ(0.0f);
        this.setDrive(PxD6DriveEnum.eZ, new D6JointDrive(0.0f, 0.0f, 0.0f, 0.0f, false, 16, null));
    }

    @Override
    public void disableAngularDriveX() {
        this.targetDriveVelAngular.setX(0.0f);
        this.setDrive(PxD6DriveEnum.eTWIST, new D6JointDrive(0.0f, 0.0f, 0.0f, 0.0f, false, 16, null));
    }

    @Override
    public void disableAngularDriveY() {
        this.targetDriveVelAngular.setY(0.0f);
        this.setDrive(PxD6DriveEnum.eSWING, new D6JointDrive(0.0f, 0.0f, 0.0f, 0.0f, false, 16, null));
    }

    @Override
    public void disableAngularDriveZ() {
        this.targetDriveVelAngular.setY(0.0f);
        this.setDrive(PxD6DriveEnum.eSWING, new D6JointDrive(0.0f, 0.0f, 0.0f, 0.0f, false, 16, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void setDrive(PxD6DriveEnum index, D6JointDrive drive) {
        Object parent$iv = null;
        boolean $i$f$memStack = false;
        MemoryStack memoryStack = MemoryStack.stackPush();
        Intrinsics.checkNotNullExpressionValue((Object)memoryStack, (String)"stackPush(...)");
        try (MemoryStack stack$iv = memoryStack;){
            MemoryStack $this$setDrive_u24lambda_u2415 = stack$iv;
            boolean bl = false;
            PxD6JointDrive pxDrive = new PxD6JointDrive(drive.getStiffness(), drive.getDamping(), drive.getForceLimit(), drive.isAcceleration());
            this.getJoint().setDrive(index, pxDrive);
            pxDrive.destroy();
            Vec3f vec3f = (Vec3f)this.targetDriveVelLinear;
            PxVec3 pxVec3 = PhysXExtensionsKt.createPxVec3($this$setDrive_u24lambda_u2415);
            Intrinsics.checkNotNullExpressionValue((Object)pxVec3, (String)"createPxVec3(...)");
            PxVec3 linearVel = PhysXExtensionsKt.toPxVec3(vec3f, pxVec3);
            Vec3f vec3f2 = (Vec3f)this.targetDriveVelAngular;
            PxVec3 pxVec32 = PhysXExtensionsKt.createPxVec3($this$setDrive_u24lambda_u2415);
            Intrinsics.checkNotNullExpressionValue((Object)pxVec32, (String)"createPxVec3(...)");
            PxVec3 angularVel = PhysXExtensionsKt.toPxVec3(vec3f2, pxVec32);
            this.getJoint().setDriveVelocity(linearVel, angularVel);
            Unit unit = Unit.INSTANCE;
        }
    }

    private final LimitBehavior getLimitBehaviorAngularYZ() {
        LimitBehavior limitY = this.limitBehaviorAngularY;
        LimitBehavior limitZ = this.limitBehaviorAngularZ;
        LimitBehavior limitBehavior = limitY;
        float f = limitBehavior != null ? limitBehavior.getStiffness() : 0.0f;
        LimitBehavior limitBehavior2 = limitZ;
        float f2 = limitBehavior2 != null ? limitBehavior2.getStiffness() : 0.0f;
        float stiffness = Math.max(f, f2);
        LimitBehavior limitBehavior3 = limitY;
        f2 = limitBehavior3 != null ? limitBehavior3.getDamping() : 0.0f;
        LimitBehavior limitBehavior4 = limitZ;
        float f3 = limitBehavior4 != null ? limitBehavior4.getDamping() : 0.0f;
        float damping = Math.max(f2, f3);
        LimitBehavior limitBehavior5 = limitY;
        f3 = limitBehavior5 != null ? limitBehavior5.getRestitution() : 0.0f;
        LimitBehavior limitBehavior6 = limitZ;
        float f4 = limitBehavior6 != null ? limitBehavior6.getRestitution() : 0.0f;
        float restitution = Math.max(f3, f4);
        LimitBehavior limitBehavior7 = limitY;
        f4 = limitBehavior7 != null ? limitBehavior7.getBounceThreshold() : 0.0f;
        LimitBehavior limitBehavior8 = limitZ;
        float f5 = limitBehavior8 != null ? limitBehavior8.getBounceThreshold() : 0.0f;
        float bounceThreshold = Math.max(f4, f5);
        return new LimitBehavior(stiffness, damping, restitution, bounceThreshold);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\u00020\u0005*\u00020\u0006H\u0002J\f\u0010\u0007\u001a\u00020\u0006*\u00020\u0005H\u0002\u00a8\u0006\b"}, d2={"Lde/fabmax/kool/physics/joints/D6JointImpl$Companion;", "", "<init>", "()V", "toD6JointMotion", "Lde/fabmax/kool/physics/joints/D6JointMotion;", "Lphysx/extensions/PxD6MotionEnum;", "toPxD6MotionEnum", "kool-physics"})
    public static final class Companion {
        private Companion() {
        }

        private final D6JointMotion toD6JointMotion(PxD6MotionEnum $this$toD6JointMotion) {
            D6JointMotion d6JointMotion;
            switch (WhenMappings.$EnumSwitchMapping$0[$this$toD6JointMotion.ordinal()]) {
                case 1: {
                    d6JointMotion = D6JointMotion.Free;
                    break;
                }
                case 2: {
                    d6JointMotion = D6JointMotion.Limited;
                    break;
                }
                case 3: {
                    d6JointMotion = D6JointMotion.Locked;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return d6JointMotion;
        }

        private final PxD6MotionEnum toPxD6MotionEnum(D6JointMotion $this$toPxD6MotionEnum) {
            PxD6MotionEnum pxD6MotionEnum;
            switch (WhenMappings.$EnumSwitchMapping$1[$this$toPxD6MotionEnum.ordinal()]) {
                case 1: {
                    pxD6MotionEnum = PxD6MotionEnum.eFREE;
                    break;
                }
                case 2: {
                    pxD6MotionEnum = PxD6MotionEnum.eLIMITED;
                    break;
                }
                case 3: {
                    pxD6MotionEnum = PxD6MotionEnum.eLOCKED;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return pxD6MotionEnum;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 1, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;
            public static final /* synthetic */ int[] $EnumSwitchMapping$1;

            static {
                int[] nArray = new int[PxD6MotionEnum.values().length];
                try {
                    nArray[PxD6MotionEnum.eFREE.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[PxD6MotionEnum.eLIMITED.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[PxD6MotionEnum.eLOCKED.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
                nArray = new int[D6JointMotion.values().length];
                try {
                    nArray[D6JointMotion.Free.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[D6JointMotion.Limited.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[D6JointMotion.Locked.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$1 = nArray;
            }
        }
    }
}

