/*
 * Decompiled with CFR 0.152.
 */
package de.fabmax.kool.physics.geometry;

import de.fabmax.kool.math.AngleKt;
import de.fabmax.kool.math.MutableVec3f;
import de.fabmax.kool.math.Vec3f;
import de.fabmax.kool.math.spatial.BoundingBoxF;
import de.fabmax.kool.physics.geometry.CollisionGeometry;
import de.fabmax.kool.scene.geometry.CylinderProps;
import de.fabmax.kool.scene.geometry.MeshBuilder;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0010H\u0016R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0005\u00a8\u0006\u0013"}, d2={"Lde/fabmax/kool/physics/geometry/CylinderGeometry;", "Lde/fabmax/kool/physics/geometry/CollisionGeometry;", "length", "", "getLength", "()F", "radius", "getRadius", "generateMesh", "", "target", "Lde/fabmax/kool/scene/geometry/MeshBuilder;", "getBounds", "Lde/fabmax/kool/math/spatial/BoundingBoxF;", "result", "estimateInertiaForMass", "Lde/fabmax/kool/math/MutableVec3f;", "mass", "Companion", "kool-physics"})
public interface CylinderGeometry
extends CollisionGeometry {
    @NotNull
    public static final Companion Companion = de.fabmax.kool.physics.geometry.CylinderGeometry$Companion.$$INSTANCE;

    public float getLength();

    public float getRadius();

    @Override
    public void generateMesh(@NotNull MeshBuilder var1);

    @Override
    @NotNull
    public BoundingBoxF getBounds(@NotNull BoundingBoxF var1);

    @Override
    @NotNull
    public MutableVec3f estimateInertiaForMass(float var1, @NotNull MutableVec3f var2);

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"Lde/fabmax/kool/physics/geometry/CylinderGeometry$Companion;", "", "<init>", "()V", "convexMeshPoints", "", "Lde/fabmax/kool/math/Vec3f;", "length", "", "radius", "n", "", "kool-physics"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        @NotNull
        public final List<Vec3f> convexMeshPoints(float length, float radius, int n) {
            List points = new ArrayList();
            for (int i = 0; i < n; ++i) {
                float a = (float)i * 2.0f * (float)Math.PI / (float)n;
                float y = (float)Math.cos(a) * radius;
                float z = (float)Math.sin(a) * radius;
                points.add(new Vec3f(length * -0.5f, y, z));
                points.add(new Vec3f(length * 0.5f, y, z));
            }
            return points;
        }

        public static /* synthetic */ List convexMeshPoints$default(Companion companion, float f, float f2, int n, int n2, Object object) {
            if ((n2 & 4) != 0) {
                n = 32;
            }
            return companion.convexMeshPoints(f, f2, n);
        }

        static {
            $$INSTANCE = new Companion();
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    @SourceDebugExtension(value={"SMAP\nCylinderGeometry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CylinderGeometry.kt\nde/fabmax/kool/physics/geometry/CylinderGeometry$DefaultImpls\n+ 2 MeshBuilder.kt\nde/fabmax/kool/scene/geometry/MeshBuilder\n*L\n1#1,57:1\n57#2,2:58\n680#2,4:60\n59#2,2:64\n*S KotlinDebug\n*F\n+ 1 CylinderGeometry.kt\nde/fabmax/kool/physics/geometry/CylinderGeometry$DefaultImpls\n*L\n21#1:58,2\n24#1:60,4\n21#1:64,2\n*E\n"})
    public static final class DefaultImpls {
        public static void generateMesh(@NotNull CylinderGeometry $this, @NotNull MeshBuilder target) {
            CylinderProps props$iv;
            MeshBuilder meshBuilder;
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            MeshBuilder $this$generateMesh_u24lambda_u242 = meshBuilder = target;
            boolean bl = false;
            MeshBuilder this_$iv = $this$generateMesh_u24lambda_u242;
            boolean $i$f$withTransform = false;
            this_$iv.getTransform().push();
            MeshBuilder $this$generateMesh_u24lambda_u242_u24lambda_u241 = this_$iv;
            boolean bl2 = false;
            $this$generateMesh_u24lambda_u242_u24lambda_u241.rotate-YB8I3VQ(AngleKt.getDeg((float)90.0f), Vec3f.Companion.getZ_AXIS());
            MeshBuilder this_$iv2 = $this$generateMesh_u24lambda_u242_u24lambda_u241;
            boolean $i$f$cylinder = false;
            CylinderProps $this$generateMesh_u24lambda_u242_u24lambda_u241_u24lambda_u240 = props$iv = new CylinderProps();
            boolean bl3 = false;
            $this$generateMesh_u24lambda_u242_u24lambda_u241_u24lambda_u240.setHeight($this.getLength());
            $this$generateMesh_u24lambda_u242_u24lambda_u241_u24lambda_u240.setRadius($this.getRadius());
            $this$generateMesh_u24lambda_u242_u24lambda_u241_u24lambda_u240.setSteps(32);
            this_$iv2.cylinder(props$iv);
            this_$iv.getTransform().pop();
        }

        @NotNull
        public static BoundingBoxF getBounds(@NotNull CylinderGeometry $this, @NotNull BoundingBoxF result) {
            Intrinsics.checkNotNullParameter((Object)result, (String)"result");
            result.set(-$this.getLength() * 0.5f, -$this.getRadius(), -$this.getRadius(), $this.getLength() * 0.5f, $this.getRadius(), $this.getRadius());
            return result;
        }

        @NotNull
        public static MutableVec3f estimateInertiaForMass(@NotNull CylinderGeometry $this, float mass, @NotNull MutableVec3f result) {
            Intrinsics.checkNotNullParameter((Object)result, (String)"result");
            float ix = 0.5f * mass * $this.getRadius() * $this.getRadius();
            float iyz = 0.083333336f * mass * ((float)3 * $this.getRadius() * $this.getRadius() + $this.getLength() * $this.getLength());
            return result.set(ix, iyz, iyz);
        }
    }
}

